/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\r\u0010\u0013\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/ice4j/socket/SocketPool;", "", "address", "Ljava/net/SocketAddress;", "requestedNumSockets", "", "(Ljava/net/SocketAddress;I)V", "numSockets", "getNumSockets", "()I", "receiveSocket", "Ljava/net/DatagramSocket;", "getReceiveSocket", "()Ljava/net/DatagramSocket;", "sockets", "", "Lorg/ice4j/socket/SocketPool$SocketAndIndex;", "close", "", "getSendSocket", "getSendSocket$ice4j", "returnSocket", "socket", "returnSocket$ice4j", "send", "packet", "Ljava/net/DatagramPacket;", "SocketAndIndex", "ice4j"})
@SourceDebugExtension(value={"SMAP\nSocketPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketPool.kt\norg/ice4j/socket/SocketPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n2310#3,14:117\n1855#3,2:131\n*S KotlinDebug\n*F\n+ 1 SocketPool.kt\norg/ice4j/socket/SocketPool\n*L\n98#1:117,14\n112#1:131,2\n*E\n"})
public final class SocketPool {
    private final int numSockets;
    @NotNull
    private final List<SocketAndIndex> sockets;

    /*
     * WARNING - void declaration
     */
    public SocketPool(@NotNull SocketAddress address, int requestedNumSockets) {
        List list;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (!(requestedNumSockets >= 0)) {
            boolean $i$a$-require-SocketPool$22 = false;
            String $i$a$-require-SocketPool$22 = "RequestedNumSockets must be >= 0";
            throw new IllegalArgumentException($i$a$-require-SocketPool$22.toString());
        }
        this.numSockets = requestedNumSockets != 0 ? requestedNumSockets : Runtime.getRuntime().availableProcessors();
        List $i$a$-require-SocketPool$22 = list = CollectionsKt.createListBuilder();
        SocketPool socketPool = this;
        boolean bl = false;
        boolean multipleSockets = this.numSockets > 1;
        SocketAddress bindAddr = address;
        int n = this.numSockets;
        for (int i = 0; i < n; ++i) {
            void $this$sockets_u24lambda_u241;
            DatagramSocket sock = new DatagramSocket(null);
            if (multipleSockets) {
                sock.setReuseAddress(true);
            }
            sock.bind(bindAddr);
            if (i == 0 && multipleSockets) {
                Intrinsics.checkNotNullExpressionValue((Object)sock.getLocalSocketAddress(), (String)"getLocalSocketAddress(...)");
            }
            $this$sockets_u24lambda_u241.add(new SocketAndIndex(sock, 0));
        }
        socketPool.sockets = CollectionsKt.build((List)list);
    }

    public /* synthetic */ SocketPool(SocketAddress socketAddress, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(socketAddress, n);
    }

    public final int getNumSockets() {
        return this.numSockets;
    }

    @NotNull
    public final DatagramSocket getReceiveSocket() {
        return ((SocketAndIndex)CollectionsKt.last(this.sockets)).getSocket();
    }

    public final void send(@NotNull DatagramPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        SocketAndIndex sendSocket = this.getSendSocket$ice4j();
        sendSocket.getSocket().send(packet);
        this.returnSocket$ice4j(sendSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SocketAndIndex getSendSocket$ice4j() {
        if (this.numSockets == 1) {
            return (SocketAndIndex)CollectionsKt.first(this.sockets);
        }
        List<SocketAndIndex> list = this.sockets;
        synchronized (list) {
            Object t;
            boolean bl = false;
            Iterable $this$minBy$iv = this.sockets;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                SocketAndIndex it = (SocketAndIndex)minElem$iv;
                boolean bl2 = false;
                int minValue$iv = it.getCount();
                do {
                    Object e$iv = iterator$iv.next();
                    SocketAndIndex it2 = (SocketAndIndex)e$iv;
                    $i$a$-minByOrThrow-SocketPool$getSendSocket$1$min$1 = false;
                    int v$iv = it2.getCount();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            SocketAndIndex min = (SocketAndIndex)t;
            int n = min.getCount();
            min.setCount(n + 1);
            SocketAndIndex socketAndIndex = min;
            return socketAndIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void returnSocket$ice4j(@NotNull SocketAndIndex socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        List<SocketAndIndex> list = this.sockets;
        synchronized (list) {
            boolean bl = false;
            int n = socket.getCount();
            socket.setCount(n + -1);
            int n2 = n;
        }
    }

    public final void close() {
        Iterable $this$forEach$iv = this.sockets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SocketAndIndex it = (SocketAndIndex)element$iv;
            boolean bl = false;
            it.getSocket().close();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/ice4j/socket/SocketPool$SocketAndIndex;", "", "socket", "Ljava/net/DatagramSocket;", "count", "", "(Ljava/net/DatagramSocket;I)V", "getCount", "()I", "setCount", "(I)V", "getSocket", "()Ljava/net/DatagramSocket;", "ice4j"})
    public static final class SocketAndIndex {
        @NotNull
        private final DatagramSocket socket;
        private int count;

        public SocketAndIndex(@NotNull DatagramSocket socket, int count) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.socket = socket;
            this.count = count;
        }

        public /* synthetic */ SocketAndIndex(DatagramSocket datagramSocket, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(datagramSocket, n);
        }

        @NotNull
        public final DatagramSocket getSocket() {
            return this.socket;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }
    }
}

