/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 H\u0016J\u001a\u0010!\u001a\u00020\u00072\u0010\u0010\"\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010 H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0017H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0014\u00a2\u0006\u0002\u0010*J,\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lorg/jitsi/nlj/dtls/TlsClientImpl;", "Lorg/bouncycastle/tls/DefaultTlsClient;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyServerCertificate", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "clientCredentials", "Lorg/bouncycastle/tls/TlsCredentials;", "value", "", "srtpKeyingMaterial", "getSrtpKeyingMaterial", "()[B", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "getSessionToResume", "getAuthentication", "Lorg/bouncycastle/tls/TlsAuthentication;", "getClientExtensions", "Ljava/util/Hashtable;", "processServerExtensions", "serverExtensions", "getCipherSuites", "", "getHandshakeTimeoutMillis", "notifyHandshakeComplete", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nTlsClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsClientImpl.kt\norg/jitsi/nlj/dtls/TlsClientImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtilsKt\n*L\n1#1,171:1\n57#2,4:172\n63#2,4:176\n63#2,4:180\n63#2,4:186\n57#2,2:198\n60#2:202\n57#2,4:206\n75#2:211\n76#2:214\n296#3,2:184\n299#3,8:190\n307#3,2:200\n312#3:203\n316#3,2:204\n318#3:210\n319#3,2:212\n323#3:215\n*S KotlinDebug\n*F\n+ 1 TlsClientImpl.kt\norg/jitsi/nlj/dtls/TlsClientImpl\n*L\n136#1:172,4\n141#1:176,4\n147#1:180,4\n166#1:186,4\n166#1:198,2\n166#1:202\n169#1:206,4\n169#1:211\n169#1:214\n166#1:184,2\n166#1:190,8\n166#1:200,2\n166#1:203\n169#1:204,2\n169#1:210\n169#1:212,2\n169#1:215\n*E\n"})
public final class TlsClientImpl
extends DefaultTlsClient {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyServerCertificate;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    @Nullable
    private TlsCredentials clientCredentials;
    private byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsClientImpl(@NotNull CertificateInfo certificateInfo, @NotNull Function1<? super Certificate, Unit> notifyServerCertificate, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)certificateInfo, (String)"certificateInfo");
        Intrinsics.checkNotNullParameter(notifyServerCertificate, (String)"notifyServerCertificate");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super((TlsCrypto)DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo;
        this.notifyServerCertificate = notifyServerCertificate;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)((Object)this), (Logger)parentLogger, null, (int)2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"srtpKeyingMaterial");
        return null;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Nullable
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @NotNull
    public TlsAuthentication getAuthentication() {
        return new TlsAuthentication(this){
            final /* synthetic */ TlsClientImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) {
                Intrinsics.checkNotNullParameter((Object)certificateRequest, (String)"certificateRequest");
                if (TlsClientImpl.access$getClientCredentials$p(this.this$0) == null) {
                    TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters((TlsContext)TlsClientImpl.access$getContext$p$s489618374(this.this$0));
                    TlsCrypto tlsCrypto = TlsClientImpl.access$getContext$p$s489618374(this.this$0).getCrypto();
                    Intrinsics.checkNotNull((Object)tlsCrypto, (String)"null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
                    TlsClientImpl.access$setClientCredentials$p(this.this$0, (TlsCredentials)new BcDefaultTlsCredentialedSigner(tlsCryptoParameters, (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey((byte[])TlsClientImpl.access$getCertificateInfo$p(this.this$0).getKeyPair().getPrivate().getEncoded()), TlsClientImpl.access$getCertificateInfo$p(this.this$0).getCertificate(), TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)TlsClientImpl.access$getContext$p$s489618374(this.this$0).getServerVersion()) ? new SignatureAndHashAlgorithm(4, 3) : null));
                }
                TlsCredentials tlsCredentials = TlsClientImpl.access$getClientCredentials$p(this.this$0);
                Intrinsics.checkNotNull((Object)tlsCredentials);
                return tlsCredentials;
            }

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) {
                Intrinsics.checkNotNullParameter((Object)serverCertificate, (String)"serverCertificate");
                TlsClientImpl.access$getNotifyServerCertificate$p(this.this$0).invoke((Object)serverCertificate.getCertificate());
            }
        };
    }

    @NotNull
    public Hashtable<?, ?> getClientExtensions() {
        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions) == null) {
            if (clientExtensions == null) {
                clientExtensions = new Hashtable<Integer, byte[]>();
            }
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, (UseSRTPData)new UseSRTPData(CollectionsKt.toIntArray((Collection)SrtpConfig.Companion.getProtectionProfiles()), TlsUtils.EMPTY_BYTES));
        }
        Object object = new byte[]{0};
        clientExtensions.put(65281, (byte[])object);
        object = clientExtensions;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    public void processServerExtensions(@Nullable Hashtable<?, ?> serverExtensions) {
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(serverExtensions);
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNull((Object)protectionProfiles);
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable((int[])protectionProfiles));
    }

    @NotNull
    public int[] getCipherSuites() {
        return CollectionsKt.toIntArray((Collection)DtlsConfig.Companion.getConfig().getCipherSuites());
    }

    public int getHandshakeTimeoutMillis() {
        return (int)DtlsConfig.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info((Object)("Negotiated DTLS version " + this.context.getSecurityParameters().getNegotiatedVersion()));
        }
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            TlsSession newSession = tlsSession;
            boolean bl = false;
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl4 = false;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                        String newSessionIdHex = ByteBufferKt.toHex((ByteBuffer)byteBuffer);
                        logger.debug((Object)("Resumed DTLS session " + newSessionIdHex));
                    }
                }
            } else {
                TlsClientImpl $this$notifyHandshakeComplete_u24lambda_u241_u241 = this;
                boolean bl5 = false;
                Logger $this$cdebug$iv = $this$notifyHandshakeComplete_u24lambda_u241_u241.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl6 = false;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                    String newSessionIdHex = ByteBufferKt.toHex((ByteBuffer)byteBuffer);
                    logger.debug((Object)("Established DTLS session " + newSessionIdHex));
                }
                $this$notifyHandshakeComplete_u24lambda_u241_u241.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        byte[] byArray = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"exportKeyingMaterial(...)");
        this.srtpKeyingMaterial = byArray;
    }

    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[1];
        Intrinsics.checkNotNullExpressionValue((Object)ProtocolVersion.DTLSv12, (String)"DTLSv12");
        return protocolVersionArray;
    }

    /*
     * WARNING - void declaration
     */
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        void $this$notifyAlertRaised$iv;
        void alertDescription$iv;
        Logger logger = this.logger;
        short s = alertLevel;
        short s2 = alertDescription;
        String string = message;
        Throwable cause$iv = cause;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription$iv == false) {
            void $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                void var13_15 = $this$cdebug$iv$iv;
                boolean bl = false;
                var13_15.debug((Object)"close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u241$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            for (StackTraceElement el$iv : stackTraceElementArray) {
                ((Appendable)$this$notifyAlertRaised_u24lambda_u241$iv).append(el$iv.toString()).append('\n');
            }
            String string2 = $this$notifyAlertRaised_u24lambda_u241$iv.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(...)");
            String stack$iv = string2;
            void $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                void message$iv;
                void alertLevel$iv;
                void var13_16 = $this$cinfo$iv$iv;
                boolean bl2 = false;
                var13_16.info((Object)("Alert raised: level=" + (short)alertLevel$iv + ", description=" + (short)alertDescription$iv + ", message=" + (String)message$iv + " cause=" + cause$iv + " " + stack$iv));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        void $this$notifyAlertReceived$iv;
        Logger logger = this.logger;
        short s = alertLevel;
        short alertDescription$iv = alertDescription;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription$iv == 0) {
            void $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                void var9_11 = $this$cinfo$iv$iv;
                boolean bl = false;
                var9_11.info((Object)"close_notify received, connection closing");
            }
        } else {
            void alertLevel$iv;
            void $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            void var9_12 = $this$cerror$iv$iv;
            boolean bl = false;
            var9_12.error((Object)("Alert received: level=" + (short)alertLevel$iv + ", description=" + alertDescription$iv + " (" + AlertDescription.getName((short)alertDescription$iv) + ")"));
        }
    }

    public static final /* synthetic */ TlsCredentials access$getClientCredentials$p(TlsClientImpl $this) {
        return $this.clientCredentials;
    }

    public static final /* synthetic */ void access$setClientCredentials$p(TlsClientImpl $this, TlsCredentials tlsCredentials) {
        $this.clientCredentials = tlsCredentials;
    }

    public static final /* synthetic */ TlsClientContext access$getContext$p$s489618374(TlsClientImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ CertificateInfo access$getCertificateInfo$p(TlsClientImpl $this) {
        return $this.certificateInfo;
    }

    public static final /* synthetic */ Function1 access$getNotifyServerCertificate$p(TlsClientImpl $this) {
        return $this.notifyServerCertificate;
    }
}

