/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.PacketCache;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.RtcpFbNackPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jitsi/nlj/rtcp/NackHandler;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "packetCache", "Lorg/jitsi/nlj/util/PacketCache;", "onNackedPacketsReady", "Lorg/jitsi/nlj/PacketHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/PacketCache;Lorg/jitsi/nlj/PacketHandler;Lorg/jitsi/utils/logging2/Logger;)V", "numNacksReceived", "", "numNackedPackets", "numRetransmittedPackets", "numPacketsNotResentDueToDelay", "numCacheMisses", "logger", "currRtt", "", "rtcpPacketReceived", "", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "Ljava/time/Instant;", "onNackPacket", "nackPacket", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/RtcpFbNackPacket;", "onRttUpdate", "newRttMs", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nNackHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NackHandler.kt\norg/jitsi/nlj/rtcp/NackHandler\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n63#2,4:106\n63#2,4:111\n1869#3:110\n1870#3:115\n1869#3,2:116\n*S KotlinDebug\n*F\n+ 1 NackHandler.kt\norg/jitsi/nlj/rtcp/NackHandler\n*L\n58#1:106,4\n82#1:111,4\n65#1:110\n65#1:115\n86#1:116,2\n*E\n"})
public final class NackHandler
implements NodeStatsProducer,
RtcpListener,
EndpointConnectionStats.EndpointConnectionStatsListener {
    @NotNull
    private final PacketCache packetCache;
    @NotNull
    private final PacketHandler onNackedPacketsReady;
    private int numNacksReceived;
    private int numNackedPackets;
    private int numRetransmittedPackets;
    private int numPacketsNotResentDueToDelay;
    private int numCacheMisses;
    @NotNull
    private final Logger logger;
    private double currRtt;

    public NackHandler(@NotNull PacketCache packetCache, @NotNull PacketHandler onNackedPacketsReady, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)packetCache, (String)"packetCache");
        Intrinsics.checkNotNullParameter((Object)onNackedPacketsReady, (String)"onNackedPacketsReady");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.packetCache = packetCache;
        this.onNackedPacketsReady = onNackedPacketsReady;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.currRtt = -1.0;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (packet instanceof RtcpFbNackPacket) {
            this.onNackPacket((RtcpFbNackPacket)packet);
        }
    }

    private final void onNackPacket(RtcpFbNackPacket nackPacket) {
        int n;
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            n = 0;
            logger.debug((Object)("Nack received for " + nackPacket.getMediaSourceSsrc() + " " + nackPacket.getMissingSeqNums()));
        }
        long now = System.currentTimeMillis();
        n = this.numNacksReceived;
        this.numNacksReceived = n + 1;
        List nackedPackets = new ArrayList();
        long ssrc = nackPacket.getMediaSourceSsrc();
        this.numNackedPackets += nackPacket.getMissingSeqNums().size();
        Iterable $this$forEach$iv = nackPacket.getMissingSeqNums();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer missingSeqNum = (Integer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)missingSeqNum);
            if (this.packetCache.get(ssrc, missingSeqNum) != null) {
                int n2;
                int n3;
                boolean shouldResendPacket;
                ArrayCache.Container container;
                boolean bl2 = false;
                long delay = now - container.getTimeAdded();
                boolean bl3 = shouldResendPacket = this.currRtt == -1.0 || (double)delay >= Math.min(this.currRtt * 0.9, this.currRtt - (double)5);
                if (shouldResendPacket) {
                    Object t = container.getItem();
                    Intrinsics.checkNotNull(t);
                    nackedPackets.add(t);
                    this.packetCache.updateTimestamp(ssrc, missingSeqNum, now);
                    n3 = this.numRetransmittedPackets;
                    this.numRetransmittedPackets = n3 + 1;
                    n2 = n3;
                    continue;
                }
                Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
                Object t = container.getItem();
                Intrinsics.checkNotNull(t);
                Intrinsics.checkNotNullExpressionValue((Object)((RtpPacket)t).buffer, (String)"buffer");
                function1.invoke((Object)((RtpPacket)t).buffer);
                n3 = this.numPacketsNotResentDueToDelay;
                this.numPacketsNotResentDueToDelay = n3 + 1;
                n2 = n3;
                continue;
            }
            NackHandler $this$onNackPacket_u24lambda_u241_u241 = this;
            boolean bl4 = false;
            Logger $this$cdebug$iv2 = $this$onNackPacket_u24lambda_u241_u241.logger;
            boolean $i$f$cdebug2 = false;
            if ($this$cdebug$iv2.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv2;
                boolean bl5 = false;
                logger.debug((Object)("Nack'd packet " + ssrc + " " + missingSeqNum + " wasn't in cache, unable to retransmit"));
            }
            int n4 = $this$onNackPacket_u24lambda_u241_u241.numCacheMisses;
            $this$onNackPacket_u24lambda_u241_u241.numCacheMisses = n4 + 1;
        }
        $this$forEach$iv = nackedPackets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpPacket it = (RtpPacket)element$iv;
            boolean bl = false;
            PacketInfo packetInfo = new PacketInfo((Packet)it, 0, null, 6, null);
            packetInfo.setPacketOrigin(PacketOrigin.Retransmission);
            this.onNackedPacketsReady.processPacket(packetInfo);
        }
    }

    @Override
    public void onRttUpdate(double newRttMs) {
        this.currRtt = newRttMs;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = new NodeStatsBlock("Nack handler");
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("num_nack_packets_received", this.numNackedPackets);
        $this$getNodeStats_u24lambda_u240.addNumber("num_nacked_packets", this.numNackedPackets);
        $this$getNodeStats_u24lambda_u240.addNumber("num_retransmitted_packets", this.numRetransmittedPackets);
        $this$getNodeStats_u24lambda_u240.addNumber("num_packets_not_retransmitted", this.numPacketsNotResentDueToDelay);
        $this$getNodeStats_u24lambda_u240.addNumber("num_cache_misses", this.numCacheMisses);
        return nodeStatsBlock;
    }
}

