/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001:\u0001HB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*JH\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*H$J \u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$J\"\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$H$J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H$J\u0016\u00100\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00101\u001a\u000202H$J\u0017\u00104\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H&\u00a2\u0006\u0004\b5\u00106J\u0012\u00107\u001a\u0002082\b\b\u0002\u0010\u001f\u001a\u00020 H&J\b\u00109\u001a\u00020\u001eH&J\u001f\u0010A\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010B\u001a\u00020\u0012H\u0004\u00a2\u0006\u0004\bC\u0010DJ\u000e\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020<J\u000e\u0010G\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020<R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0018\u0010\u001a\u001a\u00020\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010>R\u000e\u0010?\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\n \n*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getDiagnosticContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "algorithmName", "", "getAlgorithmName", "()Ljava/lang/String;", "initBw", "Lorg/jitsi/nlj/util/Bandwidth;", "getInitBw-rlWvAKk", "()J", "setInitBw-_2icLw0", "(J)V", "minBw", "getMinBw-rlWvAKk", "setMinBw-_2icLw0", "maxBw", "getMaxBw-rlWvAKk", "setMaxBw-_2icLw0", "processPacketArrival", "", "now", "Ljava/time/Instant;", "sendTime", "recvTime", "seq", "", "size", "Lorg/jitsi/nlj/util/DataSize;", "ecn", "", "previouslyReportedLost", "", "doProcessPacketArrival", "processPacketLoss", "doProcessPacketLoss", "feedbackComplete", "doFeedbackComplete", "onRttUpdate", "newRtt", "Ljava/time/Duration;", "doRttUpdate", "getCurrentBw", "getCurrentBw-WElJv5I", "(Ljava/time/Instant;)J", "getStats", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "reset", "listeners", "Ljava/util/LinkedList;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "curBandwidth", "J", "lastBweLogTime", "minBweLogInterval", "reportBandwidthEstimate", "newValue", "reportBandwidthEstimate-ERFH51c", "(Ljava/time/Instant;J)V", "addListener", "listener", "removeListener", "StatisticsSnapshot", "jitsi-media-transform"})
public abstract class BandwidthEstimator {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private final LinkedList<TransportCcEngine.BandwidthListener> listeners;
    private long curBandwidth;
    @NotNull
    private Instant lastBweLogTime;
    private final Duration minBweLogInterval;

    public BandwidthEstimator(@NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.listeners = new LinkedList();
        this.curBandwidth = BandwidthKt.getBps(-1);
        this.lastBweLogTime = InstantKt.NEVER;
        this.minBweLogInterval = Duration.ofMillis(500L);
    }

    @NotNull
    protected final DiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    protected final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    @NotNull
    public abstract String getAlgorithmName();

    public abstract long getInitBw-rlWvAKk();

    public abstract void setInitBw-_2icLw0(long var1);

    public abstract long getMinBw-rlWvAKk();

    public abstract void setMinBw-_2icLw0(long var1);

    public abstract long getMaxBw-rlWvAKk();

    public abstract void setMaxBw-_2icLw0(long var1);

    public final void processPacketArrival(@NotNull Instant now, @Nullable Instant sendTime, @Nullable Instant recvTime, int seq, @NotNull DataSize size, byte ecn, boolean previouslyReportedLost) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_arrival", now);
            if (sendTime != null) {
                point.addField("sendTime", (Object)InstantKt.formatMilli((Instant)sendTime));
            }
            if (recvTime != null) {
                point.addField("recvTime", (Object)InstantKt.formatMilli((Instant)recvTime));
            }
            point.addField("seq", (Object)seq);
            point.addField("size", (Object)size.getBytes());
            if (ecn != 0) {
                point.addField("ecn", (Object)ecn);
            }
            point.addField("previouslyReportedLost", (Object)previouslyReportedLost);
            this.timeSeriesLogger.trace((Map)point);
        }
        this.doProcessPacketArrival(now, sendTime, recvTime, seq, size, ecn, previouslyReportedLost);
    }

    public static /* synthetic */ void processPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.processPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    protected abstract void doProcessPacketArrival(@NotNull Instant var1, @Nullable Instant var2, @Nullable Instant var3, int var4, @NotNull DataSize var5, byte var6, boolean var7);

    public static /* synthetic */ void doProcessPacketArrival$default(BandwidthEstimator bandwidthEstimator, Instant instant, Instant instant2, Instant instant3, int n, DataSize dataSize, byte by, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doProcessPacketArrival");
        }
        if ((n2 & 0x20) != 0) {
            by = 0;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        bandwidthEstimator.doProcessPacketArrival(instant, instant2, instant3, n, dataSize, by, bl);
    }

    public final void processPacketLoss(@NotNull Instant now, @Nullable Instant sendTime, int seq) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_packet_loss", now);
            if (sendTime != null) {
                point.addField("sendTime", (Object)InstantKt.formatMilli((Instant)sendTime));
            }
            point.addField("seq", (Object)seq);
            this.timeSeriesLogger.trace((Map)point);
        }
        this.doProcessPacketLoss(now, sendTime, seq);
    }

    protected abstract void doProcessPacketLoss(@NotNull Instant var1, @Nullable Instant var2, int var3);

    public final void feedbackComplete(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_feedback_complete", now);
            this.timeSeriesLogger.trace((Map)point);
        }
        this.doFeedbackComplete(now);
    }

    protected abstract void doFeedbackComplete(@NotNull Instant var1);

    public final void onRttUpdate(@NotNull Instant now, @NotNull Duration newRtt) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)newRtt, (String)"newRtt");
        if (this.timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_rtt", now);
            point.addField("rtt", (Object)DurationKt.formatMilli((Duration)newRtt));
            this.timeSeriesLogger.trace((Map)point);
        }
        this.doRttUpdate(now, newRtt);
    }

    protected abstract void doRttUpdate(@NotNull Instant var1, @NotNull Duration var2);

    public abstract long getCurrentBw-WElJv5I(@NotNull Instant var1);

    @NotNull
    public abstract StatisticsSnapshot getStats(@NotNull Instant var1);

    public static /* synthetic */ StatisticsSnapshot getStats$default(BandwidthEstimator bandwidthEstimator, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStats");
        }
        if ((n & 1) != 0) {
            Instant instant2 = Clock.systemUTC().instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"instant(...)");
            instant = instant2;
        }
        return bandwidthEstimator.getStats(instant);
    }

    public abstract void reset();

    protected final synchronized void reportBandwidthEstimate-ERFH51c(@NotNull Instant now, long l) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (this.timeSeriesLogger.isTraceEnabled() && (!Bandwidth.equals-impl0(l, this.curBandwidth) || Intrinsics.areEqual((Object)this.lastBweLogTime, (Object)InstantKt.NEVER) || Duration.between(this.lastBweLogTime, now).compareTo(this.minBweLogInterval) >= 0)) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("bwe_estimate", now);
            point.addField("bw", (Object)l);
            this.timeSeriesLogger.trace((Map)point);
            this.lastBweLogTime = now;
        }
        if (Bandwidth.equals-impl0(l, this.curBandwidth)) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TransportCcEngine.BandwidthListener listener = (TransportCcEngine.BandwidthListener)e;
            listener.bandwidthEstimationChanged-_2icLw0(l);
        }
        this.curBandwidth = l;
    }

    public final synchronized void addListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final synchronized void removeListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u000f\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020!J\u001d\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020&R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010*\u0004\b\u000b\u0010\fR+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015*\u0004\b\u0011\u0010\f\u00a8\u0006'"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "", "algorithmName", "", "currentEstimate", "Lorg/jitsi/nlj/util/Bandwidth;", "<init>", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "stats", "", "<set-?>", "getAlgorithmName$delegate", "(Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;)Ljava/lang/Object;", "getAlgorithmName", "()Ljava/lang/String;", "setAlgorithmName", "(Ljava/lang/String;)V", "getCurrentEstimate-rlWvAKk$delegate", "getCurrentEstimate-rlWvAKk", "()J", "setCurrentEstimate-_2icLw0", "(J)V", "getValue", "name", "getNumber", "", "promote", "n", "addNumber", "", "value", "addString", "addBoolean", "", "addBandwidth", "addBandwidth-ERFH51c", "(Ljava/lang/String;J)V", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nBandwidthEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandwidthEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,349:1\n1#2:350\n216#3,2:351\n*S KotlinDebug\n*F\n+ 1 BandwidthEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot\n*L\n340#1:351,2\n*E\n"})
    public static final class StatisticsSnapshot {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Map<String, Object> stats;

        private StatisticsSnapshot(String algorithmName, long currentEstimate) {
            Intrinsics.checkNotNullParameter((Object)algorithmName, (String)"algorithmName");
            this.stats = new LinkedHashMap();
            this.addString("algorithmName", algorithmName);
            this.addBandwidth-ERFH51c("currentEstimate", currentEstimate);
        }

        @NotNull
        public final String getAlgorithmName() {
            Map<String, Object> map = this.stats;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[0].getName());
        }

        public final void setAlgorithmName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            Map<String, Object> map = this.stats;
            map.put($$delegatedProperties[0].getName(), string);
        }

        private static Object getAlgorithmName$delegate(StatisticsSnapshot statisticsSnapshot) {
            return statisticsSnapshot.stats;
        }

        public final long getCurrentEstimate-rlWvAKk() {
            Map<String, Object> map = this.stats;
            return ((Bandwidth)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[1].getName())).unbox-impl();
        }

        public final void setCurrentEstimate-_2icLw0(long l) {
            Map<String, Object> map = this.stats;
            KProperty<Object> kProperty = $$delegatedProperties[1];
            Bandwidth bandwidth = Bandwidth.box-impl(l);
            map.put(kProperty.getName(), bandwidth);
        }

        private static Object getCurrentEstimate-rlWvAKk$delegate(StatisticsSnapshot statisticsSnapshot) {
            return statisticsSnapshot.stats;
        }

        @Nullable
        public final Object getValue(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.stats.get(name);
        }

        @Nullable
        public final Number getNumber(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = this.stats.get(name);
            return object instanceof Number ? (Number)((Number)object) : (Number)null;
        }

        private final Number promote(Number n) {
            Number number = n;
            return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long ? (Number)n.longValue() : (Number)(number instanceof Float || number instanceof Double ? (Number)n.doubleValue() : null);
        }

        public final void addNumber(@NotNull String name, @NotNull Number value) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Number number = this.promote(value);
                if (number == null) break block0;
                Number it = number;
                boolean bl = false;
                this.stats.put(name, it);
            }
        }

        public final void addString(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.stats.put(name, value);
        }

        public final void addBoolean(@NotNull String name, boolean value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.stats.put(name, value);
        }

        public final void addBandwidth-ERFH51c(@NotNull String name, long l) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.stats.put(name, Bandwidth.box-impl(l));
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            Map<String, Object> $this$forEach$iv = this.stats;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                Object object = value instanceof Bandwidth ? $this$toJson_u24lambda_u240.put((Object)name, (Object)((Bandwidth)value).unbox-impl()) : $this$toJson_u24lambda_u240.put((Object)name, value);
            }
            return orderedJsonObject;
        }

        public /* synthetic */ StatisticsSnapshot(String algorithmName, long currentEstimate, DefaultConstructorMarker $constructor_marker) {
            this(algorithmName, currentEstimate);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(StatisticsSnapshot.class, "algorithmName", "getAlgorithmName()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(StatisticsSnapshot.class, "currentEstimate", "getCurrentEstimate-rlWvAKk()J", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

