/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UnsignedKt;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.AcknowledgedBitrateEstimatorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.AimdRateControl;
import org.jitsi.nlj.rtp.bandwidthestimation2.AlrDetector;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthLimitedCause;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthUsage;
import org.jitsi.nlj.rtp.bandwidthestimation2.BweDefinesKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.CongestionWindowConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.CongestionWindowPushbackController;
import org.jitsi.nlj.rtp.bandwidthestimation2.DelayBasedBwe;
import org.jitsi.nlj.rtp.bandwidthestimation2.DelayIncreaseDetectorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedState;
import org.jitsi.nlj.rtp.bandwidthestimation2.MutableNetworkControlUpdate;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkAvailability;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControlUpdate;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControllerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkControllerInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.NetworkRouteChange;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacerConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeBitrateEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeClusterConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeController;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProcessInterval;
import org.jitsi.nlj.rtp.bandwidthestimation2.RemoteBitrateReport;
import org.jitsi.nlj.rtp.bandwidthestimation2.RoundTripTimeUpdate;
import org.jitsi.nlj.rtp.bandwidthestimation2.SendSideBandwidthEstimation;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacket;
import org.jitsi.nlj.rtp.bandwidthestimation2.StreamsConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.TargetRateConstraints;
import org.jitsi.nlj.rtp.bandwidthestimation2.TargetTransferRate;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportLossReport;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportPacketsFeedback;
import org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimator;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 p2\u00020\u0001:\u0002opB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\"H\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010.\u001a\u00020/H\u0002J\b\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020/R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010T\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010U\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010V\u001a\u0004\u0018\u00010RX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010X\u001a\n \n*\u0004\u0018\u00010/0/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010_\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010`\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010a\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u000e\u0010b\u001a\u00020cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010d\u001a\u0004\u0018\u00010eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020gX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020iX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u0010\u0010k\u001a\u00020RX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010SR\u000e\u0010l\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010m\u001a\u0004\u0018\u00010nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControllerInterface;", "config", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControllerConfig;", "googCcConfig", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcConfig;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControllerConfig;Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcConfig;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "kotlin.jvm.PlatformType", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "onNetworkAvailability", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkControlUpdate;", "msg", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkAvailability;", "onNetworkRouteChange", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/NetworkRouteChange;", "onProcessInterval", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProcessInterval;", "onRemoteBitrateReport", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/RemoteBitrateReport;", "onRoundTripTimeUpdate", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/RoundTripTimeUpdate;", "onSentPacket", "sentPacket", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SentPacket;", "onStreamsConfig", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/StreamsConfig;", "onTargetRateConstraints", "constraints", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TargetRateConstraints;", "clampConstraints", "", "resetConstraints", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "newConstraints", "onTransportLossReport", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportLossReport;", "updateCongestionWindowSize", "onTransportPacketsFeedback", "report", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportPacketsFeedback;", "getNetworkState", "atTime", "Ljava/time/Instant;", "maybeTriggerOnNetworkChanged", "update", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/MutableNetworkControlUpdate;", "getPacingRates", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacerConfig;", "trend", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimator;", "getStatistics", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$StatisticsSnapshot;", "now", "packetFeedbackOnly", "", "safeResetOnRouteChange", "safeResetAcknowledgedRate", "useMinAllocatableAsLowerBound", "limitProbesLowerThanThroughputEstimate", "rateControlSettings", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/CongestionWindowConfig;", "probeController", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeController;", "congestionWindowPushbackController", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/CongestionWindowPushbackController;", "bandwidthEstimation", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SendSideBandwidthEstimation;", "alrDetector", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetector;", "probeBitrateEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeBitrateEstimator;", "delayBasedBwe", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe;", "acknowledgedBitrateEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AcknowledgedBitrateEstimatorInterface;", "initialConfig", "minTargetRate", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "minDataRate", "maxDataRate", "startingRate", "firstPacketSent", "nextLossUpdate", "lostPacketsSinceLastLossUpdate", "", "expectedPacketsSinceLastLossUpdate", "feedbackMaxRtts", "Lkotlin/collections/ArrayDeque;", "", "lastLossBasedTargetRate", "lastPushbackTargetRate", "lastStableTargetRate", "lastLossBasedState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "lastEstimatedFractionLoss", "Lkotlin/UByte;", "lastEstimatedRoundTripTime", "Ljava/time/Duration;", "pacingFactor", "", "minTotalAllocatedBitrate", "maxPaddingRate", "previouslyInAlr", "currentDataWindow", "Lorg/jitsi/nlj/util/DataSize;", "StatisticsSnapshot", "Companion", "jitsi-media-transform"})
public final class GoogCcNetworkController
implements NetworkControllerInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final boolean packetFeedbackOnly;
    private final boolean safeResetOnRouteChange;
    private final boolean safeResetAcknowledgedRate;
    private final boolean useMinAllocatableAsLowerBound;
    private final boolean limitProbesLowerThanThroughputEstimate;
    @NotNull
    private final CongestionWindowConfig rateControlSettings;
    @NotNull
    private final ProbeController probeController;
    @Nullable
    private final CongestionWindowPushbackController congestionWindowPushbackController;
    @NotNull
    private final SendSideBandwidthEstimation bandwidthEstimation;
    @NotNull
    private final AlrDetector alrDetector;
    @NotNull
    private ProbeBitrateEstimator probeBitrateEstimator;
    @NotNull
    private DelayBasedBwe delayBasedBwe;
    @NotNull
    private AcknowledgedBitrateEstimatorInterface acknowledgedBitrateEstimator;
    @Nullable
    private NetworkControllerConfig initialConfig;
    private long minTargetRate;
    private long minDataRate;
    private long maxDataRate;
    @Nullable
    private Bandwidth startingRate;
    private boolean firstPacketSent;
    private Instant nextLossUpdate;
    private int lostPacketsSinceLastLossUpdate;
    private int expectedPacketsSinceLastLossUpdate;
    @NotNull
    private final ArrayDeque<Long> feedbackMaxRtts;
    private long lastLossBasedTargetRate;
    private long lastPushbackTargetRate;
    private long lastStableTargetRate;
    @NotNull
    private LossBasedState lastLossBasedState;
    @Nullable
    private UByte lastEstimatedFractionLoss;
    @NotNull
    private Duration lastEstimatedRoundTripTime;
    private double pacingFactor;
    private long minTotalAllocatedBitrate;
    private long maxPaddingRate;
    private boolean previouslyInAlr;
    @Nullable
    private DataSize currentDataWindow;
    @NotNull
    private static final Duration kLossUpdateInterval = DurationKt.getMs((int)1000);
    private static final double kDefaultPaceMultiplier = 2.5;
    private static final double kProbeDropThroughputFraction = 0.85;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(GoogCcNetworkController.class);

    /*
     * WARNING - void declaration
     */
    public GoogCcNetworkController(@NotNull NetworkControllerConfig config, @NotNull GoogCcConfig googCcConfig) {
        void it;
        DelayBasedBwe delayBasedBwe;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)googCcConfig, (String)"googCcConfig");
        this.logger = config.getParentLogger().createChildLogger(this.getClass().getName());
        this.diagnosticContext = config.getDiagnosticContext();
        this.packetFeedbackOnly = googCcConfig.getFeedbackOnly();
        this.useMinAllocatableAsLowerBound = true;
        this.limitProbesLowerThanThroughputEstimate = true;
        this.rateControlSettings = googCcConfig.getRateControlSettings();
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.probeController = new ProbeController(logger, this.diagnosticContext, null, 4, null);
        this.congestionWindowPushbackController = this.rateControlSettings.useCongestionWindowPushback() ? new CongestionWindowPushbackController() : null;
        Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        this.bandwidthEstimation = new SendSideBandwidthEstimation(logger2, this.diagnosticContext);
        this.alrDetector = new AlrDetector();
        Logger logger3 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"logger");
        this.probeBitrateEstimator = new ProbeBitrateEstimator(logger3, this.diagnosticContext);
        Logger logger4 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"logger");
        DelayBasedBwe delayBasedBwe2 = delayBasedBwe = new DelayBasedBwe(logger4, this.diagnosticContext);
        GoogCcNetworkController googCcNetworkController = this;
        boolean bl = false;
        it.setMinBitrate-_2icLw0(BweDefinesKt.getKCongestionControllerMinBitrate());
        googCcNetworkController.delayBasedBwe = delayBasedBwe;
        this.acknowledgedBitrateEstimator = AcknowledgedBitrateEstimatorInterface.Companion.create$default(AcknowledgedBitrateEstimatorInterface.Companion, null, 1, null);
        this.initialConfig = config;
        this.minTargetRate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.minDataRate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.maxDataRate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.nextLossUpdate = Instant.MIN;
        this.feedbackMaxRtts = new ArrayDeque();
        Bandwidth bandwidth = config.getConstraints().getStartingRate-4yB3KFE();
        Intrinsics.checkNotNull((Object)bandwidth);
        this.lastPushbackTargetRate = this.lastLossBasedTargetRate = bandwidth.unbox-impl();
        this.lastStableTargetRate = this.lastLossBasedTargetRate;
        this.lastLossBasedState = LossBasedState.kDelayBasedEstimate;
        this.lastEstimatedFractionLoss = UByte.box-impl((byte)0);
        this.lastEstimatedRoundTripTime = DurationKt.getMAX_DURATION();
        Double d = config.getStreamBasedConfig().getPacingFactor();
        this.pacingFactor = d != null ? d : 2.5;
        Bandwidth bandwidth2 = config.getStreamBasedConfig().getMinTotalAllocatedBitrate-4yB3KFE();
        this.minTotalAllocatedBitrate = bandwidth2 != null ? bandwidth2.unbox-impl() : Bandwidth.Companion.getZERO-rlWvAKk();
        Bandwidth bandwidth3 = config.getStreamBasedConfig().getMaxPaddingRate-4yB3KFE();
        this.maxPaddingRate = bandwidth3 != null ? bandwidth3.unbox-impl() : Bandwidth.Companion.getZERO-rlWvAKk();
    }

    @Override
    @NotNull
    public NetworkControlUpdate onNetworkAvailability(@NotNull NetworkAvailability msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return new NetworkControlUpdate(null, null, this.probeController.onNetworkAvailability(msg), null, 11, null);
    }

    @Override
    @NotNull
    public NetworkControlUpdate onNetworkRouteChange(@NotNull NetworkRouteChange msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.safeResetOnRouteChange) {
            Bandwidth estimatedBitrate = null;
            if (this.safeResetAcknowledgedRate) {
                estimatedBitrate = this.acknowledgedBitrateEstimator.bitrate-4yB3KFE();
                if (estimatedBitrate == null) {
                    estimatedBitrate = this.acknowledgedBitrateEstimator.peekRate-4yB3KFE();
                }
            } else {
                estimatedBitrate = Bandwidth.box-impl(this.bandwidthEstimation.targetRate-rlWvAKk());
            }
            if (estimatedBitrate != null) {
                if (msg.getConstraints().getStartingRate-4yB3KFE() != null) {
                    TargetRateConstraints targetRateConstraints = msg.getConstraints();
                    Bandwidth bandwidth = msg.getConstraints().getStartingRate-4yB3KFE();
                    Intrinsics.checkNotNull((Object)bandwidth);
                    targetRateConstraints.setStartingRate-eKiYIew(Bandwidth.box-impl(BandwidthKt.min-YUm52VA(bandwidth.unbox-impl(), estimatedBitrate.unbox-impl())));
                } else {
                    msg.getConstraints().setStartingRate-eKiYIew(estimatedBitrate);
                }
            }
        }
        this.acknowledgedBitrateEstimator = AcknowledgedBitrateEstimatorInterface.Companion.create$default(AcknowledgedBitrateEstimatorInterface.Companion, null, 1, null);
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.probeBitrateEstimator = new ProbeBitrateEstimator(logger, this.diagnosticContext);
        Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        this.delayBasedBwe = new DelayBasedBwe(logger2, this.diagnosticContext);
        this.bandwidthEstimation.onRouteChange();
        this.probeController.reset(msg.getAtTime());
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, this.resetConstraints(msg.getConstraints()), null, 11, null);
        this.maybeTriggerOnNetworkChanged(update, msg.getAtTime());
        return update;
    }

    @Override
    @NotNull
    public NetworkControlUpdate onProcessInterval(@NotNull ProcessInterval msg) {
        List<ProbeClusterConfig> probes;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
        if (this.initialConfig != null) {
            NetworkControllerConfig networkControllerConfig = this.initialConfig;
            Intrinsics.checkNotNull((Object)networkControllerConfig);
            update.setProbeClusterConfigs(this.resetConstraints(networkControllerConfig.getConstraints()));
            update.setPacerConfig(this.getPacingRates(msg.getAtTime()));
            NetworkControllerConfig networkControllerConfig2 = this.initialConfig;
            Intrinsics.checkNotNull((Object)networkControllerConfig2);
            if (networkControllerConfig2.getStreamBasedConfig().getRequestsAlrProbing() != null) {
                NetworkControllerConfig networkControllerConfig3 = this.initialConfig;
                Intrinsics.checkNotNull((Object)networkControllerConfig3);
                Boolean bl = networkControllerConfig3.getStreamBasedConfig().getRequestsAlrProbing();
                Intrinsics.checkNotNull((Object)bl);
                this.probeController.enablePeriodicAlrProbing(bl);
            }
            NetworkControllerConfig networkControllerConfig4 = this.initialConfig;
            Intrinsics.checkNotNull((Object)networkControllerConfig4);
            if (networkControllerConfig4.getStreamBasedConfig().getEnableRepeatedInitialProbing() != null) {
                NetworkControllerConfig networkControllerConfig5 = this.initialConfig;
                Intrinsics.checkNotNull((Object)networkControllerConfig5);
                Boolean bl = networkControllerConfig5.getStreamBasedConfig().getEnableRepeatedInitialProbing();
                Intrinsics.checkNotNull((Object)bl);
                this.probeController.enableRepeatedInitialProbing(bl);
            }
            NetworkControllerConfig networkControllerConfig6 = this.initialConfig;
            Intrinsics.checkNotNull((Object)networkControllerConfig6);
            Bandwidth totalBitrate = networkControllerConfig6.getStreamBasedConfig().getMaxTotalAllocatedBitrate-4yB3KFE();
            if (totalBitrate != null) {
                probes = this.probeController.onMaxTotalAllocatedBitrate-SimD6oM(totalBitrate.unbox-impl(), msg.getAtTime());
                update.getProbeClusterConfigs().addAll((Collection<ProbeClusterConfig>)probes);
            }
            this.initialConfig = null;
        }
        if (this.congestionWindowPushbackController != null && msg.getPacerQueue() != null) {
            this.congestionWindowPushbackController.updatePacingQueue(MathKt.roundToLong((double)msg.getPacerQueue().getBytes()));
        }
        this.bandwidthEstimation.updateEstimate(msg.getAtTime());
        Long startTimeMs = this.alrDetector.getApplicationLimitedRegionStartTime();
        this.probeController.setAlrStartTimeMs(startTimeMs);
        probes = this.probeController.process(msg.getAtTime());
        update.getProbeClusterConfigs().addAll((Collection<ProbeClusterConfig>)probes);
        if (this.rateControlSettings.useCongestionWindow() && !this.feedbackMaxRtts.isEmpty()) {
            this.updateCongestionWindowSize();
        }
        if (this.congestionWindowPushbackController != null && this.currentDataWindow != null) {
            DataSize dataSize = this.currentDataWindow;
            Intrinsics.checkNotNull((Object)dataSize);
            this.congestionWindowPushbackController.setDataWindow(dataSize);
        } else {
            update.setCongestionWindow(this.currentDataWindow);
        }
        this.maybeTriggerOnNetworkChanged(update, msg.getAtTime());
        return update;
    }

    @Override
    @NotNull
    public NetworkControlUpdate onRemoteBitrateReport(@NotNull RemoteBitrateReport msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.packetFeedbackOnly) {
            this.logger.error((Object)"Received REMB for packet feedback only GoogCC");
            return new NetworkControlUpdate(null, null, null, null, 15, null);
        }
        this.bandwidthEstimation.updateReceiverEstimate-ERFH51c(msg.getReceiveTime(), msg.getBandwidth-rlWvAKk());
        timeSeriesLogger.trace(() -> GoogCcNetworkController.onRemoteBitrateReport$lambda$0(this, msg));
        return new NetworkControlUpdate(null, null, null, null, 15, null);
    }

    @Override
    @NotNull
    public NetworkControlUpdate onRoundTripTimeUpdate(@NotNull RoundTripTimeUpdate msg) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.packetFeedbackOnly || msg.getSmoothed()) {
            return new NetworkControlUpdate(null, null, null, null, 15, null);
        }
        boolean bl2 = bl = !Intrinsics.areEqual((Object)msg.getRoundTripTime(), (Object)Duration.ZERO);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.delayBasedBwe.onRttUpdate(msg.getRoundTripTime());
        this.bandwidthEstimation.updateRtt(msg.getRoundTripTime(), msg.getReceiveTime());
        return new NetworkControlUpdate(null, null, null, null, 15, null);
    }

    @Override
    @NotNull
    public NetworkControlUpdate onSentPacket(@NotNull SentPacket sentPacket) {
        Intrinsics.checkNotNullParameter((Object)sentPacket, (String)"sentPacket");
        this.alrDetector.onBytesSent(MathKt.roundToLong((double)sentPacket.getSize().getBytes()), sentPacket.getSendTime().toEpochMilli());
        this.acknowledgedBitrateEstimator.setAlr(this.alrDetector.getApplicationLimitedRegionStartTime() != null);
        if (!this.firstPacketSent) {
            this.firstPacketSent = true;
            Instant instant = sentPacket.getSendTime();
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            this.bandwidthEstimation.updatePropagationRtt(instant, duration);
        }
        this.bandwidthEstimation.onSentPacket(sentPacket);
        if (this.congestionWindowPushbackController != null) {
            this.congestionWindowPushbackController.updateOutstandingData(MathKt.roundToLong((double)sentPacket.getDataInFlight().getBytes()));
            MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
            this.maybeTriggerOnNetworkChanged(update, sentPacket.getSendTime());
            return update;
        }
        return new NetworkControlUpdate(null, null, null, null, 15, null);
    }

    @Override
    @NotNull
    public NetworkControlUpdate onStreamsConfig(@NotNull StreamsConfig msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
        if (msg.getRequestsAlrProbing() != null) {
            this.probeController.enablePeriodicAlrProbing(msg.getRequestsAlrProbing());
        }
        if (msg.getMaxTotalAllocatedBitrate-4yB3KFE() != null) {
            update.setProbeClusterConfigs(this.probeController.onMaxTotalAllocatedBitrate-SimD6oM(msg.getMaxTotalAllocatedBitrate-4yB3KFE().unbox-impl(), msg.getAtTime()));
        }
        boolean pacingChanged = false;
        if (msg.getPacingFactor() != null && !Intrinsics.areEqual((Double)msg.getPacingFactor(), (double)this.pacingFactor)) {
            this.pacingFactor = msg.getPacingFactor();
            pacingChanged = true;
        }
        if (msg.getMinTotalAllocatedBitrate-4yB3KFE() != null && !Bandwidth.equals-impl(this.minTotalAllocatedBitrate, msg.getMinTotalAllocatedBitrate-4yB3KFE())) {
            this.minTotalAllocatedBitrate = msg.getMinTotalAllocatedBitrate-4yB3KFE().unbox-impl();
            pacingChanged = true;
            if (this.useMinAllocatableAsLowerBound) {
                this.clampConstraints();
                this.delayBasedBwe.setMinBitrate-_2icLw0(this.minDataRate);
                this.bandwidthEstimation.setMinMaxBitrate-YUm52VA(this.minDataRate, this.maxDataRate);
            }
        }
        if (msg.getMaxPaddingRate-4yB3KFE() != null) {
            Bandwidth bandwidth = msg.getMaxPaddingRate-4yB3KFE();
            long l = this.maxPaddingRate;
            Bandwidth bandwidth2 = bandwidth;
            if (!(bandwidth2 == null ? false : Bandwidth.equals-impl0(bandwidth2.unbox-impl(), l))) {
                this.maxPaddingRate = msg.getMaxPaddingRate-4yB3KFE().unbox-impl();
                pacingChanged = true;
            }
        }
        if (pacingChanged) {
            update.setPacerConfig(this.getPacingRates(msg.getAtTime()));
        }
        return update;
    }

    @Override
    @NotNull
    public NetworkControlUpdate onTargetRateConstraints(@NotNull TargetRateConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
        update.setProbeClusterConfigs(this.resetConstraints(constraints));
        this.maybeTriggerOnNetworkChanged(update, constraints.getAtTime());
        return update;
    }

    private final void clampConstraints() {
        this.minDataRate = BandwidthKt.max-YUm52VA(this.minTargetRate, BweDefinesKt.getKCongestionControllerMinBitrate());
        if (this.useMinAllocatableAsLowerBound) {
            this.minDataRate = BandwidthKt.max-YUm52VA(this.minDataRate, this.minTotalAllocatedBitrate);
        }
        if (Bandwidth.compareTo-_2icLw0(this.maxDataRate, this.minDataRate) < 0) {
            this.logger.warn((Object)("max bitrate " + Bandwidth.toString-impl(this.maxDataRate) + " smaller than min bitrate " + Bandwidth.toString-impl(this.minDataRate)));
            this.maxDataRate = this.minDataRate;
        }
        if (this.startingRate != null) {
            Bandwidth bandwidth = this.startingRate;
            Intrinsics.checkNotNull((Object)bandwidth);
            if (Bandwidth.compareTo-_2icLw0(bandwidth.unbox-impl(), this.minDataRate) < 0) {
                Bandwidth bandwidth2 = this.startingRate;
                Intrinsics.checkNotNull((Object)bandwidth2);
                this.logger.warn((Object)("start bitrate " + Bandwidth.toString-impl(bandwidth2.unbox-impl()) + " smaller than min bitrate " + Bandwidth.toString-impl(this.minDataRate)));
                this.startingRate = Bandwidth.box-impl(this.minDataRate);
            }
        }
    }

    private final List<ProbeClusterConfig> resetConstraints(TargetRateConstraints newConstraints) {
        Bandwidth bandwidth = newConstraints.getMinDataRate-4yB3KFE();
        this.minTargetRate = bandwidth != null ? bandwidth.unbox-impl() : Bandwidth.Companion.getZERO-rlWvAKk();
        Bandwidth bandwidth2 = newConstraints.getMaxDataRate-4yB3KFE();
        this.maxDataRate = bandwidth2 != null ? bandwidth2.unbox-impl() : Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.startingRate = newConstraints.getStartingRate-4yB3KFE();
        this.clampConstraints();
        this.bandwidthEstimation.setBitrates-gCQKabc(this.startingRate, this.minDataRate, this.maxDataRate, newConstraints.getAtTime());
        if (this.startingRate != null) {
            Bandwidth bandwidth3 = this.startingRate;
            Intrinsics.checkNotNull((Object)bandwidth3);
            this.delayBasedBwe.setStartBitrate-_2icLw0(bandwidth3.unbox-impl());
        }
        this.delayBasedBwe.setMinBitrate-_2icLw0(this.minDataRate);
        Bandwidth bandwidth4 = this.startingRate;
        return this.probeController.setBitrates-JpFWP7k(this.minDataRate, bandwidth4 != null ? bandwidth4.unbox-impl() : Bandwidth.Companion.getZERO-rlWvAKk(), this.maxDataRate, newConstraints.getAtTime());
    }

    @Override
    @NotNull
    public NetworkControlUpdate onTransportLossReport(@NotNull TransportLossReport msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.packetFeedbackOnly) {
            return new NetworkControlUpdate(null, null, null, null, 15, null);
        }
        long totalPacketsDelta = msg.getPacketsReceivedDelta() + msg.getPacketsLostDelta();
        this.bandwidthEstimation.updatePacketsLost(msg.getPacketsLostDelta(), totalPacketsDelta, msg.getReceiveTime());
        return new NetworkControlUpdate(null, null, null, null, 15, null);
    }

    private final void updateCongestionWindowSize() {
        Duration minFeedbackMaxRtt = DurationKt.getMs((long)((Number)((Object)CollectionsKt.minOrThrow((Iterable)((Iterable)this.feedbackMaxRtts)))).longValue());
        DataSize kMinCwnd = DataSizeKt.getBytes(3000);
        Duration timeWindow = minFeedbackMaxRtt.plus(DurationKt.getMs((int)this.rateControlSettings.getCongestionWindowAdditionalTimeMs()));
        Intrinsics.checkNotNull((Object)timeWindow);
        DataSize dataWindow = BandwidthKt.times-SimD6oM(this.lastLossBasedTargetRate, timeWindow);
        if (this.currentDataWindow != null) {
            DataSize dataSize = this.currentDataWindow;
            Intrinsics.checkNotNull((Object)dataSize);
            dataWindow = DataSizeKt.max(kMinCwnd, dataWindow.plus(dataSize).div(2.0));
        } else {
            dataWindow = DataSizeKt.max(kMinCwnd, dataWindow);
        }
        this.currentDataWindow = dataWindow;
    }

    @Override
    @NotNull
    public NetworkControlUpdate onTransportPacketsFeedback(@NotNull TransportPacketsFeedback report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        if (report.getPacketFeedbacks().isEmpty()) {
            return new NetworkControlUpdate(null, null, null, null, 15, null);
        }
        if (this.congestionWindowPushbackController != null) {
            this.congestionWindowPushbackController.updateOutstandingData(MathKt.roundToLong((double)report.getDataInFlight().getBytes()));
        }
        Duration maxFeedbackRtt = DurationKt.getMIN_DURATION();
        Duration minPropagationRtt = DurationKt.getMAX_DURATION();
        Instant maxRecvTime = Instant.MIN;
        List<PacketResult> feedbacks = report.receivedWithSendInfo();
        for (PacketResult packetResult : feedbacks) {
            Instant instant = maxRecvTime;
            Intrinsics.checkNotNull((Object)instant);
            maxRecvTime = InstantKt.max((Instant)instant, (Instant)packetResult.getReceiveTime());
        }
        for (PacketResult packetResult : feedbacks) {
            Duration feedbackRtt = Duration.between(packetResult.getSentPacket().getSendTime(), report.getFeedbackTime());
            Duration minPendingTime = Duration.between(packetResult.getReceiveTime(), maxRecvTime);
            Duration propagationRtt = feedbackRtt.minus(minPendingTime);
            Intrinsics.checkNotNull((Object)feedbackRtt);
            maxFeedbackRtt = DurationKt.max((Duration)maxFeedbackRtt, (Duration)feedbackRtt);
            Intrinsics.checkNotNull((Object)propagationRtt);
            minPropagationRtt = DurationKt.min((Duration)minPropagationRtt, (Duration)propagationRtt);
        }
        if (DurationKt.isFinite((Duration)maxFeedbackRtt)) {
            this.feedbackMaxRtts.add((Object)DurationKt.toRoundedMillis((Duration)maxFeedbackRtt));
            int kMaxFeedbackRttWindow = 32;
            if (this.feedbackMaxRtts.size() > kMaxFeedbackRttWindow) {
                this.feedbackMaxRtts.removeFirst();
            }
            this.bandwidthEstimation.updatePropagationRtt(report.getFeedbackTime(), minPropagationRtt);
        }
        if (this.packetFeedbackOnly) {
            if (!this.feedbackMaxRtts.isEmpty()) {
                long sumRttMs = CollectionsKt.sumOfLong((Iterable)((Iterable)this.feedbackMaxRtts));
                long meanRttMs = sumRttMs / (long)this.feedbackMaxRtts.size();
                if (this.delayBasedBwe != null) {
                    this.delayBasedBwe.onRttUpdate(DurationKt.getMs((long)meanRttMs));
                }
            }
            Duration feedbackMinRtt = DurationKt.getMAX_DURATION();
            for (PacketResult packetFeedback : feedbacks) {
                Duration pendingTime = Duration.between(packetFeedback.getReceiveTime(), maxRecvTime);
                Duration rtt = Duration.between(packetFeedback.getSentPacket().getSendTime(), report.getFeedbackTime()).minus(pendingTime);
                Intrinsics.checkNotNull((Object)rtt);
                feedbackMinRtt = DurationKt.min((Duration)rtt, (Duration)feedbackMinRtt);
            }
            if (DurationKt.isFinite((Duration)feedbackMinRtt)) {
                this.bandwidthEstimation.updateRtt(feedbackMinRtt, report.getFeedbackTime());
            }
            this.expectedPacketsSinceLastLossUpdate += report.packetsWithFeedback().size();
            for (PacketResult packetFeedback : report.packetsWithFeedback()) {
                if (packetFeedback.isReceived()) continue;
                ++this.lostPacketsSinceLastLossUpdate;
            }
            if (report.getFeedbackTime().compareTo(this.nextLossUpdate) > 0) {
                this.nextLossUpdate = report.getFeedbackTime().plus(kLossUpdateInterval);
                this.bandwidthEstimation.updatePacketsLost(this.lostPacketsSinceLastLossUpdate, this.expectedPacketsSinceLastLossUpdate, report.getFeedbackTime());
                this.expectedPacketsSinceLastLossUpdate = 0;
                this.lostPacketsSinceLastLossUpdate = 0;
            }
        }
        Long alrStartTime = this.alrDetector.getApplicationLimitedRegionStartTime();
        if (this.previouslyInAlr && alrStartTime == null) {
            long l = report.getFeedbackTime().toEpochMilli();
            this.acknowledgedBitrateEstimator.setAlrEndedTime(report.getFeedbackTime());
            this.probeController.setAlrEndedTimeMs(l);
        }
        this.previouslyInAlr = alrStartTime != null;
        this.acknowledgedBitrateEstimator.incomingPacketFeedbackVector(report.sortedByReceiveTime());
        Bandwidth bandwidth = this.acknowledgedBitrateEstimator.bitrate-4yB3KFE();
        this.bandwidthEstimation.setAcknowledgedRate-DepZXxQ(bandwidth, report.getFeedbackTime());
        for (PacketResult feedback : report.sortedByReceiveTime()) {
            if (feedback.getSentPacket().getPacingInfo().getProbeClusterId() == -1) continue;
            this.probeBitrateEstimator.handleProbeAndEstimateBitrate-VeXOdVA(feedback);
        }
        Bandwidth probeBitrate = this.probeBitrateEstimator.fetchAndResetLastEstimatedBitrate-4yB3KFE();
        if (this.limitProbesLowerThanThroughputEstimate && probeBitrate != null && bandwidth != null) {
            long limit = BandwidthKt.min-YUm52VA(this.delayBasedBwe.lastEstimate-rlWvAKk(), Bandwidth.times-WElJv5I(bandwidth.unbox-impl(), 0.85));
            probeBitrate = Bandwidth.box-impl(BandwidthKt.max-YUm52VA(probeBitrate.unbox-impl(), limit));
        }
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
        boolean recoveredFromOveruse = false;
        DelayBasedBwe.Result result = this.delayBasedBwe.incomingPacketFeedbackVector-nJqwPh4(report, bandwidth, probeBitrate, alrStartTime != null);
        if (result.getUpdated()) {
            if (result.getProbe()) {
                this.bandwidthEstimation.setSendBitrate-SimD6oM(result.getTargetBitrate-rlWvAKk(), report.getFeedbackTime());
            }
            this.bandwidthEstimation.updateDelayBasedEstimate-ERFH51c(report.getFeedbackTime(), result.getTargetBitrate-rlWvAKk());
        }
        this.bandwidthEstimation.updateLossBasedEstimator-92-q-Mk(report, result.getDelayDetectorState(), probeBitrate, alrStartTime != null);
        if (result.getUpdated()) {
            this.maybeTriggerOnNetworkChanged(update, report.getFeedbackTime());
        }
        if (recoveredFromOveruse = result.getRecoveredFromOveruse()) {
            this.probeController.setAlrStartTimeMs(alrStartTime);
            List<ProbeClusterConfig> probes = this.probeController.requestProbe(report.getFeedbackTime());
            update.getProbeClusterConfigs().addAll((Collection<ProbeClusterConfig>)probes);
        }
        if (this.rateControlSettings.useCongestionWindow() && DurationKt.isFinite((Duration)maxFeedbackRtt)) {
            this.updateCongestionWindowSize();
        }
        if (this.congestionWindowPushbackController != null && this.currentDataWindow != null) {
            DataSize dataSize = this.currentDataWindow;
            Intrinsics.checkNotNull((Object)dataSize);
            this.congestionWindowPushbackController.setDataWindow(dataSize);
        } else {
            update.setCongestionWindow(this.currentDataWindow);
        }
        return update;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkControlUpdate getNetworkState(@NotNull Instant atTime) {
        void $this$getNetworkState_u24lambda_u240;
        TargetTransferRate targetTransferRate;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        MutableNetworkControlUpdate update = new MutableNetworkControlUpdate(null, null, null, null, 15, null);
        TargetTransferRate targetTransferRate2 = targetTransferRate = new TargetTransferRate();
        MutableNetworkControlUpdate mutableNetworkControlUpdate = update;
        boolean bl = false;
        $this$getNetworkState_u24lambda_u240.getNetworkEstimate().setAtTime(atTime);
        UByte uByte = this.lastEstimatedFractionLoss;
        $this$getNetworkState_u24lambda_u240.getNetworkEstimate().setLossRateRatio((float)UnsignedKt.uintToDouble((int)((uByte != null ? uByte.unbox-impl() : (byte)0) & 0xFF)) / 255.0f);
        $this$getNetworkState_u24lambda_u240.getNetworkEstimate().setRoundTripTime(this.lastEstimatedRoundTripTime);
        $this$getNetworkState_u24lambda_u240.getNetworkEstimate().setBwePeriod(this.delayBasedBwe.getExpectedBwePeriod());
        $this$getNetworkState_u24lambda_u240.setAtTime(atTime);
        if (this.rateControlSettings.useCongestionWindowDropFrameOnly()) {
            $this$getNetworkState_u24lambda_u240.setTargetRate-_2icLw0(this.lastLossBasedTargetRate);
        } else {
            $this$getNetworkState_u24lambda_u240.setTargetRate-_2icLw0(this.lastPushbackTargetRate);
        }
        $this$getNetworkState_u24lambda_u240.setTargetRate-_2icLw0(this.lastPushbackTargetRate);
        $this$getNetworkState_u24lambda_u240.setStableTargetRate-_2icLw0(this.bandwidthEstimation.getEstimatedLinkCapacity-rlWvAKk());
        mutableNetworkControlUpdate.setTargetRate(targetTransferRate);
        update.setPacerConfig(this.getPacingRates(atTime));
        update.setCongestionWindow(this.currentDataWindow);
        return update;
    }

    private final void maybeTriggerOnNetworkChanged(MutableNetworkControlUpdate update, Instant atTime) {
        byte fractionLoss = this.bandwidthEstimation.fractionLoss-w2LRezQ();
        Duration roundTripTime = this.bandwidthEstimation.roundTripTime();
        long lossBasedTargetRate = this.bandwidthEstimation.targetRate-rlWvAKk();
        LossBasedState lossBasedState = this.bandwidthEstimation.lossBasedState();
        long pushbackTargetRate = lossBasedTargetRate;
        double cwndReduceRatio = 0.0;
        if (this.congestionWindowPushbackController != null) {
            int pushbackRate = this.congestionWindowPushbackController.updateTargetBitrate((int)lossBasedTargetRate);
            pushbackRate = Math.max(this.bandwidthEstimation.getMinBitrate(), pushbackRate);
            pushbackTargetRate = BandwidthKt.getBps(pushbackRate);
            if (this.rateControlSettings.useCongestionWindowDropFrameOnly()) {
                cwndReduceRatio = (double)(lossBasedTargetRate - pushbackTargetRate) / (double)lossBasedTargetRate;
            }
        }
        long stableTargetRate = this.bandwidthEstimation.getEstimatedLinkCapacity-rlWvAKk();
        stableTargetRate = BandwidthKt.min-YUm52VA(stableTargetRate, pushbackTargetRate);
        if (!(Bandwidth.equals-impl0(lossBasedTargetRate, this.lastLossBasedTargetRate) && lossBasedState == this.lastLossBasedState && UByte.equals-impl((byte)fractionLoss, (Object)this.lastEstimatedFractionLoss) && Intrinsics.areEqual((Object)roundTripTime, (Object)this.lastEstimatedRoundTripTime) && Bandwidth.equals-impl0(pushbackTargetRate, this.lastPushbackTargetRate) && Bandwidth.equals-impl0(stableTargetRate, this.lastStableTargetRate))) {
            this.lastLossBasedTargetRate = lossBasedTargetRate;
            this.lastPushbackTargetRate = pushbackTargetRate;
            this.lastEstimatedFractionLoss = UByte.box-impl((byte)fractionLoss);
            this.lastEstimatedRoundTripTime = roundTripTime;
            this.lastStableTargetRate = stableTargetRate;
            this.lastLossBasedState = lossBasedState;
            this.alrDetector.setEstimatedBitrate((int)lossBasedTargetRate);
            Duration bwePeriod = this.delayBasedBwe.getExpectedBwePeriod();
            TargetTransferRate targetRateMsg = new TargetTransferRate();
            targetRateMsg.setAtTime(atTime);
            if (this.rateControlSettings.useCongestionWindowDropFrameOnly()) {
                targetRateMsg.setTargetRate-_2icLw0(lossBasedTargetRate);
                targetRateMsg.setCwndReduceRatio(cwndReduceRatio);
            } else {
                targetRateMsg.setTargetRate-_2icLw0(pushbackTargetRate);
            }
            targetRateMsg.setStableTargetRate-_2icLw0(stableTargetRate);
            targetRateMsg.getNetworkEstimate().setAtTime(atTime);
            targetRateMsg.getNetworkEstimate().setRoundTripTime(roundTripTime);
            targetRateMsg.getNetworkEstimate().setLossRateRatio((float)UnsignedKt.uintToDouble((int)(fractionLoss & 0xFF)) / 255.0f);
            targetRateMsg.getNetworkEstimate().setBwePeriod(bwePeriod);
            update.setTargetRate(targetRateMsg);
            List<ProbeClusterConfig> probes = this.probeController.setEstimatedBitrate-ZbyzzGk(lossBasedTargetRate, GoogCcNetworkController.Companion.getBandwidthLimitedCause(this.bandwidthEstimation.lossBasedState(), this.bandwidthEstimation.isRttAboveLimit(), this.delayBasedBwe.lastState()), atTime);
            update.getProbeClusterConfigs().addAll((Collection<ProbeClusterConfig>)probes);
            update.setPacerConfig(this.getPacingRates(atTime));
            this.logger.debug((Object)("bwe " + atTime + ": pushback_target_bps=" + this.lastPushbackTargetRate + " estimate_bps=" + lossBasedTargetRate));
        }
    }

    private final PacerConfig getPacingRates(Instant atTime) {
        long pacingRate = Bandwidth.times-WElJv5I(BandwidthKt.max-YUm52VA(this.minTotalAllocatedBitrate, this.lastLossBasedTargetRate), this.pacingFactor);
        long paddingRate = this.lastLossBasedState == LossBasedState.kIncreaseUsingPadding ? BandwidthKt.max-YUm52VA(this.maxPaddingRate, this.lastLossBasedTargetRate) : this.maxPaddingRate;
        paddingRate = BandwidthKt.min-YUm52VA(paddingRate, this.lastPushbackTargetRate);
        PacerConfig msg = new PacerConfig();
        msg.setAtTime(atTime);
        msg.setTimeWindow(DurationKt.getSecs((int)1));
        msg.setDataWindow(BandwidthKt.times-SimD6oM(pacingRate, msg.getTimeWindow()));
        msg.setPadWindow(BandwidthKt.times-SimD6oM(paddingRate, msg.getTimeWindow()));
        return msg;
    }

    private final TrendlineEstimator trend() {
        DelayIncreaseDetectorInterface delayIncreaseDetectorInterface = this.delayBasedBwe.getDelayDetector();
        Intrinsics.checkNotNull((Object)delayIncreaseDetectorInterface, (String)"null cannot be cast to non-null type org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimator");
        return (TrendlineEstimator)delayIncreaseDetectorInterface;
    }

    @NotNull
    public final StatisticsSnapshot getStatistics(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        NetworkControlUpdate stateUpdate = this.getNetworkState(now);
        TargetTransferRate targetTransferRate = stateUpdate.getTargetRate();
        Intrinsics.checkNotNull((Object)targetTransferRate);
        TargetTransferRate target = targetTransferRate;
        PacerConfig pacing = stateUpdate.getPacerConfig();
        DataSize dataSize = stateUpdate.getCongestionWindow();
        if (dataSize == null) {
            dataSize = DataSize.Companion.getINFINITY();
        }
        DataSize congestionWindow = dataSize;
        Instant instant = target.getAtTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"<get-atTime>(...)");
        PacerConfig pacerConfig = pacing;
        PacerConfig pacerConfig2 = pacing;
        return new StatisticsSnapshot(instant, target.getNetworkEstimate().getRoundTripTime(), target.getTargetRate-rlWvAKk(), target.getStableTargetRate-rlWvAKk(), pacerConfig != null ? Bandwidth.box-impl(pacerConfig.dataRate-rlWvAKk()) : null, pacerConfig2 != null ? Bandwidth.box-impl(pacerConfig2.padRate-rlWvAKk()) : null, congestionWindow, this.delayBasedBwe.getRateControl().getRateControlState(), this.delayBasedBwe.getRateControl().getLinkCapacity().getEstimate-4yB3KFE(), this.trend().getPrevTrend(), this.trend().getPrevModifiedTrend(), this.trend().getThreshold(), this.acknowledgedBitrateEstimator.bitrate-4yB3KFE(), target.getNetworkEstimate().getLossRateRatio(), this.bandwidthEstimation.targetRate-rlWvAKk(), this.lastLossBasedState, this.currentDataWindow, this.lastPushbackTargetRate, this.previouslyInAlr, null);
    }

    private static final Map onRemoteBitrateReport$lambda$0(GoogCcNetworkController this$0, RemoteBitrateReport $msg) {
        return (Map)this$0.diagnosticContext.makeTimeSeriesPoint("REMB_BW", $msg.getReceiveTime()).addField("REMB_kbps", (Object)Bandwidth.getKbps-impl($msg.getBandwidth-rlWvAKk()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$Companion;", "", "<init>", "()V", "kLossUpdateInterval", "Ljava/time/Duration;", "kDefaultPaceMultiplier", "", "kProbeDropThroughputFraction", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "getBandwidthLimitedCause", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthLimitedCause;", "lossBasedState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "isRttAboveLimit", "", "bandwidthUsage", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        private final BandwidthLimitedCause getBandwidthLimitedCause(LossBasedState lossBasedState, boolean isRttAboveLimit, BandwidthUsage bandwidthUsage) {
            BandwidthLimitedCause bandwidthLimitedCause;
            if (bandwidthUsage == BandwidthUsage.kBwOverusing || bandwidthUsage == BandwidthUsage.kBwUnderusing) {
                return BandwidthLimitedCause.kDelayBasedLimitedDelayIncreased;
            }
            if (isRttAboveLimit) {
                return BandwidthLimitedCause.kRttBasedBackOffHighRtt;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[lossBasedState.ordinal()]) {
                case 1: {
                    bandwidthLimitedCause = BandwidthLimitedCause.kLossLimitedBwe;
                    break;
                }
                case 2: {
                    bandwidthLimitedCause = BandwidthLimitedCause.kLossLimitedBwe;
                    break;
                }
                case 3: {
                    bandwidthLimitedCause = BandwidthLimitedCause.kLossLimitedBweIncreasing;
                    break;
                }
                case 4: {
                    bandwidthLimitedCause = BandwidthLimitedCause.kDelayBasedLimited;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bandwidthLimitedCause;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LossBasedState.values().length];
                try {
                    nArray[LossBasedState.kDecreasing.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LossBasedState.kIncreaseUsingPadding.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LossBasedState.kIncreasing.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LossBasedState.kDelayBasedEstimate.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u00a9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0007\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u001b\u001a\u00020\u0007\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0013\u0010\b\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b'\u0010%R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00101R\u0011\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010)R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b7\u0010%R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010,R\u0013\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b;\u0010%R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006D"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/GoogCcNetworkController$StatisticsSnapshot;", "", "time", "Ljava/time/Instant;", "rtt", "Ljava/time/Duration;", "target", "Lorg/jitsi/nlj/util/Bandwidth;", "stableTarget", "pacing", "padding", "window", "Lorg/jitsi/nlj/util/DataSize;", "rateControlState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;", "stableEstimate", "trendline", "", "trendlineModifiedOffset", "trendlineOffsetThreshold", "acknowledgedRate", "lossRatio", "", "sendSideTarget", "lossBasedState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "dataWindow", "pushbackTarget", "inAlr", "", "<init>", "(Ljava/time/Instant;Ljava/time/Duration;JJLorg/jitsi/nlj/util/Bandwidth;Lorg/jitsi/nlj/util/Bandwidth;Lorg/jitsi/nlj/util/DataSize;Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;Lorg/jitsi/nlj/util/Bandwidth;DDDLorg/jitsi/nlj/util/Bandwidth;FJLorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;Lorg/jitsi/nlj/util/DataSize;JZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getTime", "()Ljava/time/Instant;", "getRtt", "()Ljava/time/Duration;", "getTarget-rlWvAKk", "()J", "J", "getStableTarget-rlWvAKk", "getPacing-4yB3KFE", "()Lorg/jitsi/nlj/util/Bandwidth;", "getPadding-4yB3KFE", "getWindow", "()Lorg/jitsi/nlj/util/DataSize;", "getRateControlState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;", "getStableEstimate-4yB3KFE", "getTrendline", "()D", "getTrendlineModifiedOffset", "getTrendlineOffsetThreshold", "getAcknowledgedRate-4yB3KFE", "getLossRatio", "()F", "getSendSideTarget-rlWvAKk", "getLossBasedState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "getDataWindow", "getPushbackTarget-rlWvAKk", "getInAlr", "()Z", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "addToTimeSeriesPoint", "", "point", "Lorg/jitsi/utils/logging/DiagnosticContext$TimeSeriesPoint;", "jitsi-media-transform"})
    public static final class StatisticsSnapshot {
        @NotNull
        private final Instant time;
        @NotNull
        private final Duration rtt;
        private final long target;
        private final long stableTarget;
        @Nullable
        private final Bandwidth pacing;
        @Nullable
        private final Bandwidth padding;
        @NotNull
        private final DataSize window;
        @NotNull
        private final AimdRateControl.RateControlState rateControlState;
        @Nullable
        private final Bandwidth stableEstimate;
        private final double trendline;
        private final double trendlineModifiedOffset;
        private final double trendlineOffsetThreshold;
        @Nullable
        private final Bandwidth acknowledgedRate;
        private final float lossRatio;
        private final long sendSideTarget;
        @NotNull
        private final LossBasedState lossBasedState;
        @Nullable
        private final DataSize dataWindow;
        private final long pushbackTarget;
        private final boolean inAlr;

        private StatisticsSnapshot(Instant time, Duration rtt, long target, long stableTarget, Bandwidth pacing, Bandwidth padding, DataSize window, AimdRateControl.RateControlState rateControlState, Bandwidth stableEstimate, double trendline, double trendlineModifiedOffset, double trendlineOffsetThreshold, Bandwidth acknowledgedRate, float lossRatio, long sendSideTarget, LossBasedState lossBasedState, DataSize dataWindow, long pushbackTarget, boolean inAlr) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)rtt, (String)"rtt");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)((Object)rateControlState), (String)"rateControlState");
            Intrinsics.checkNotNullParameter((Object)((Object)lossBasedState), (String)"lossBasedState");
            this.time = time;
            this.rtt = rtt;
            this.target = target;
            this.stableTarget = stableTarget;
            this.pacing = pacing;
            this.padding = padding;
            this.window = window;
            this.rateControlState = rateControlState;
            this.stableEstimate = stableEstimate;
            this.trendline = trendline;
            this.trendlineModifiedOffset = trendlineModifiedOffset;
            this.trendlineOffsetThreshold = trendlineOffsetThreshold;
            this.acknowledgedRate = acknowledgedRate;
            this.lossRatio = lossRatio;
            this.sendSideTarget = sendSideTarget;
            this.lossBasedState = lossBasedState;
            this.dataWindow = dataWindow;
            this.pushbackTarget = pushbackTarget;
            this.inAlr = inAlr;
        }

        @NotNull
        public final Instant getTime() {
            return this.time;
        }

        @NotNull
        public final Duration getRtt() {
            return this.rtt;
        }

        public final long getTarget-rlWvAKk() {
            return this.target;
        }

        public final long getStableTarget-rlWvAKk() {
            return this.stableTarget;
        }

        @Nullable
        public final Bandwidth getPacing-4yB3KFE() {
            return this.pacing;
        }

        @Nullable
        public final Bandwidth getPadding-4yB3KFE() {
            return this.padding;
        }

        @NotNull
        public final DataSize getWindow() {
            return this.window;
        }

        @NotNull
        public final AimdRateControl.RateControlState getRateControlState() {
            return this.rateControlState;
        }

        @Nullable
        public final Bandwidth getStableEstimate-4yB3KFE() {
            return this.stableEstimate;
        }

        public final double getTrendline() {
            return this.trendline;
        }

        public final double getTrendlineModifiedOffset() {
            return this.trendlineModifiedOffset;
        }

        public final double getTrendlineOffsetThreshold() {
            return this.trendlineOffsetThreshold;
        }

        @Nullable
        public final Bandwidth getAcknowledgedRate-4yB3KFE() {
            return this.acknowledgedRate;
        }

        public final float getLossRatio() {
            return this.lossRatio;
        }

        public final long getSendSideTarget-rlWvAKk() {
            return this.sendSideTarget;
        }

        @NotNull
        public final LossBasedState getLossBasedState() {
            return this.lossBasedState;
        }

        @Nullable
        public final DataSize getDataWindow() {
            return this.dataWindow;
        }

        public final long getPushbackTarget-rlWvAKk() {
            return this.pushbackTarget;
        }

        public final boolean getInAlr() {
            return this.inAlr;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put((Object)"time", (Object)this.time.toEpochMilli());
            $this$toJson_u24lambda_u240.put((Object)"rtt", (Object)DurationKt.toDouble((Duration)this.rtt));
            $this$toJson_u24lambda_u240.put((Object)"target", (Object)this.target);
            $this$toJson_u24lambda_u240.put((Object)"stable_target", (Object)this.stableTarget);
            Bandwidth bandwidth = this.pacing;
            $this$toJson_u24lambda_u240.put((Object)"pacing", (Object)(bandwidth != null ? (Number)bandwidth.unbox-impl() : (Number)Double.NaN));
            Bandwidth bandwidth2 = this.padding;
            $this$toJson_u24lambda_u240.put((Object)"padding", (Object)(bandwidth2 != null ? (Number)bandwidth2.unbox-impl() : (Number)Double.NaN));
            $this$toJson_u24lambda_u240.put((Object)"window", (Object)this.window.getBytes());
            $this$toJson_u24lambda_u240.put((Object)"rate_control_state", (Object)this.rateControlState.name());
            Bandwidth bandwidth3 = this.stableEstimate;
            $this$toJson_u24lambda_u240.put((Object)"stable_estimate", (Object)(bandwidth3 != null ? (Number)bandwidth3.unbox-impl() : (Number)Double.NaN));
            $this$toJson_u24lambda_u240.put((Object)"trendline", (Object)this.trendline);
            $this$toJson_u24lambda_u240.put((Object)"trendline_modified_offset", (Object)this.trendlineModifiedOffset);
            $this$toJson_u24lambda_u240.put((Object)"trendline_modified_threshold", (Object)this.trendlineOffsetThreshold);
            Bandwidth bandwidth4 = this.acknowledgedRate;
            $this$toJson_u24lambda_u240.put((Object)"acknowledged_rate", (Object)(bandwidth4 != null ? (Number)bandwidth4.unbox-impl() : (Number)Double.NaN));
            $this$toJson_u24lambda_u240.put((Object)"loss_ratio", (Object)Float.valueOf(this.lossRatio));
            $this$toJson_u24lambda_u240.put((Object)"send_side_target", (Object)this.sendSideTarget);
            $this$toJson_u24lambda_u240.put((Object)"last_loss_based_state", (Object)this.lossBasedState.name());
            DataSize dataSize = this.dataWindow;
            $this$toJson_u24lambda_u240.put((Object)"data_window", (Object)(dataSize != null ? dataSize.getBytes() : Double.NaN));
            $this$toJson_u24lambda_u240.put((Object)"pushback_target", (Object)this.pushbackTarget);
            $this$toJson_u24lambda_u240.put((Object)"in_alr", (Object)this.inAlr);
            return orderedJsonObject;
        }

        public final void addToTimeSeriesPoint(@NotNull DiagnosticContext.TimeSeriesPoint point) {
            DiagnosticContext.TimeSeriesPoint timeSeriesPoint;
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            DiagnosticContext.TimeSeriesPoint $this$addToTimeSeriesPoint_u24lambda_u240 = timeSeriesPoint = point;
            boolean bl = false;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("rtt", (Object)DurationKt.toDouble((Duration)this.rtt));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("target", (Object)this.target);
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("stable_target", (Object)this.stableTarget);
            Bandwidth bandwidth = this.pacing;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("pacing", (Object)(bandwidth != null ? (Number)bandwidth.unbox-impl() : (Number)Double.NaN));
            Bandwidth bandwidth2 = this.padding;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("padding", (Object)(bandwidth2 != null ? (Number)bandwidth2.unbox-impl() : (Number)Double.NaN));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("window", (Object)this.window.getBytes());
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("rate_control_state", (Object)this.rateControlState.name());
            Bandwidth bandwidth3 = this.stableEstimate;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("stable_estimate", (Object)(bandwidth3 != null ? (Number)bandwidth3.unbox-impl() : (Number)Double.NaN));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("trendline", (Object)this.trendline);
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("trendline_modified_offset", (Object)this.trendlineModifiedOffset);
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("trendline_modified_threshold", (Object)this.trendlineOffsetThreshold);
            Bandwidth bandwidth4 = this.acknowledgedRate;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("acknowledged_rate", (Object)(bandwidth4 != null ? (Number)bandwidth4.unbox-impl() : (Number)Double.NaN));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("loss_ratio", (Object)Float.valueOf(this.lossRatio));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("send_side_target", (Object)this.sendSideTarget);
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("last_loss_based_state", (Object)this.lossBasedState.name());
            DataSize dataSize = this.dataWindow;
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("data_window", (Object)(dataSize != null ? dataSize.getBytes() : Double.NaN));
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("pushback_target", (Object)this.pushbackTarget);
            $this$addToTimeSeriesPoint_u24lambda_u240.addField("in_alr", (Object)this.inAlr);
        }

        public /* synthetic */ StatisticsSnapshot(Instant time, Duration rtt, long target, long stableTarget, Bandwidth pacing, Bandwidth padding, DataSize window, AimdRateControl.RateControlState rateControlState, Bandwidth stableEstimate, double trendline, double trendlineModifiedOffset, double trendlineOffsetThreshold, Bandwidth acknowledgedRate, float lossRatio, long sendSideTarget, LossBasedState lossBasedState, DataSize dataWindow, long pushbackTarget, boolean inAlr, DefaultConstructorMarker $constructor_marker) {
            this(time, rtt, target, stableTarget, pacing, padding, window, rateControlState, stableEstimate, trendline, trendlineModifiedOffset, trendlineOffsetThreshold, acknowledgedRate, lossRatio, sendSideTarget, lossBasedState, dataWindow, pushbackTarget, inAlr);
        }
    }
}

