/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.av1;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorReader;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorStatelessSubset;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyException;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BM\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B+\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0017J\b\u0010'\u001a\u00020#H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0000H\u0016J\u001c\u00104\u001a\u0004\u0018\u0001052\b\b\u0002\u00106\u001a\u00020\u00052\b\b\u0002\u00107\u001a\u000208J\u0006\u00109\u001a\u00020:R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0014\u0010%\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010!R\u0013\u0010.\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006;"}, d2={"Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "Lorg/jitsi/nlj/rtp/ParsedVideoPacket;", "buffer", "", "offset", "", "length", "av1DDHeaderExtensionId", "encodingId", "descriptor", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;", "statelessDescriptor", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorStatelessSubset;", "frameInfo", "Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "<init>", "([BIIIILorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorStatelessSubset;Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;)V", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "templateDependencyStructure", "Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/rtp/rtp/RtpPacket;ILorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;Lorg/jitsi/utils/logging2/Logger;)V", "getDescriptor", "()Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;", "setDescriptor", "(Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;)V", "getStatelessDescriptor", "()Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorStatelessSubset;", "getFrameInfo", "()Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "getAv1DDHeaderExtensionId", "()I", "isKeyframe", "", "()Z", "isStartOfFrame", "isEndOfFrame", "meetsRoutingNeeds", "layerIds", "", "getLayerIds", "()Ljava/util/Collection;", "frameNumber", "getFrameNumber", "activeDecodeTargets", "getActiveDecodeTargets", "()Ljava/lang/Integer;", "toString", "", "clone", "getScalabilityStructure", "Lorg/jitsi/nlj/RtpEncodingDesc;", "eid", "baseFrameRate", "", "reencodeDdExt", "", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAv1DDPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDPacket.kt\norg/jitsi/nlj/rtp/codec/av1/Av1DDPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public final class Av1DDPacket
extends ParsedVideoPacket {
    @Nullable
    private Av1DependencyDescriptorHeaderExtension descriptor;
    @NotNull
    private final Av1DependencyDescriptorStatelessSubset statelessDescriptor;
    @Nullable
    private final FrameInfo frameInfo;
    private final int av1DDHeaderExtensionId;

    @Nullable
    public final Av1DependencyDescriptorHeaderExtension getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@Nullable Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension) {
        this.descriptor = av1DependencyDescriptorHeaderExtension;
    }

    @NotNull
    public final Av1DependencyDescriptorStatelessSubset getStatelessDescriptor() {
        return this.statelessDescriptor;
    }

    @Nullable
    public final FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    public final int getAv1DDHeaderExtensionId() {
        return this.av1DDHeaderExtensionId;
    }

    private Av1DDPacket(byte[] buffer, int offset, int length, int av1DDHeaderExtensionId, int encodingId, Av1DependencyDescriptorHeaderExtension descriptor, Av1DependencyDescriptorStatelessSubset statelessDescriptor, FrameInfo frameInfo) {
        super(buffer, offset, length, encodingId);
        this.descriptor = descriptor;
        this.statelessDescriptor = statelessDescriptor;
        this.frameInfo = frameInfo;
        this.av1DDHeaderExtensionId = av1DDHeaderExtensionId;
    }

    /*
     * WARNING - void declaration
     */
    public Av1DDPacket(@NotNull RtpPacket packet, int av1DDHeaderExtensionId, @Nullable Av1TemplateDependencyStructure templateDependencyStructure, @NotNull Logger logger) {
        Av1DDPacket av1DDPacket;
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension;
        Av1DDPacket av1DDPacket2;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullExpressionValue((Object)packet.buffer, (String)"buffer");
        super(packet.buffer, packet.offset, packet.length, -1);
        this.av1DDHeaderExtensionId = av1DDHeaderExtensionId;
        RtpPacket.HeaderExtension ddExt = packet.getHeaderExtension(av1DDHeaderExtensionId);
        if (ddExt == null) {
            boolean $i$a$-requireNotNull-Av1DDPacket$22 = false;
            String $i$a$-requireNotNull-Av1DDPacket$22 = "Packet did not have Dependency Descriptor";
            throw new IllegalArgumentException($i$a$-requireNotNull-Av1DDPacket$22.toString());
        }
        Av1DependencyDescriptorReader parser2 = new Av1DependencyDescriptorReader(ddExt);
        Av1DDPacket av1DDPacket3 = this;
        try {
            av1DDPacket2 = av1DDPacket3;
            av1DependencyDescriptorHeaderExtension = parser2.parse(templateDependencyStructure);
        }
        catch (Av1DependencyException av1DependencyException) {
            void e;
            av1DDPacket2 = av1DDPacket3;
            logger.warn((Object)("Could not parse AV1 Dependency Descriptor for ssrc " + packet.getSsrc() + " seq " + packet.getSequenceNumber() + ": " + e.getMessage()));
            av1DependencyDescriptorHeaderExtension = null;
        }
        av1DDPacket2.descriptor = av1DependencyDescriptorHeaderExtension;
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension2 = this.descriptor;
        this.statelessDescriptor = av1DependencyDescriptorHeaderExtension2 != null ? (Av1DependencyDescriptorStatelessSubset)av1DependencyDescriptorHeaderExtension2 : parser2.parseStateless();
        av1DDPacket3 = this;
        try {
            av1DDPacket = av1DDPacket3;
            Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension3 = this.descriptor;
            av1DependencyDescriptorHeaderExtension = av1DependencyDescriptorHeaderExtension3 != null ? av1DependencyDescriptorHeaderExtension3.getFrameInfo() : null;
        }
        catch (Av1DependencyException e) {
            av1DDPacket = av1DDPacket3;
            logger.warn((Object)("Could not extract frame info from AV1 Dependency Descriptor for ssrc " + packet.getSsrc() + " seq " + packet.getSequenceNumber() + ": " + e.getMessage()));
            av1DependencyDescriptorHeaderExtension = null;
        }
        av1DDPacket.frameInfo = av1DependencyDescriptorHeaderExtension;
    }

    @Override
    public boolean isKeyframe() {
        return this.statelessDescriptor.getNewTemplateDependencyStructure() != null;
    }

    @Override
    public boolean isStartOfFrame() {
        return this.statelessDescriptor.getStartOfFrame();
    }

    @Override
    public boolean isEndOfFrame() {
        return this.statelessDescriptor.getEndOfFrame();
    }

    @Override
    public boolean meetsRoutingNeeds() {
        return true;
    }

    @Override
    @NotNull
    public Collection<Integer> getLayerIds() {
        Collection<Integer> collection;
        Object object = this.frameInfo;
        if (object != null && (object = object.getDtisPresent()) != null) {
            collection = (Collection<Integer>)object;
        } else {
            Av1DDPacket $this$_get_layerIds__u24lambda_u240 = this;
            boolean bl = false;
            collection = super.getLayerIds();
        }
        return collection;
    }

    public final int getFrameNumber() {
        return this.statelessDescriptor.getFrameNumber();
    }

    @Nullable
    public final Integer getActiveDecodeTargets() {
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = this.descriptor;
        return av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getActiveDecodeTargetsBitmask() : null;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        block0: {
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(super.toString());
            FrameInfo frameInfo = this.frameInfo;
            $this$toString_u24lambda_u240.append(", DTIs=" + (frameInfo != null ? frameInfo.getDtisPresent() : null));
            Integer n = this.getActiveDecodeTargets();
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$toString_u24lambda_u240.append(", ActiveTargets=" + it);
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public Av1DDPacket clone() {
        Av1DDPacket av1DDPacket;
        Av1DependencyDescriptorHeaderExtension descriptor;
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = this.descriptor;
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension2 = descriptor = av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.clone() : null;
        Av1DependencyDescriptorStatelessSubset statelessDescriptor = av1DependencyDescriptorHeaderExtension2 != null ? (Av1DependencyDescriptorStatelessSubset)av1DependencyDescriptorHeaderExtension2 : this.statelessDescriptor.clone();
        Av1DDPacket it = av1DDPacket = new Av1DDPacket(this.cloneBuffer(10), 10, this.length, this.av1DDHeaderExtensionId, this.getEncodingId(), descriptor, statelessDescriptor, this.frameInfo);
        boolean bl = false;
        this.postClone(it);
        return av1DDPacket;
    }

    @Nullable
    public final RtpEncodingDesc getScalabilityStructure(int eid, double baseFrameRate) {
        Av1DependencyDescriptorHeaderExtension descriptor = this.descriptor;
        if (descriptor == null) {
            boolean bl = false;
            String string = "Can't get scalability structure from packet without a descriptor";
            throw new IllegalArgumentException(string.toString());
        }
        return Av1DDPacketKt.getScalabilityStructure(descriptor, this.getSsrc(), eid, baseFrameRate);
    }

    public static /* synthetic */ RtpEncodingDesc getScalabilityStructure$default(Av1DDPacket av1DDPacket, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            d = 30.0;
        }
        return av1DDPacket.getScalabilityStructure(n, d);
    }

    public final void reencodeDdExt() {
        Av1DependencyDescriptorHeaderExtension descriptor = this.descriptor;
        if (descriptor == null) {
            boolean $i$a$-requireNotNull-Av1DDPacket$reencodeDdExt$22 = false;
            String $i$a$-requireNotNull-Av1DDPacket$reencodeDdExt$22 = "Can't re-encode extension from a packet without a descriptor";
            throw new IllegalArgumentException($i$a$-requireNotNull-Av1DDPacket$reencodeDdExt$22.toString());
        }
        RtpPacket.HeaderExtension ext = this.getHeaderExtension(this.av1DDHeaderExtensionId);
        if (ext == null || ext.getDataLengthBytes() != descriptor.getEncodedLength()) {
            this.removeHeaderExtension(this.av1DDHeaderExtensionId);
            ext = this.addHeaderExtension(this.av1DDHeaderExtensionId, descriptor.getEncodedLength());
        }
        descriptor.write(ext);
    }
}

