/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.incoming.BitrateCalculator;
import org.jitsi.nlj.transform.node.outgoing.OutgoingSsrcStats;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "ssrcStats", "", "", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats;", "numAudioPackets", "", "numVideoPackets", "videoBitrate", "Lorg/jitsi/nlj/util/BitrateTracker;", "videoBitratesByOrigin", "Lorg/jitsi/nlj/PacketOrigin;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "trace", "f", "Lkotlin/Function0;", "getSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getSsrcSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats$Snapshot;", "ssrc", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nOutgoingStatisticsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,167:1\n382#2,7:168\n216#3,2:175\n126#3:177\n153#3,3:178\n216#3,2:181\n*S KotlinDebug\n*F\n+ 1 OutgoingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker\n*L\n60#1:168,7\n75#1:175,2\n92#1:177\n92#1:178,3\n99#1:181,2\n*E\n"})
public final class OutgoingStatisticsTracker
extends ObserverNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Map<Long, OutgoingSsrcStats> ssrcStats;
    private int numAudioPackets;
    private int numVideoPackets;
    @NotNull
    private final BitrateTracker videoBitrate;
    @NotNull
    private final Map<PacketOrigin, BitrateTracker> videoBitratesByOrigin;
    private static final TimeSeriesLogger timeseriesLogger = TimeSeriesLogger.getTimeSeriesLogger(OutgoingStatisticsTracker.class);

    public OutgoingStatisticsTracker(@NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        super("Outgoing statistics tracker");
        this.diagnosticContext = diagnosticContext;
        this.ssrcStats = new ConcurrentHashMap();
        this.videoBitrate = BitrateCalculator.Companion.createBitrateTracker();
        this.videoBitratesByOrigin = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        RtpPacket rtpPacket;
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        RtpPacket rtpPacket2 = rtpPacket = (RtpPacket)packetInfo.packetAs();
        if (rtpPacket2 instanceof AudioRtpPacket) {
            int n = this.numAudioPackets;
            this.numAudioPackets = n + 1;
        } else if (rtpPacket2 instanceof VideoRtpPacket) {
            int n = this.numVideoPackets;
            this.numVideoPackets = n + 1;
            if (timeseriesLogger.isTraceEnabled()) {
                Object object;
                void $this$getOrPut$iv;
                BitrateTracker.update$default(this.videoBitrate, DataSizeKt.getBytes(rtpPacket.length), 0L, 2, null);
                Map<PacketOrigin, BitrateTracker> map = this.videoBitratesByOrigin;
                PacketOrigin key$iv = packetInfo.getPacketOrigin();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    BitrateTracker answer$iv = BitrateCalculator.Companion.createBitrateTracker();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                BitrateTracker.update$default((BitrateTracker)object, DataSizeKt.getBytes(rtpPacket.length), 0L, 2, null);
            }
        }
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> OutgoingStatisticsTracker.observe$lambda$2(arg_0 -> OutgoingStatisticsTracker.observe$lambda$1(rtpPacket, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)outgoingSsrcStats, (String)"computeIfAbsent(...)");
        OutgoingSsrcStats stats = outgoingSsrcStats;
        stats.packetSent(rtpPacket.length, rtpPacket.getTimestamp());
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        OutgoingStatisticsSnapshot stats = this.getSnapshot();
        Map<Long, OutgoingSsrcStats.Snapshot> $this$forEach$iv = stats.getSsrcStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, OutgoingSsrcStats.Snapshot>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> element$iv;
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> entry = element$iv = iterator.next();
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats.Snapshot streamStats = entry.getValue();
            $this$getNodeStats_u24lambda_u240.addJson(String.valueOf(ssrc), (Map)streamStats.toJson());
        }
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStatsToAggregate_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStatsToAggregate_u24lambda_u240.addNumber("num_audio_packets", this.numAudioPackets);
        $this$getNodeStatsToAggregate_u24lambda_u240.addNumber("num_video_packets", this.numVideoPackets);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OutgoingStatisticsSnapshot getSnapshot() {
        OutgoingStatisticsSnapshot outgoingStatisticsSnapshot;
        void $this$mapTo$iv$iv;
        Map<Long, OutgoingSsrcStats> $this$map$iv = this.ssrcStats;
        boolean $i$f$map = false;
        Map<Long, OutgoingSsrcStats> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats stats = (OutgoingSsrcStats)entry.getValue();
            collection.add(new Pair((Object)ssrc, (Object)stats.getSnapshot()));
        }
        Map map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        OutgoingStatisticsSnapshot it = outgoingStatisticsSnapshot = new OutgoingStatisticsSnapshot(map2);
        boolean bl = false;
        if (timeseriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("sent_video_stream_stats").addField("bitrate_bps", (Object)this.videoBitrate.getRate-rlWvAKk());
            Map<PacketOrigin, BitrateTracker> $this$forEach$iv = this.videoBitratesByOrigin;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<PacketOrigin, BitrateTracker>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<PacketOrigin, BitrateTracker> element$iv;
                Map.Entry<PacketOrigin, BitrateTracker> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                PacketOrigin origin = entry.getKey();
                BitrateTracker tracker = entry.getValue();
                point.addField("video_" + origin + "_bitrate", (Object)tracker.getRate-rlWvAKk());
            }
            timeseriesLogger.trace((Map)point);
        }
        return outgoingStatisticsSnapshot;
    }

    @Nullable
    public final OutgoingSsrcStats.Snapshot getSsrcSnapshot(long ssrc) {
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.get(ssrc);
        return outgoingSsrcStats != null ? outgoingSsrcStats.getSnapshot() : null;
    }

    private static final OutgoingSsrcStats observe$lambda$1(RtpPacket $rtpPacket, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new OutgoingSsrcStats($rtpPacket.getSsrc());
    }

    private static final OutgoingSsrcStats observe$lambda$2(Function1 $tmp0, Object p0) {
        return (OutgoingSsrcStats)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker$Companion;", "", "<init>", "()V", "timeseriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

