/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SentryAppStartProfilingOptions
implements JsonUnknown,
JsonSerializable {
    boolean profileSampled;
    @Nullable
    Double profileSampleRate;
    boolean traceSampled;
    @Nullable
    Double traceSampleRate;
    @Nullable
    String profilingTracesDirPath;
    boolean isProfilingEnabled;
    int profilingTracesHz;
    @Nullable
    private Map<String, Object> unknown;

    @VisibleForTesting
    public SentryAppStartProfilingOptions() {
        this.traceSampled = false;
        this.traceSampleRate = null;
        this.profileSampled = false;
        this.profileSampleRate = null;
        this.profilingTracesDirPath = null;
        this.isProfilingEnabled = false;
        this.profilingTracesHz = 0;
    }

    SentryAppStartProfilingOptions(@NotNull SentryOptions options, @NotNull TracesSamplingDecision samplingDecision) {
        this.traceSampled = samplingDecision.getSampled();
        this.traceSampleRate = samplingDecision.getSampleRate();
        this.profileSampled = samplingDecision.getProfileSampled();
        this.profileSampleRate = samplingDecision.getProfileSampleRate();
        this.profilingTracesDirPath = options.getProfilingTracesDirPath();
        this.isProfilingEnabled = options.isProfilingEnabled();
        this.profilingTracesHz = options.getProfilingTracesHz();
    }

    public void setProfileSampled(boolean profileSampled) {
        this.profileSampled = profileSampled;
    }

    public boolean isProfileSampled() {
        return this.profileSampled;
    }

    public void setProfileSampleRate(@Nullable Double profileSampleRate) {
        this.profileSampleRate = profileSampleRate;
    }

    @Nullable
    public Double getProfileSampleRate() {
        return this.profileSampleRate;
    }

    public void setTraceSampled(boolean traceSampled) {
        this.traceSampled = traceSampled;
    }

    public boolean isTraceSampled() {
        return this.traceSampled;
    }

    public void setTraceSampleRate(@Nullable Double traceSampleRate) {
        this.traceSampleRate = traceSampleRate;
    }

    @Nullable
    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public void setProfilingTracesDirPath(@Nullable String profilingTracesDirPath) {
        this.profilingTracesDirPath = profilingTracesDirPath;
    }

    @Nullable
    public String getProfilingTracesDirPath() {
        return this.profilingTracesDirPath;
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.isProfilingEnabled = profilingEnabled;
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }

    public void setProfilingTracesHz(int profilingTracesHz) {
        this.profilingTracesHz = profilingTracesHz;
    }

    public int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("profile_sampled").value(logger, this.profileSampled);
        writer.name("profile_sample_rate").value(logger, this.profileSampleRate);
        writer.name("trace_sampled").value(logger, this.traceSampled);
        writer.name("trace_sample_rate").value(logger, this.traceSampleRate);
        writer.name("profiling_traces_dir_path").value(logger, this.profilingTracesDirPath);
        writer.name("is_profiling_enabled").value(logger, this.isProfilingEnabled);
        writer.name("profiling_traces_hz").value(logger, this.profilingTracesHz);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String PROFILE_SAMPLED = "profile_sampled";
        public static final String PROFILE_SAMPLE_RATE = "profile_sample_rate";
        public static final String TRACE_SAMPLED = "trace_sampled";
        public static final String TRACE_SAMPLE_RATE = "trace_sample_rate";
        public static final String PROFILING_TRACES_DIR_PATH = "profiling_traces_dir_path";
        public static final String IS_PROFILING_ENABLED = "is_profiling_enabled";
        public static final String PROFILING_TRACES_HZ = "profiling_traces_hz";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryAppStartProfilingOptions> {
        @Override
        @NotNull
        public SentryAppStartProfilingOptions deserialize(@NotNull ObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            SentryAppStartProfilingOptions options = new SentryAppStartProfilingOptions();
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "profile_sampled": {
                        Boolean profileSampled = reader.nextBooleanOrNull();
                        if (profileSampled == null) continue block18;
                        options.profileSampled = profileSampled;
                        continue block18;
                    }
                    case "profile_sample_rate": {
                        Double profileSampleRate = reader.nextDoubleOrNull();
                        if (profileSampleRate == null) continue block18;
                        options.profileSampleRate = profileSampleRate;
                        continue block18;
                    }
                    case "trace_sampled": {
                        Boolean traceSampled = reader.nextBooleanOrNull();
                        if (traceSampled == null) continue block18;
                        options.traceSampled = traceSampled;
                        continue block18;
                    }
                    case "trace_sample_rate": {
                        Double traceSampleRate = reader.nextDoubleOrNull();
                        if (traceSampleRate == null) continue block18;
                        options.traceSampleRate = traceSampleRate;
                        continue block18;
                    }
                    case "profiling_traces_dir_path": {
                        String profilingTracesDirPath = reader.nextStringOrNull();
                        if (profilingTracesDirPath == null) continue block18;
                        options.profilingTracesDirPath = profilingTracesDirPath;
                        continue block18;
                    }
                    case "is_profiling_enabled": {
                        Boolean isProfilingEnabled = reader.nextBooleanOrNull();
                        if (isProfilingEnabled == null) continue block18;
                        options.isProfilingEnabled = isProfilingEnabled;
                        continue block18;
                    }
                    case "profiling_traces_hz": {
                        Integer profilingTracesHz = reader.nextIntegerOrNull();
                        if (profilingTracesHz == null) continue block18;
                        options.profilingTracesHz = profilingTracesHz;
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            options.setUnknown(unknown);
            reader.endObject();
            return options;
        }
    }
}

