/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class CallbackHeader
extends UpnpHeader<List<URL>> {
    private static final Logger log = Logger.getLogger(CallbackHeader.class.getName());

    public CallbackHeader() {
        this.setValue(new ArrayList());
    }

    public CallbackHeader(List<URL> urls) {
        this();
        ((List)this.getValue()).addAll(urls);
    }

    public CallbackHeader(URL url) {
        this();
        ((List)this.getValue()).add(url);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.length() == 0) {
            return;
        }
        if (!s.contains("<") || !s.contains(">")) {
            throw new InvalidHeaderException("URLs not in brackets: " + s);
        }
        s = s.replaceAll("<", "");
        String[] split = s.split(">");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String sp : split) {
                if (!(sp = sp.trim()).startsWith("http://")) {
                    log.warning("Discarding non-http callback URL: " + sp);
                    continue;
                }
                URL url = new URL(sp);
                try {
                    url.toURI();
                }
                catch (URISyntaxException ex) {
                    log.log(Level.WARNING, "Discarding callback URL, not a valid URI on this platform: " + url, ex);
                    continue;
                }
                urls.add(url);
            }
            this.setValue(urls);
        }
        catch (MalformedURLException ex) {
            throw new InvalidHeaderException("Can't parse callback URLs from '" + s + "': " + ex);
        }
    }

    @Override
    public String getString() {
        StringBuilder s = new StringBuilder();
        for (URL url : (List)this.getValue()) {
            s.append("<").append(url.toString()).append(">");
        }
        return s.toString();
    }
}

