/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.seamless.util.io.HexBin;

public class InterfaceMacHeader
extends UpnpHeader<byte[]> {
    public InterfaceMacHeader() {
    }

    public InterfaceMacHeader(byte[] value) {
        this.setValue(value);
    }

    public InterfaceMacHeader(String s) {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        byte[] bytes = HexBin.stringToBytes((String)s, (String)":");
        this.setValue(bytes);
        if (bytes.length != 6) {
            throw new InvalidHeaderException("Invalid MAC address: " + s);
        }
    }

    @Override
    public String getString() {
        return HexBin.bytesToString((byte[])((byte[])this.getValue()), (String)":");
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getString() + "'";
    }
}

