/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionHeader;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PartitionDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSeq;
    public Integer flags;
    public Integer partitionNumber;
    public RegId contents;
    public PartitionHeader contentsUse;
    public Long accessType;
    public Long startingLocation;
    public Long length;
    public RegId implIdentifier;
    public byte[] implUse;
    public static final int LENGTH = 512;

    public PartitionDescriptor() {
    }

    public PartitionDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 5;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Partition descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSeq = this.getUInt32(bytes);
        this.flags = this.getUInt16(bytes);
        this.partitionNumber = this.getUInt16(bytes);
        this.contents = new RegId(this.getBytes(bytes, 32));
        this.contentsUse = new PartitionHeader(this.getBytes(bytes, 128));
        this.accessType = this.getUInt32(bytes);
        this.startingLocation = this.getUInt32(bytes);
        this.length = this.getUInt32(bytes);
        this.implIdentifier = new RegId(this.getBytes(bytes, 32));
        this.implUse = this.getBytes(bytes, 128);
        this.currentPos = 512;
    }
}

