/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.clipinf.HexStringShortAdapter;

@XmlType(propOrder={"const0x00010000", "const0x00000100", "const0x1001", "inTime", "outTime"})
public class ClipAttr {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipAttr.class);
    private Integer const0x00010000;
    private Integer const0x00000100;
    private Short const0x1001;
    private int inTime;
    private int outTime;

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x00010000() {
        return this.const0x00010000;
    }

    public void setConst0x00010000(Integer n) {
        this.const0x00010000 = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x00000100() {
        return this.const0x00000100;
    }

    public void setConst0x00000100(Integer n) {
        this.const0x00000100 = n;
    }

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getConst0x1001() {
        return this.const0x1001;
    }

    public void setConst0x1001(Short s) {
        this.const0x1001 = s;
    }

    public int getInTime() {
        return this.inTime;
    }

    public void setInTime(int n) {
        this.inTime = n;
    }

    public int getOutTime() {
        return this.outTime;
    }

    public void setOutTime(int n) {
        this.outTime = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("ClipAttr length={}", (Object)n);
        this.const0x00010000 = dataInputStream.readInt();
        LOGGER.trace("ClipAttr const0x00010000={}", (Object)this.const0x00010000);
        this.const0x00000100 = dataInputStream.readInt();
        LOGGER.trace("ClipAttr const0x00000100={}", (Object)this.const0x00000100);
        this.const0x1001 = dataInputStream.readShort();
        LOGGER.trace("ClipAttr const0x1001={}", (Object)this.const0x1001);
        dataInputStream.skipBytes(4);
        this.inTime = dataInputStream.readInt();
        LOGGER.trace("ClipAttr inTime={} ({} seconds)", (Object)this.inTime, (Object)(this.inTime / 45000));
        this.outTime = dataInputStream.readInt();
        LOGGER.trace("ClipAttr outTime={} ({} seconds)", (Object)this.outTime, (Object)(this.outTime / 45000));
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(22);
        dataOutputStream.writeInt(this.getConst0x00010000());
        dataOutputStream.writeInt(this.getConst0x00000100());
        dataOutputStream.writeShort(this.getConst0x1001().shortValue());
        for (int i = 0; i < 4; ++i) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeInt(this.getInTime());
        dataOutputStream.writeInt(this.getOutTime());
        LOGGER.trace("ClipAttr: 22 ?= " + (dataOutputStream.size() - 4));
    }
}

