/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Mutator;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.base;
import io.jenetics.internal.util.Hash;
import java.util.Random;

public final class GaussianMutator<G extends NumericGene<?, G>, C extends Comparable<? super C>>
extends Mutator<G, C> {
    public GaussianMutator(double probability2) {
        super(probability2);
    }

    public GaussianMutator() {
        this(0.2);
    }

    @Override
    protected G mutate(G gene, Random random2) {
        double min = ((Number)gene.getMin()).doubleValue();
        double max = ((Number)gene.getMax()).doubleValue();
        double std = (max - min) * 0.25;
        double value = gene.doubleValue();
        double gaussian = random2.nextGaussian();
        return gene.newInstance(base.clamp(gaussian * std + value, min, max));
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof GaussianMutator && super.equals(obj);
    }

    @Override
    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

