/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.math;

import io.jenetics.internal.math.base;
import io.jenetics.internal.util.require;
import io.jenetics.util.RandomRegistry;
import java.util.Objects;
import java.util.Random;

public final class comb {
    private comb() {
        require.noInstance();
    }

    public static int[] subset(int n, int k) {
        return comb.subset(n, k, RandomRegistry.getRandom());
    }

    public static int[] subset(int n, int k, Random random2) {
        Objects.requireNonNull(random2, "Random");
        if (k <= 0) {
            throw new IllegalArgumentException(String.format("Subset size smaller or equal zero: %s", k));
        }
        if (n < k) {
            throw new IllegalArgumentException(String.format("n smaller than k: %s < %s.", n, k));
        }
        int[] sub = new int[k];
        comb.subset(n, sub, random2);
        return sub;
    }

    public static int[] subset(int[] set, int k) {
        return comb.subset(set, k, RandomRegistry.getRandom());
    }

    public static int[] subset(int[] set, int k, Random random2) {
        int[] sub = comb.subset(set.length, new int[k], random2);
        for (int i = 0; i < k; ++i) {
            sub[i] = set[sub[i]];
        }
        return sub;
    }

    public static int[] subset(int n, int[] sub) {
        return comb.subset(n, sub, RandomRegistry.getRandom());
    }

    public static int[] subset(int n, int[] a, Random random2) {
        Objects.requireNonNull(random2, "Random");
        Objects.requireNonNull(a, "Sub set array");
        int k = a.length;
        comb.checkSubSet(n, k);
        if (a.length == n) {
            for (int i = 0; i < k; ++i) {
                a[i] = i;
            }
            return a;
        }
        for (int i = 0; i < k; ++i) {
            a[i] = i * n / k;
        }
        int l = 0;
        int x = 0;
        for (int c = 0; c < k; ++c) {
            while (a[l = ((x = 1 + comb.nextX(random2, n - 1)) * k - 1) / n] >= x) {
            }
            int n2 = l;
            a[n2] = a[n2] + 1;
        }
        int s = k;
        int m = 0;
        int p = 0;
        for (int i = 0; i < k; ++i) {
            if (a[i] == i * n / k) {
                a[i] = 0;
                continue;
            }
            m = a[i];
            a[i] = 0;
            a[++p - 1] = m;
        }
        int ds = 0;
        while (p > 0) {
            l = 1 + (a[p - 1] * k - 1) / n;
            ds = a[p - 1] - (l - 1) * n / k;
            a[p - 1] = 0;
            a[s - 1] = l;
            s -= ds;
            --p;
        }
        int r = 0;
        int m0 = 0;
        for (int ll = 1; ll <= k; ++ll) {
            l = k + 1 - ll;
            if (a[l - 1] != 0) {
                r = l;
                m0 = 1 + (a[l - 1] - 1) * n / k;
                m = a[l - 1] * n / k - m0 + 1;
            }
            x = m0 + comb.nextX(random2, m - 1);
            for (int i = l + 1; i <= r && x >= a[i - 1]; ++x, ++i) {
                a[i - 2] = a[i - 1];
            }
            a[i - 2] = x;
            --m;
        }
        return a;
    }

    public static void checkSubSet(int n, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException(String.format("Subset size smaller or equal zero: %s", k));
        }
        if (n < k) {
            throw new IllegalArgumentException(String.format("n smaller than k: %s < %s.", n, k));
        }
        if (!base.isMultiplicationSave(n, k)) {
            throw new IllegalArgumentException(String.format("n*sub.length > Integer.MAX_VALUE (%s*%s = %s > %s)", n, k, (long)n * (long)k, Integer.MAX_VALUE));
        }
    }

    private static int nextX(Random random2, int m) {
        return m > 0 ? random2.nextInt(m) : m - 1;
    }
}

