/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.util.CharSeqBase;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collector;

public final class CharSeq
extends CharSeqBase
implements CharSequence,
ISeq<Character>,
Comparable<CharSeq>,
Serializable {
    private static final long serialVersionUID = 2L;

    public CharSeq(char[] characters) {
        super(CharSeq.distinct((char[])characters.clone()));
    }

    public CharSeq(CharSequence characters) {
        super(CharSeq.distinct(CharSeq.toCharArray(characters)));
    }

    private static char[] toCharArray(CharSequence characters) {
        Objects.requireNonNull(characters, "Characters");
        char[] chars = new char[characters.length()];
        int i = chars.length;
        while (--i >= 0) {
            chars[i] = characters.charAt(i);
        }
        return chars;
    }

    private static char[] distinct(char[] chars) {
        Arrays.sort(chars);
        int j = 0;
        for (int i = 1; i < chars.length; ++i) {
            if (chars[j] == chars[i]) continue;
            chars[++j] = chars[i];
        }
        int size = Math.min(chars.length, j + 1);
        char[] array2 = new char[size];
        System.arraycopy(chars, 0, array2, 0, size);
        return array2;
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Character && this.contains((Character)object);
    }

    public boolean contains(Character c) {
        return this.contains(c.charValue());
    }

    public boolean contains(char c) {
        return Arrays.binarySearch(this.array, c) >= 0;
    }

    @Override
    public char charAt(int index) {
        return this.array[index];
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public CharSeq subSequence(int start, int end) {
        return new CharSeq(new String(this.array, start, end - start));
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public int hashCode() {
        return 17 + 31 * Arrays.hashCode(this.array);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSeq && Arrays.equals(((CharSeq)obj).array, this.array);
    }

    @Override
    public int compareTo(CharSeq set) {
        int result = 0;
        int n = Math.min(this.array.length, set.array.length);
        for (int i = 0; i < n && result == 0; ++i) {
            result = this.array[i] - set.array[i];
        }
        if (result == 0) {
            result = this.array.length - set.array.length;
        }
        return result;
    }

    @Override
    public String toString() {
        return new String(this.array);
    }

    public static String expand(CharSequence pattern) {
        Objects.requireNonNull(pattern, "Pattern");
        StringBuilder out = new StringBuilder();
        int n = pattern.length();
        for (int i = 0; i < n; ++i) {
            if (pattern.charAt(i) == '\\') {
                if (++i >= pattern.length()) continue;
                out.append(pattern.charAt(i));
                continue;
            }
            if (pattern.charAt(i) == '-') {
                if (i <= 0 || i >= pattern.length() - 1) {
                    throw new PatternSyntaxException("Dangling range operator '-'", pattern.toString(), pattern.length() - 1);
                }
                String range = CharSeq.expand(pattern.charAt(i - 1), pattern.charAt(i + 1));
                out.append(range);
                ++i;
                continue;
            }
            if (i + 1 != n && pattern.charAt(i + 1) == '-') continue;
            out.append(pattern.charAt(i));
        }
        return out.toString();
    }

    public static String expand(char a, char b) {
        StringBuilder out;
        block3: {
            block2: {
                out = new StringBuilder();
                if (a >= b) break block2;
                for (char c = a; c <= b; c = (char)(c + '\u0001')) {
                    out.append(c);
                }
                break block3;
            }
            if (a <= b) break block3;
            for (char c = a; c >= b; c = (char)(c - '\u0001')) {
                out.append(c);
            }
        }
        return out.toString();
    }

    public static CharSeq of(CharSequence pattern) {
        return new CharSeq(CharSeq.expand(pattern));
    }

    public static CharSeq of(char a, char b) {
        return new CharSeq(CharSeq.expand(a, b));
    }

    public static ISeq<Character> toISeq(CharSequence chars) {
        MSeq<Character> seq = MSeq.ofLength(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            seq.set(i, Character.valueOf(chars.charAt(i)));
        }
        return seq.toISeq();
    }

    public static Collector<Character, ?, CharSeq> toCharSeq() {
        return Collector.of(StringBuilder::new, StringBuilder::append, (a, b) -> {
            a.append((CharSequence)b);
            return a;
        }, CharSeq::new, new Collector.Characteristics[0]);
    }
}

