/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.unsafe.UnsafeHacks;

public final class EventBusMigrationHelper {
    public static final EventBusMigrationHelper INSTANCE = new EventBusMigrationHelper(BusGroup.DEFAULT);
    private final BusGroup group;

    public EventBusMigrationHelper(BusGroup group) {
        this.group = group;
    }

    public Collection<EventListener> register(Class<?> clazz) {
        return EventBusMigrationHelper.registerListeners(this.group, clazz);
    }

    public Collection<EventListener> register(Object instance) {
        return EventBusMigrationHelper.registerListeners(this.group, instance);
    }

    private static Collection<EventListener> registerListeners(BusGroup group, Object instance) {
        final class DodgyLookup {
            private static final MethodHandles.Lookup INSTANCE;

            private DodgyLookup() {
            }

            static {
                try {
                    Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                    UnsafeHacks.setAccessible((AccessibleObject)lookupField);
                    INSTANCE = (MethodHandles.Lookup)lookupField.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (instance.getClass() == Class.class) {
            Class clazz = (Class)instance;
            return group.register(DodgyLookup.INSTANCE.in(clazz), clazz);
        }
        return group.register(DodgyLookup.INSTANCE.in(instance.getClass()), instance);
    }

    public String name() {
        return this.group.name();
    }

    public Collection<EventListener> register(MethodHandles.Lookup callerLookup, Class<?> utilityClassWithStaticListeners) {
        return this.group.register(callerLookup, utilityClassWithStaticListeners);
    }

    public Collection<EventListener> register(MethodHandles.Lookup callerLookup, Object listener) {
        return this.group.register(callerLookup, listener);
    }

    public void unregister(Collection<EventListener> listeners) {
        this.group.unregister(listeners);
    }
}

