/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.IndexedAssetSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ExistingFileHelper {
    private final MultiPackResourceManager clientResources;
    private final MultiPackResourceManager serverData;
    private final boolean enable;
    private final Multimap<PackType, ResourceLocation> generated = HashMultimap.create();

    public ExistingFileHelper(Collection<Path> existingPacks, Set<String> existingMods, boolean enable, @Nullable String assetIndex, @Nullable File assetsDir) {
        ArrayList<Object> candidateClientResources = new ArrayList<Object>();
        ArrayList<Object> candidateServerResources = new ArrayList<Object>();
        if (assetIndex != null && assetsDir != null && assetsDir.exists()) {
            candidateClientResources.add(ClientPackSource.createVanillaPackSource((Path)IndexedAssetSource.createIndexFs((Path)assetsDir.toPath(), (String)assetIndex)));
        }
        candidateServerResources.add(ServerPacksSource.createVanillaPackSource());
        ArrayList symlinks = new ArrayList();
        FolderRepositorySource.FolderPackDetector folder = new FolderRepositorySource.FolderPackDetector(new DirectoryValidator(p -> true));
        for (Path existing : existingPacks) {
            try {
                PackLocationInfo info = new PackLocationInfo(existing.getFileName().toString(), (Component)Component.literal((String)"data_gen"), PackSource.DEFAULT, Optional.empty());
                Pack.ResourcesSupplier supplier = (Pack.ResourcesSupplier)folder.detectPackResources(existing, symlinks, false);
                PackResources pack = supplier.openPrimary(info);
                candidateClientResources.add(pack);
                candidateServerResources.add(pack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String existingMod : existingMods) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(existingMod);
            if (modFileInfo == null) continue;
            Path root = modFileInfo.getFile().findResource(new String[]{"/"});
            PathPackResources.PathResourcesSupplier supplier = new PathPackResources.PathResourcesSupplier(root);
            PackLocationInfo info = new PackLocationInfo("mod:" + existingMod, (Component)Component.literal((String)("data_gen:" + existingMod)), PackSource.DEFAULT, Optional.empty());
            PackResources pack = supplier.openPrimary(info);
            candidateClientResources.add(pack);
            candidateServerResources.add(pack);
        }
        this.clientResources = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, candidateClientResources);
        this.serverData = new MultiPackResourceManager(PackType.SERVER_DATA, candidateServerResources);
        this.enable = enable;
    }

    private ResourceManager getManager(PackType packType) {
        return packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
    }

    private ResourceLocation getLocation(ResourceLocation base, String suffix, String prefix) {
        return base.withPath(p -> prefix + "/" + p + suffix);
    }

    public boolean exists(ResourceLocation loc, PackType packType) {
        return this.generated.get((Object)packType).contains(loc) || this.getManager(packType).getResource(loc).isPresent();
    }

    public boolean exists(ResourceLocation loc, IResourceType type) {
        return this.exists(this.getLocation(loc, type.getSuffix(), type.getPrefix()), type.getPackType());
    }

    public boolean exists(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) {
        return this.exists(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    public void trackGenerated(ResourceLocation loc, IResourceType type) {
        this.generated.put((Object)type.getPackType(), (Object)this.getLocation(loc, type.getSuffix(), type.getPrefix()));
    }

    public void trackGenerated(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) {
        this.generated.put((Object)packType, (Object)this.getLocation(loc, pathSuffix, pathPrefix));
    }

    @VisibleForTesting
    public Resource getResource(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) throws FileNotFoundException {
        return this.getResource(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    @VisibleForTesting
    public Resource getResource(ResourceLocation loc, PackType packType) throws FileNotFoundException {
        return this.getManager(packType).getResourceOrThrow(loc);
    }

    @VisibleForTesting
    public List<Resource> getResourceStack(ResourceLocation loc, PackType packType) {
        return this.getManager(packType).getResourceStack(loc);
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    public boolean isEnabled() {
        return this.enable;
    }

    public static interface IResourceType {
        public PackType getPackType();

        public String getSuffix();

        public String getPrefix();
    }

    public static class ResourceType
    implements IResourceType {
        final PackType packType;
        final String suffix;
        final String prefix;

        public ResourceType(PackType type, String suffix, String prefix) {
            this.packType = type;
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public PackType getPackType() {
            return this.packType;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }
}

