/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;

public sealed class ChunkWatchEvent
extends MutableEvent
implements InheritableEvent {
    public static final EventBus<ChunkWatchEvent> BUS = EventBus.create(ChunkWatchEvent.class);
    private final ServerLevel level;
    private final ServerPlayer player;
    private final ChunkPos pos;

    public ChunkWatchEvent(ServerPlayer player, ChunkPos pos, ServerLevel level) {
        this.player = player;
        this.pos = pos;
        this.level = level;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public static final class UnWatch
    extends ChunkWatchEvent {
        public static final EventBus<UnWatch> BUS = EventBus.create(UnWatch.class);

        public UnWatch(ServerPlayer player, ChunkPos pos, ServerLevel level) {
            super(player, pos, level);
        }
    }

    public static final class Watch
    extends ChunkWatchEvent {
        public static final EventBus<Watch> BUS = EventBus.create(Watch.class);
        private final LevelChunk chunk;

        public Watch(ServerPlayer player, LevelChunk chunk, ServerLevel level) {
            super(player, chunk.getPos(), level);
            this.chunk = chunk;
        }

        public LevelChunk getChunk() {
            return this.chunk;
        }
    }
}

