/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.WeightedVariants;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeBlockStateModel;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public interface BlockStateModel
extends IForgeBlockStateModel {
    @Deprecated
    public void collectParts(RandomSource var1, List<BlockModelPart> var2);

    @Deprecated
    default public List<BlockModelPart> collectParts(RandomSource p_392713_) {
        ObjectArrayList list = new ObjectArrayList();
        this.collectParts(p_392713_, (List)list, ModelData.EMPTY, null);
        return list;
    }

    @Deprecated
    public TextureAtlasSprite particleIcon();

    @OnlyIn(value=Dist.CLIENT)
    public static interface UnbakedRoot
    extends ResolvableModel {
        public BlockStateModel bake(BlockState var1, ModelBaker var2);

        public Object visualEqualityGroup(BlockState var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Unbaked
    extends ResolvableModel {
        public static final Codec<Weighted<Variant>> ELEMENT_CODEC = RecordCodecBuilder.create(p_396421_ -> p_396421_.group((App)Variant.MAP_CODEC.forGetter(Weighted::value), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Weighted::weight)).apply((Applicative)p_396421_, Weighted::new));
        public static final Codec<WeightedVariants.Unbaked> HARDCODED_WEIGHTED_CODEC = ExtraCodecs.nonEmptyList(ELEMENT_CODEC.listOf()).flatComapMap(p_393029_ -> new WeightedVariants.Unbaked(WeightedList.of(Lists.transform((List)p_393029_, p_392845_ -> p_392845_.map(SingleVariant.Unbaked::new)))), p_391675_ -> {
            List<Weighted<Unbaked>> list = p_391675_.entries().unwrap();
            ArrayList<Weighted<Variant>> list1 = new ArrayList<Weighted<Variant>>(list.size());
            for (Weighted<Unbaked> weighted : list) {
                Unbaked patt0$temp = weighted.value();
                if (!(patt0$temp instanceof SingleVariant.Unbaked)) {
                    return DataResult.error(() -> "Only single variants are supported");
                }
                SingleVariant.Unbaked singlevariant$unbaked = (SingleVariant.Unbaked)patt0$temp;
                list1.add(new Weighted<Variant>(singlevariant$unbaked.variant(), weighted.weight()));
            }
            return DataResult.success(list1);
        });
        public static final Codec<Unbaked> CODEC = Codec.either(HARDCODED_WEIGHTED_CODEC, SingleVariant.Unbaked.CODEC).flatComapMap(p_394601_ -> (Unbaked)p_394601_.map(p_396155_ -> p_396155_, p_397083_ -> p_397083_), p_392163_ -> {
            Unbaked unbaked = p_392163_;
            Objects.requireNonNull(unbaked);
            Unbaked selector0$temp = unbaked;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleVariant.Unbaked.class, WeightedVariants.Unbaked.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    SingleVariant.Unbaked singlevariant$unbaked = (SingleVariant.Unbaked)selector0$temp;
                    yield DataResult.success((Object)Either.right((Object)singlevariant$unbaked));
                }
                case 1 -> {
                    WeightedVariants.Unbaked weightedvariants$unbaked = (WeightedVariants.Unbaked)selector0$temp;
                    yield DataResult.success((Object)Either.left((Object)weightedvariants$unbaked));
                }
                default -> DataResult.error(() -> "Only a single variant or a list of variants are supported");
            };
        });

        public BlockStateModel bake(ModelBaker var1);

        default public UnbakedRoot asRoot() {
            return new SimpleCachedUnbakedRoot(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SimpleCachedUnbakedRoot
    implements UnbakedRoot {
        final Unbaked contents;
        private final ModelBaker.SharedOperationKey<BlockStateModel> bakingKey = new ModelBaker.SharedOperationKey<BlockStateModel>(){

            @Override
            public BlockStateModel compute(ModelBaker p_396245_) {
                return contents.bake(p_396245_);
            }
        };

        public SimpleCachedUnbakedRoot(Unbaked p_394126_) {
            this.contents = p_394126_;
        }

        public void resolveDependencies(ResolvableModel.Resolver p_396058_) {
            this.contents.resolveDependencies(p_396058_);
        }

        @Override
        public BlockStateModel bake(BlockState p_394850_, ModelBaker p_396441_) {
            return p_396441_.compute(this.bakingKey);
        }

        @Override
        public Object visualEqualityGroup(BlockState p_395333_) {
            return this;
        }
    }
}

