/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.slf4j.Logger;

public class BackgroundScanHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG = LOGGER.isErrorEnabled(LogMarkers.SCAN);
    private final ExecutorService modContentScanner;
    private final List<ModFile> modFiles;
    private ScanStatus status;
    private LoadingModList loadingModList;

    public BackgroundScanHandler(List<ModFile> modFiles) {
        this.modFiles = modFiles;
        this.modContentScanner = Executors.newSingleThreadExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.status = ScanStatus.NOT_STARTED;
    }

    public List<ModFile> getModFiles() {
        return this.modFiles;
    }

    public void submitForScanning(ModFile file) {
        if (this.modContentScanner.isShutdown()) {
            this.status = ScanStatus.ERRORED;
            throw new IllegalStateException("Scanner has shutdown");
        }
        this.status = ScanStatus.RUNNING;
        ImmediateWindowHandler.updateProgress("Scanning mod candidates");
        CompletionStage future = CompletableFuture.supplyAsync(file::compileContent, this.modContentScanner).whenComplete(file::setScanResult);
        if (DEBUG) {
            future = ((CompletableFuture)future).whenComplete((r, t) -> this.addCompletedFile(file, (Throwable)t));
        }
        file.setFutureScanResult((CompletableFuture<ModFileScanData>)future);
    }

    private void addCompletedFile(ModFile file, Throwable throwable) {
        if (throwable != null) {
            this.status = ScanStatus.ERRORED;
            LOGGER.error(LogMarkers.SCAN, "An error occurred scanning file {}", (Object)file, (Object)throwable);
        }
    }

    public void setLoadingModList(LoadingModList loadingModList) {
        this.loadingModList = loadingModList;
    }

    public LoadingModList getLoadingModList() {
        return this.loadingModList;
    }

    public void waitForScanToComplete(Runnable ticker) {
        boolean timeoutActive = System.getProperty("fml.disableScanTimeout") == null;
        Instant deadline = Instant.now().plus(Duration.ofMinutes(10L));
        this.modContentScanner.shutdown();
        do {
            ticker.run();
            try {
                this.status = this.modContentScanner.awaitTermination(50L, TimeUnit.MILLISECONDS) ? ScanStatus.COMPLETE : ScanStatus.RUNNING;
            }
            catch (InterruptedException e) {
                this.status = ScanStatus.INTERRUPTED;
            }
            if (!timeoutActive || !Instant.now().isAfter(deadline)) continue;
            this.status = ScanStatus.TIMED_OUT;
        } while (this.status == ScanStatus.RUNNING);
        if (this.status == ScanStatus.INTERRUPTED) {
            Thread.currentThread().interrupt();
        }
        if (this.status != ScanStatus.COMPLETE) {
            throw new IllegalStateException("Failed to complete mod scan");
        }
    }

    private static enum ScanStatus {
        NOT_STARTED,
        RUNNING,
        COMPLETE,
        TIMED_OUT,
        INTERRUPTED,
        ERRORED;

    }
}

