/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;

public interface IncomingRpcMethod {
    public MethodInfo info();

    public Attributes attributes();

    public JsonElement apply(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> IncomingRpcMethodBuilder<ParameterlessMethod<Result>> method(ParameterlessRpcMethodFunction<Result> $$0, Codec<Result> $$1) {
        return new IncomingRpcMethodBuilder<ParameterlessMethod<Result>>(($$2, $$3) -> {
            if ($$2.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if ($$2.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod($$2, $$3, $$1, $$0);
        });
    }

    public static <Params, Result> IncomingRpcMethodBuilder<Method<Params, Result>> method(RpcMethodFunction<Params, Result> $$0, Codec<Params> $$1, Codec<Result> $$2) {
        return new IncomingRpcMethodBuilder<Method<Params, Result>>(($$3, $$4) -> {
            if ($$3.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if ($$3.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new Method($$3, $$4, $$1, $$2, $$0);
        });
    }

    public static <Result> IncomingRpcMethodBuilder<ParameterlessMethod<Result>> method(Function<MinecraftApi, Result> $$0, Codec<Result> $$1) {
        return new IncomingRpcMethodBuilder<ParameterlessMethod<Result>>(($$22, $$3) -> {
            if ($$22.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if ($$22.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod<Object>($$22, $$3, $$1, ($$1, $$2) -> $$0.apply($$1));
        });
    }

    public static class IncomingRpcMethodBuilder<T extends IncomingRpcMethod> {
        private final Factory<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;
        private boolean discoverable = true;
        private boolean runOnMainThread = true;

        public IncomingRpcMethodBuilder(Factory<T> $$0) {
            this.method = $$0;
        }

        public IncomingRpcMethodBuilder<T> description(String $$0) {
            this.description = $$0;
            return this;
        }

        public IncomingRpcMethodBuilder<T> response(ResultInfo $$0) {
            this.resultInfo = $$0;
            return this;
        }

        public IncomingRpcMethodBuilder<T> param(ParamInfo $$0) {
            this.paramInfo = $$0;
            return this;
        }

        public IncomingRpcMethodBuilder<T> undiscoverable() {
            this.discoverable = false;
            return this;
        }

        public IncomingRpcMethodBuilder<T> notOnMainThread() {
            this.runOnMainThread = false;
            return this;
        }

        public T build() {
            MethodInfo $$0 = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create($$0, new Attributes(this.runOnMainThread, this.discoverable));
        }

        public T register(Registry<IncomingRpcMethod> $$0, String $$1) {
            return this.register($$0, ResourceLocation.withDefaultNamespace($$1));
        }

        private T register(Registry<IncomingRpcMethod> $$0, ResourceLocation $$1) {
            return (T)((IncomingRpcMethod)Registry.register($$0, $$1, this.build()));
        }
    }

    @FunctionalInterface
    public static interface ParameterlessRpcMethodFunction<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface Factory<T extends IncomingRpcMethod> {
        public T create(MethodInfo var1, Attributes var2);
    }

    @FunctionalInterface
    public static interface RpcMethodFunction<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record ParameterlessMethod<Result>(MethodInfo info, Attributes attributes, Codec<Result> resultCodec, ParameterlessRpcMethodFunction<Result> supplier) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi $$0, @Nullable JsonElement $$1, ClientInfo $$2) {
            if (!($$1 == null || $$1.isJsonArray() && $$1.getAsJsonArray().isEmpty())) {
                throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
            }
            if (this.info.params().isPresent()) {
                throw new IllegalArgumentException("Method defined as not having parameters but is describing them");
            }
            Result $$3 = this.supplier.apply($$0, $$2);
            return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, $$3).getOrThrow(InvalidParameterJsonRpcException::new);
        }
    }

    public record Attributes(boolean runOnMainThread, boolean discoverable) {
    }

    public record Method<Params, Result>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec, RpcMethodFunction<Params, Result> function) implements IncomingRpcMethod
    {
        @Override
        public JsonElement apply(MinecraftApi $$0, @Nullable JsonElement $$1, ClientInfo $$2) {
            JsonElement $$7;
            if ($$1 == null || !$$1.isJsonArray() && !$$1.isJsonObject()) {
                throw new InvalidParameterJsonRpcException("Expected params as array or named");
            }
            if (this.info.params().isEmpty()) {
                throw new IllegalArgumentException("Method defined as having parameters without describing them");
            }
            if ($$1.isJsonObject()) {
                String $$3 = this.info.params().get().name();
                JsonElement $$4 = $$1.getAsJsonObject().get($$3);
                if ($$4 == null) {
                    throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", $$3));
                }
                JsonElement $$5 = $$4;
            } else {
                JsonArray $$6 = $$1.getAsJsonArray();
                if ($$6.isEmpty() || $$6.size() > 1) {
                    throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                }
                $$7 = $$6.get(0);
            }
            Object $$8 = this.paramsCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$7).getOrThrow(InvalidParameterJsonRpcException::new);
            Result $$9 = this.function.apply($$0, $$8, $$2);
            return (JsonElement)this.resultCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, $$9).getOrThrow(EncodeJsonRpcException::new);
        }
    }
}

