// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV1

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// SyntheticsBrowserTestConfig Configuration object for a Synthetic browser test.
type SyntheticsBrowserTestConfig struct {
	// Array of assertions used for the test.
	Assertions []SyntheticsAssertion `json:"assertions"`
	// Array of variables used for the test.
	ConfigVariables []SyntheticsConfigVariable `json:"configVariables,omitempty"`
	// Object describing the Synthetic test request.
	Request SyntheticsTestRequest `json:"request"`
	// Cookies to be used for the request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
	SetCookie *string `json:"setCookie,omitempty"`
	// Array of variables used for the test steps.
	Variables []SyntheticsBrowserVariable `json:"variables,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewSyntheticsBrowserTestConfig instantiates a new SyntheticsBrowserTestConfig object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewSyntheticsBrowserTestConfig(assertions []SyntheticsAssertion, request SyntheticsTestRequest) *SyntheticsBrowserTestConfig {
	this := SyntheticsBrowserTestConfig{}
	this.Assertions = assertions
	this.Request = request
	return &this
}

// NewSyntheticsBrowserTestConfigWithDefaults instantiates a new SyntheticsBrowserTestConfig object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewSyntheticsBrowserTestConfigWithDefaults() *SyntheticsBrowserTestConfig {
	this := SyntheticsBrowserTestConfig{}
	return &this
}

// GetAssertions returns the Assertions field value.
func (o *SyntheticsBrowserTestConfig) GetAssertions() []SyntheticsAssertion {
	if o == nil {
		var ret []SyntheticsAssertion
		return ret
	}
	return o.Assertions
}

// GetAssertionsOk returns a tuple with the Assertions field value
// and a boolean to check if the value has been set.
func (o *SyntheticsBrowserTestConfig) GetAssertionsOk() (*[]SyntheticsAssertion, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Assertions, true
}

// SetAssertions sets field value.
func (o *SyntheticsBrowserTestConfig) SetAssertions(v []SyntheticsAssertion) {
	o.Assertions = v
}

// GetConfigVariables returns the ConfigVariables field value if set, zero value otherwise.
func (o *SyntheticsBrowserTestConfig) GetConfigVariables() []SyntheticsConfigVariable {
	if o == nil || o.ConfigVariables == nil {
		var ret []SyntheticsConfigVariable
		return ret
	}
	return o.ConfigVariables
}

// GetConfigVariablesOk returns a tuple with the ConfigVariables field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SyntheticsBrowserTestConfig) GetConfigVariablesOk() (*[]SyntheticsConfigVariable, bool) {
	if o == nil || o.ConfigVariables == nil {
		return nil, false
	}
	return &o.ConfigVariables, true
}

// HasConfigVariables returns a boolean if a field has been set.
func (o *SyntheticsBrowserTestConfig) HasConfigVariables() bool {
	return o != nil && o.ConfigVariables != nil
}

// SetConfigVariables gets a reference to the given []SyntheticsConfigVariable and assigns it to the ConfigVariables field.
func (o *SyntheticsBrowserTestConfig) SetConfigVariables(v []SyntheticsConfigVariable) {
	o.ConfigVariables = v
}

// GetRequest returns the Request field value.
func (o *SyntheticsBrowserTestConfig) GetRequest() SyntheticsTestRequest {
	if o == nil {
		var ret SyntheticsTestRequest
		return ret
	}
	return o.Request
}

// GetRequestOk returns a tuple with the Request field value
// and a boolean to check if the value has been set.
func (o *SyntheticsBrowserTestConfig) GetRequestOk() (*SyntheticsTestRequest, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Request, true
}

// SetRequest sets field value.
func (o *SyntheticsBrowserTestConfig) SetRequest(v SyntheticsTestRequest) {
	o.Request = v
}

// GetSetCookie returns the SetCookie field value if set, zero value otherwise.
func (o *SyntheticsBrowserTestConfig) GetSetCookie() string {
	if o == nil || o.SetCookie == nil {
		var ret string
		return ret
	}
	return *o.SetCookie
}

// GetSetCookieOk returns a tuple with the SetCookie field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SyntheticsBrowserTestConfig) GetSetCookieOk() (*string, bool) {
	if o == nil || o.SetCookie == nil {
		return nil, false
	}
	return o.SetCookie, true
}

// HasSetCookie returns a boolean if a field has been set.
func (o *SyntheticsBrowserTestConfig) HasSetCookie() bool {
	return o != nil && o.SetCookie != nil
}

// SetSetCookie gets a reference to the given string and assigns it to the SetCookie field.
func (o *SyntheticsBrowserTestConfig) SetSetCookie(v string) {
	o.SetCookie = &v
}

// GetVariables returns the Variables field value if set, zero value otherwise.
func (o *SyntheticsBrowserTestConfig) GetVariables() []SyntheticsBrowserVariable {
	if o == nil || o.Variables == nil {
		var ret []SyntheticsBrowserVariable
		return ret
	}
	return o.Variables
}

// GetVariablesOk returns a tuple with the Variables field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SyntheticsBrowserTestConfig) GetVariablesOk() (*[]SyntheticsBrowserVariable, bool) {
	if o == nil || o.Variables == nil {
		return nil, false
	}
	return &o.Variables, true
}

// HasVariables returns a boolean if a field has been set.
func (o *SyntheticsBrowserTestConfig) HasVariables() bool {
	return o != nil && o.Variables != nil
}

// SetVariables gets a reference to the given []SyntheticsBrowserVariable and assigns it to the Variables field.
func (o *SyntheticsBrowserTestConfig) SetVariables(v []SyntheticsBrowserVariable) {
	o.Variables = v
}

// MarshalJSON serializes the struct using spec logic.
func (o SyntheticsBrowserTestConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	toSerialize["assertions"] = o.Assertions
	if o.ConfigVariables != nil {
		toSerialize["configVariables"] = o.ConfigVariables
	}
	toSerialize["request"] = o.Request
	if o.SetCookie != nil {
		toSerialize["setCookie"] = o.SetCookie
	}
	if o.Variables != nil {
		toSerialize["variables"] = o.Variables
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *SyntheticsBrowserTestConfig) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Assertions      *[]SyntheticsAssertion      `json:"assertions"`
		ConfigVariables []SyntheticsConfigVariable  `json:"configVariables,omitempty"`
		Request         *SyntheticsTestRequest      `json:"request"`
		SetCookie       *string                     `json:"setCookie,omitempty"`
		Variables       []SyntheticsBrowserVariable `json:"variables,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Assertions == nil {
		return fmt.Errorf("required field assertions missing")
	}
	if all.Request == nil {
		return fmt.Errorf("required field request missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"assertions", "configVariables", "request", "setCookie", "variables"})
	} else {
		return err
	}

	hasInvalidField := false
	o.Assertions = *all.Assertions
	o.ConfigVariables = all.ConfigVariables
	if all.Request.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Request = *all.Request
	o.SetCookie = all.SetCookie
	o.Variables = all.Variables

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
