// Copyright 2023-2024 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// See the License for the specific language governing permissions and
// limitations under the License.

package charset

import "unicode"

func init() {
	gb18030EncodingList := []struct {
		unicode rune
		gb18030 uint32
	}{
		{'\u1e3f', 0xA8BC}, {'\u20ac', 0xA2E3}, {'\u9fb4', 0xFE59},
		{'\u9fb5', 0xFE61}, {'\u9fb6', 0xFE66}, {'\u9fb7', 0xFE67},
		{'\u9fb8', 0xFE6D}, {'\u9fb9', 0xFE7E}, {'\u9fba', 0xFE90},
		{'\u9fbb', 0xFEA0}, {'\ue000', 0xAAA1}, {'\ue001', 0xAAA2},
		{'\ue002', 0xAAA3}, {'\ue003', 0xAAA4}, {'\ue004', 0xAAA5},
		{'\ue005', 0xAAA6}, {'\ue006', 0xAAA7}, {'\ue007', 0xAAA8},
		{'\ue008', 0xAAA9}, {'\ue009', 0xAAAA}, {'\ue00a', 0xAAAB},
		{'\ue00b', 0xAAAC}, {'\ue00c', 0xAAAD}, {'\ue00d', 0xAAAE},
		{'\ue00e', 0xAAAF}, {'\ue00f', 0xAAB0}, {'\ue010', 0xAAB1},
		{'\ue011', 0xAAB2}, {'\ue012', 0xAAB3}, {'\ue013', 0xAAB4},
		{'\ue014', 0xAAB5}, {'\ue015', 0xAAB6}, {'\ue016', 0xAAB7},
		{'\ue017', 0xAAB8}, {'\ue018', 0xAAB9}, {'\ue019', 0xAABA},
		{'\ue01a', 0xAABB}, {'\ue01b', 0xAABC}, {'\ue01c', 0xAABD},
		{'\ue01d', 0xAABE}, {'\ue01e', 0xAABF}, {'\ue01f', 0xAAC0},
		{'\ue020', 0xAAC1}, {'\ue021', 0xAAC2}, {'\ue022', 0xAAC3},
		{'\ue023', 0xAAC4}, {'\ue024', 0xAAC5}, {'\ue025', 0xAAC6},
		{'\ue026', 0xAAC7}, {'\ue027', 0xAAC8}, {'\ue028', 0xAAC9},
		{'\ue029', 0xAACA}, {'\ue02a', 0xAACB}, {'\ue02b', 0xAACC},
		{'\ue02c', 0xAACD}, {'\ue02d', 0xAACE}, {'\ue02e', 0xAACF},
		{'\ue02f', 0xAAD0}, {'\ue030', 0xAAD1}, {'\ue031', 0xAAD2},
		{'\ue032', 0xAAD3}, {'\ue033', 0xAAD4}, {'\ue034', 0xAAD5},
		{'\ue035', 0xAAD6}, {'\ue036', 0xAAD7}, {'\ue037', 0xAAD8},
		{'\ue038', 0xAAD9}, {'\ue039', 0xAADA}, {'\ue03a', 0xAADB},
		{'\ue03b', 0xAADC}, {'\ue03c', 0xAADD}, {'\ue03d', 0xAADE},
		{'\ue03e', 0xAADF}, {'\ue03f', 0xAAE0}, {'\ue040', 0xAAE1},
		{'\ue041', 0xAAE2}, {'\ue042', 0xAAE3}, {'\ue043', 0xAAE4},
		{'\ue044', 0xAAE5}, {'\ue045', 0xAAE6}, {'\ue046', 0xAAE7},
		{'\ue047', 0xAAE8}, {'\ue048', 0xAAE9}, {'\ue049', 0xAAEA},
		{'\ue04a', 0xAAEB}, {'\ue04b', 0xAAEC}, {'\ue04c', 0xAAED},
		{'\ue04d', 0xAAEE}, {'\ue04e', 0xAAEF}, {'\ue04f', 0xAAF0},
		{'\ue050', 0xAAF1}, {'\ue051', 0xAAF2}, {'\ue052', 0xAAF3},
		{'\ue053', 0xAAF4}, {'\ue054', 0xAAF5}, {'\ue055', 0xAAF6},
		{'\ue056', 0xAAF7}, {'\ue057', 0xAAF8}, {'\ue058', 0xAAF9},
		{'\ue059', 0xAAFA}, {'\ue05a', 0xAAFB}, {'\ue05b', 0xAAFC},
		{'\ue05c', 0xAAFD}, {'\ue05d', 0xAAFE}, {'\ue05e', 0xABA1},
		{'\ue05f', 0xABA2}, {'\ue060', 0xABA3}, {'\ue061', 0xABA4},
		{'\ue062', 0xABA5}, {'\ue063', 0xABA6}, {'\ue064', 0xABA7},
		{'\ue065', 0xABA8}, {'\ue066', 0xABA9}, {'\ue067', 0xABAA},
		{'\ue068', 0xABAB}, {'\ue069', 0xABAC}, {'\ue06a', 0xABAD},
		{'\ue06b', 0xABAE}, {'\ue06c', 0xABAF}, {'\ue06d', 0xABB0},
		{'\ue06e', 0xABB1}, {'\ue06f', 0xABB2}, {'\ue070', 0xABB3},
		{'\ue071', 0xABB4}, {'\ue072', 0xABB5}, {'\ue073', 0xABB6},
		{'\ue074', 0xABB7}, {'\ue075', 0xABB8}, {'\ue076', 0xABB9},
		{'\ue077', 0xABBA}, {'\ue078', 0xABBB}, {'\ue079', 0xABBC},
		{'\ue07a', 0xABBD}, {'\ue07b', 0xABBE}, {'\ue07c', 0xABBF},
		{'\ue07d', 0xABC0}, {'\ue07e', 0xABC1}, {'\ue07f', 0xABC2},
		{'\ue080', 0xABC3}, {'\ue081', 0xABC4}, {'\ue082', 0xABC5},
		{'\ue083', 0xABC6}, {'\ue084', 0xABC7}, {'\ue085', 0xABC8},
		{'\ue086', 0xABC9}, {'\ue087', 0xABCA}, {'\ue088', 0xABCB},
		{'\ue089', 0xABCC}, {'\ue08a', 0xABCD}, {'\ue08b', 0xABCE},
		{'\ue08c', 0xABCF}, {'\ue08d', 0xABD0}, {'\ue08e', 0xABD1},
		{'\ue08f', 0xABD2}, {'\ue090', 0xABD3}, {'\ue091', 0xABD4},
		{'\ue092', 0xABD5}, {'\ue093', 0xABD6}, {'\ue094', 0xABD7},
		{'\ue095', 0xABD8}, {'\ue096', 0xABD9}, {'\ue097', 0xABDA},
		{'\ue098', 0xABDB}, {'\ue099', 0xABDC}, {'\ue09a', 0xABDD},
		{'\ue09b', 0xABDE}, {'\ue09c', 0xABDF}, {'\ue09d', 0xABE0},
		{'\ue09e', 0xABE1}, {'\ue09f', 0xABE2}, {'\ue0a0', 0xABE3},
		{'\ue0a1', 0xABE4}, {'\ue0a2', 0xABE5}, {'\ue0a3', 0xABE6},
		{'\ue0a4', 0xABE7}, {'\ue0a5', 0xABE8}, {'\ue0a6', 0xABE9},
		{'\ue0a7', 0xABEA}, {'\ue0a8', 0xABEB}, {'\ue0a9', 0xABEC},
		{'\ue0aa', 0xABED}, {'\ue0ab', 0xABEE}, {'\ue0ac', 0xABEF},
		{'\ue0ad', 0xABF0}, {'\ue0ae', 0xABF1}, {'\ue0af', 0xABF2},
		{'\ue0b0', 0xABF3}, {'\ue0b1', 0xABF4}, {'\ue0b2', 0xABF5},
		{'\ue0b3', 0xABF6}, {'\ue0b4', 0xABF7}, {'\ue0b5', 0xABF8},
		{'\ue0b6', 0xABF9}, {'\ue0b7', 0xABFA}, {'\ue0b8', 0xABFB},
		{'\ue0b9', 0xABFC}, {'\ue0ba', 0xABFD}, {'\ue0bb', 0xABFE},
		{'\ue0bc', 0xACA1}, {'\ue0bd', 0xACA2}, {'\ue0be', 0xACA3},
		{'\ue0bf', 0xACA4}, {'\ue0c0', 0xACA5}, {'\ue0c1', 0xACA6},
		{'\ue0c2', 0xACA7}, {'\ue0c3', 0xACA8}, {'\ue0c4', 0xACA9},
		{'\ue0c5', 0xACAA}, {'\ue0c6', 0xACAB}, {'\ue0c7', 0xACAC},
		{'\ue0c8', 0xACAD}, {'\ue0c9', 0xACAE}, {'\ue0ca', 0xACAF},
		{'\ue0cb', 0xACB0}, {'\ue0cc', 0xACB1}, {'\ue0cd', 0xACB2},
		{'\ue0ce', 0xACB3}, {'\ue0cf', 0xACB4}, {'\ue0d0', 0xACB5},
		{'\ue0d1', 0xACB6}, {'\ue0d2', 0xACB7}, {'\ue0d3', 0xACB8},
		{'\ue0d4', 0xACB9}, {'\ue0d5', 0xACBA}, {'\ue0d6', 0xACBB},
		{'\ue0d7', 0xACBC}, {'\ue0d8', 0xACBD}, {'\ue0d9', 0xACBE},
		{'\ue0da', 0xACBF}, {'\ue0db', 0xACC0}, {'\ue0dc', 0xACC1},
		{'\ue0dd', 0xACC2}, {'\ue0de', 0xACC3}, {'\ue0df', 0xACC4},
		{'\ue0e0', 0xACC5}, {'\ue0e1', 0xACC6}, {'\ue0e2', 0xACC7},
		{'\ue0e3', 0xACC8}, {'\ue0e4', 0xACC9}, {'\ue0e5', 0xACCA},
		{'\ue0e6', 0xACCB}, {'\ue0e7', 0xACCC}, {'\ue0e8', 0xACCD},
		{'\ue0e9', 0xACCE}, {'\ue0ea', 0xACCF}, {'\ue0eb', 0xACD0},
		{'\ue0ec', 0xACD1}, {'\ue0ed', 0xACD2}, {'\ue0ee', 0xACD3},
		{'\ue0ef', 0xACD4}, {'\ue0f0', 0xACD5}, {'\ue0f1', 0xACD6},
		{'\ue0f2', 0xACD7}, {'\ue0f3', 0xACD8}, {'\ue0f4', 0xACD9},
		{'\ue0f5', 0xACDA}, {'\ue0f6', 0xACDB}, {'\ue0f7', 0xACDC},
		{'\ue0f8', 0xACDD}, {'\ue0f9', 0xACDE}, {'\ue0fa', 0xACDF},
		{'\ue0fb', 0xACE0}, {'\ue0fc', 0xACE1}, {'\ue0fd', 0xACE2},
		{'\ue0fe', 0xACE3}, {'\ue0ff', 0xACE4}, {'\ue100', 0xACE5},
		{'\ue101', 0xACE6}, {'\ue102', 0xACE7}, {'\ue103', 0xACE8},
		{'\ue104', 0xACE9}, {'\ue105', 0xACEA}, {'\ue106', 0xACEB},
		{'\ue107', 0xACEC}, {'\ue108', 0xACED}, {'\ue109', 0xACEE},
		{'\ue10a', 0xACEF}, {'\ue10b', 0xACF0}, {'\ue10c', 0xACF1},
		{'\ue10d', 0xACF2}, {'\ue10e', 0xACF3}, {'\ue10f', 0xACF4},
		{'\ue110', 0xACF5}, {'\ue111', 0xACF6}, {'\ue112', 0xACF7},
		{'\ue113', 0xACF8}, {'\ue114', 0xACF9}, {'\ue115', 0xACFA},
		{'\ue116', 0xACFB}, {'\ue117', 0xACFC}, {'\ue118', 0xACFD},
		{'\ue119', 0xACFE}, {'\ue11a', 0xADA1}, {'\ue11b', 0xADA2},
		{'\ue11c', 0xADA3}, {'\ue11d', 0xADA4}, {'\ue11e', 0xADA5},
		{'\ue11f', 0xADA6}, {'\ue120', 0xADA7}, {'\ue121', 0xADA8},
		{'\ue122', 0xADA9}, {'\ue123', 0xADAA}, {'\ue124', 0xADAB},
		{'\ue125', 0xADAC}, {'\ue126', 0xADAD}, {'\ue127', 0xADAE},
		{'\ue128', 0xADAF}, {'\ue129', 0xADB0}, {'\ue12a', 0xADB1},
		{'\ue12b', 0xADB2}, {'\ue12c', 0xADB3}, {'\ue12d', 0xADB4},
		{'\ue12e', 0xADB5}, {'\ue12f', 0xADB6}, {'\ue130', 0xADB7},
		{'\ue131', 0xADB8}, {'\ue132', 0xADB9}, {'\ue133', 0xADBA},
		{'\ue134', 0xADBB}, {'\ue135', 0xADBC}, {'\ue136', 0xADBD},
		{'\ue137', 0xADBE}, {'\ue138', 0xADBF}, {'\ue139', 0xADC0},
		{'\ue13a', 0xADC1}, {'\ue13b', 0xADC2}, {'\ue13c', 0xADC3},
		{'\ue13d', 0xADC4}, {'\ue13e', 0xADC5}, {'\ue13f', 0xADC6},
		{'\ue140', 0xADC7}, {'\ue141', 0xADC8}, {'\ue142', 0xADC9},
		{'\ue143', 0xADCA}, {'\ue144', 0xADCB}, {'\ue145', 0xADCC},
		{'\ue146', 0xADCD}, {'\ue147', 0xADCE}, {'\ue148', 0xADCF},
		{'\ue149', 0xADD0}, {'\ue14a', 0xADD1}, {'\ue14b', 0xADD2},
		{'\ue14c', 0xADD3}, {'\ue14d', 0xADD4}, {'\ue14e', 0xADD5},
		{'\ue14f', 0xADD6}, {'\ue150', 0xADD7}, {'\ue151', 0xADD8},
		{'\ue152', 0xADD9}, {'\ue153', 0xADDA}, {'\ue154', 0xADDB},
		{'\ue155', 0xADDC}, {'\ue156', 0xADDD}, {'\ue157', 0xADDE},
		{'\ue158', 0xADDF}, {'\ue159', 0xADE0}, {'\ue15a', 0xADE1},
		{'\ue15b', 0xADE2}, {'\ue15c', 0xADE3}, {'\ue15d', 0xADE4},
		{'\ue15e', 0xADE5}, {'\ue15f', 0xADE6}, {'\ue160', 0xADE7},
		{'\ue161', 0xADE8}, {'\ue162', 0xADE9}, {'\ue163', 0xADEA},
		{'\ue164', 0xADEB}, {'\ue165', 0xADEC}, {'\ue166', 0xADED},
		{'\ue167', 0xADEE}, {'\ue168', 0xADEF}, {'\ue169', 0xADF0},
		{'\ue16a', 0xADF1}, {'\ue16b', 0xADF2}, {'\ue16c', 0xADF3},
		{'\ue16d', 0xADF4}, {'\ue16e', 0xADF5}, {'\ue16f', 0xADF6},
		{'\ue170', 0xADF7}, {'\ue171', 0xADF8}, {'\ue172', 0xADF9},
		{'\ue173', 0xADFA}, {'\ue174', 0xADFB}, {'\ue175', 0xADFC},
		{'\ue176', 0xADFD}, {'\ue177', 0xADFE}, {'\ue178', 0xAEA1},
		{'\ue179', 0xAEA2}, {'\ue17a', 0xAEA3}, {'\ue17b', 0xAEA4},
		{'\ue17c', 0xAEA5}, {'\ue17d', 0xAEA6}, {'\ue17e', 0xAEA7},
		{'\ue17f', 0xAEA8}, {'\ue180', 0xAEA9}, {'\ue181', 0xAEAA},
		{'\ue182', 0xAEAB}, {'\ue183', 0xAEAC}, {'\ue184', 0xAEAD},
		{'\ue185', 0xAEAE}, {'\ue186', 0xAEAF}, {'\ue187', 0xAEB0},
		{'\ue188', 0xAEB1}, {'\ue189', 0xAEB2}, {'\ue18a', 0xAEB3},
		{'\ue18b', 0xAEB4}, {'\ue18c', 0xAEB5}, {'\ue18d', 0xAEB6},
		{'\ue18e', 0xAEB7}, {'\ue18f', 0xAEB8}, {'\ue190', 0xAEB9},
		{'\ue191', 0xAEBA}, {'\ue192', 0xAEBB}, {'\ue193', 0xAEBC},
		{'\ue194', 0xAEBD}, {'\ue195', 0xAEBE}, {'\ue196', 0xAEBF},
		{'\ue197', 0xAEC0}, {'\ue198', 0xAEC1}, {'\ue199', 0xAEC2},
		{'\ue19a', 0xAEC3}, {'\ue19b', 0xAEC4}, {'\ue19c', 0xAEC5},
		{'\ue19d', 0xAEC6}, {'\ue19e', 0xAEC7}, {'\ue19f', 0xAEC8},
		{'\ue1a0', 0xAEC9}, {'\ue1a1', 0xAECA}, {'\ue1a2', 0xAECB},
		{'\ue1a3', 0xAECC}, {'\ue1a4', 0xAECD}, {'\ue1a5', 0xAECE},
		{'\ue1a6', 0xAECF}, {'\ue1a7', 0xAED0}, {'\ue1a8', 0xAED1},
		{'\ue1a9', 0xAED2}, {'\ue1aa', 0xAED3}, {'\ue1ab', 0xAED4},
		{'\ue1ac', 0xAED5}, {'\ue1ad', 0xAED6}, {'\ue1ae', 0xAED7},
		{'\ue1af', 0xAED8}, {'\ue1b0', 0xAED9}, {'\ue1b1', 0xAEDA},
		{'\ue1b2', 0xAEDB}, {'\ue1b3', 0xAEDC}, {'\ue1b4', 0xAEDD},
		{'\ue1b5', 0xAEDE}, {'\ue1b6', 0xAEDF}, {'\ue1b7', 0xAEE0},
		{'\ue1b8', 0xAEE1}, {'\ue1b9', 0xAEE2}, {'\ue1ba', 0xAEE3},
		{'\ue1bb', 0xAEE4}, {'\ue1bc', 0xAEE5}, {'\ue1bd', 0xAEE6},
		{'\ue1be', 0xAEE7}, {'\ue1bf', 0xAEE8}, {'\ue1c0', 0xAEE9},
		{'\ue1c1', 0xAEEA}, {'\ue1c2', 0xAEEB}, {'\ue1c3', 0xAEEC},
		{'\ue1c4', 0xAEED}, {'\ue1c5', 0xAEEE}, {'\ue1c6', 0xAEEF},
		{'\ue1c7', 0xAEF0}, {'\ue1c8', 0xAEF1}, {'\ue1c9', 0xAEF2},
		{'\ue1ca', 0xAEF3}, {'\ue1cb', 0xAEF4}, {'\ue1cc', 0xAEF5},
		{'\ue1cd', 0xAEF6}, {'\ue1ce', 0xAEF7}, {'\ue1cf', 0xAEF8},
		{'\ue1d0', 0xAEF9}, {'\ue1d1', 0xAEFA}, {'\ue1d2', 0xAEFB},
		{'\ue1d3', 0xAEFC}, {'\ue1d4', 0xAEFD}, {'\ue1d5', 0xAEFE},
		{'\ue1d6', 0xAFA1}, {'\ue1d7', 0xAFA2}, {'\ue1d8', 0xAFA3},
		{'\ue1d9', 0xAFA4}, {'\ue1da', 0xAFA5}, {'\ue1db', 0xAFA6},
		{'\ue1dc', 0xAFA7}, {'\ue1dd', 0xAFA8}, {'\ue1de', 0xAFA9},
		{'\ue1df', 0xAFAA}, {'\ue1e0', 0xAFAB}, {'\ue1e1', 0xAFAC},
		{'\ue1e2', 0xAFAD}, {'\ue1e3', 0xAFAE}, {'\ue1e4', 0xAFAF},
		{'\ue1e5', 0xAFB0}, {'\ue1e6', 0xAFB1}, {'\ue1e7', 0xAFB2},
		{'\ue1e8', 0xAFB3}, {'\ue1e9', 0xAFB4}, {'\ue1ea', 0xAFB5},
		{'\ue1eb', 0xAFB6}, {'\ue1ec', 0xAFB7}, {'\ue1ed', 0xAFB8},
		{'\ue1ee', 0xAFB9}, {'\ue1ef', 0xAFBA}, {'\ue1f0', 0xAFBB},
		{'\ue1f1', 0xAFBC}, {'\ue1f2', 0xAFBD}, {'\ue1f3', 0xAFBE},
		{'\ue1f4', 0xAFBF}, {'\ue1f5', 0xAFC0}, {'\ue1f6', 0xAFC1},
		{'\ue1f7', 0xAFC2}, {'\ue1f8', 0xAFC3}, {'\ue1f9', 0xAFC4},
		{'\ue1fa', 0xAFC5}, {'\ue1fb', 0xAFC6}, {'\ue1fc', 0xAFC7},
		{'\ue1fd', 0xAFC8}, {'\ue1fe', 0xAFC9}, {'\ue1ff', 0xAFCA},
		{'\ue200', 0xAFCB}, {'\ue201', 0xAFCC}, {'\ue202', 0xAFCD},
		{'\ue203', 0xAFCE}, {'\ue204', 0xAFCF}, {'\ue205', 0xAFD0},
		{'\ue206', 0xAFD1}, {'\ue207', 0xAFD2}, {'\ue208', 0xAFD3},
		{'\ue209', 0xAFD4}, {'\ue20a', 0xAFD5}, {'\ue20b', 0xAFD6},
		{'\ue20c', 0xAFD7}, {'\ue20d', 0xAFD8}, {'\ue20e', 0xAFD9},
		{'\ue20f', 0xAFDA}, {'\ue210', 0xAFDB}, {'\ue211', 0xAFDC},
		{'\ue212', 0xAFDD}, {'\ue213', 0xAFDE}, {'\ue214', 0xAFDF},
		{'\ue215', 0xAFE0}, {'\ue216', 0xAFE1}, {'\ue217', 0xAFE2},
		{'\ue218', 0xAFE3}, {'\ue219', 0xAFE4}, {'\ue21a', 0xAFE5},
		{'\ue21b', 0xAFE6}, {'\ue21c', 0xAFE7}, {'\ue21d', 0xAFE8},
		{'\ue21e', 0xAFE9}, {'\ue21f', 0xAFEA}, {'\ue220', 0xAFEB},
		{'\ue221', 0xAFEC}, {'\ue222', 0xAFED}, {'\ue223', 0xAFEE},
		{'\ue224', 0xAFEF}, {'\ue225', 0xAFF0}, {'\ue226', 0xAFF1},
		{'\ue227', 0xAFF2}, {'\ue228', 0xAFF3}, {'\ue229', 0xAFF4},
		{'\ue22a', 0xAFF5}, {'\ue22b', 0xAFF6}, {'\ue22c', 0xAFF7},
		{'\ue22d', 0xAFF8}, {'\ue22e', 0xAFF9}, {'\ue22f', 0xAFFA},
		{'\ue230', 0xAFFB}, {'\ue231', 0xAFFC}, {'\ue232', 0xAFFD},
		{'\ue233', 0xAFFE}, {'\ue234', 0xF8A1}, {'\ue235', 0xF8A2},
		{'\ue236', 0xF8A3}, {'\ue237', 0xF8A4}, {'\ue238', 0xF8A5},
		{'\ue239', 0xF8A6}, {'\ue23a', 0xF8A7}, {'\ue23b', 0xF8A8},
		{'\ue23c', 0xF8A9}, {'\ue23d', 0xF8AA}, {'\ue23e', 0xF8AB},
		{'\ue23f', 0xF8AC}, {'\ue240', 0xF8AD}, {'\ue241', 0xF8AE},
		{'\ue242', 0xF8AF}, {'\ue243', 0xF8B0}, {'\ue244', 0xF8B1},
		{'\ue245', 0xF8B2}, {'\ue246', 0xF8B3}, {'\ue247', 0xF8B4},
		{'\ue248', 0xF8B5}, {'\ue249', 0xF8B6}, {'\ue24a', 0xF8B7},
		{'\ue24b', 0xF8B8}, {'\ue24c', 0xF8B9}, {'\ue24d', 0xF8BA},
		{'\ue24e', 0xF8BB}, {'\ue24f', 0xF8BC}, {'\ue250', 0xF8BD},
		{'\ue251', 0xF8BE}, {'\ue252', 0xF8BF}, {'\ue253', 0xF8C0},
		{'\ue254', 0xF8C1}, {'\ue255', 0xF8C2}, {'\ue256', 0xF8C3},
		{'\ue257', 0xF8C4}, {'\ue258', 0xF8C5}, {'\ue259', 0xF8C6},
		{'\ue25a', 0xF8C7}, {'\ue25b', 0xF8C8}, {'\ue25c', 0xF8C9},
		{'\ue25d', 0xF8CA}, {'\ue25e', 0xF8CB}, {'\ue25f', 0xF8CC},
		{'\ue260', 0xF8CD}, {'\ue261', 0xF8CE}, {'\ue262', 0xF8CF},
		{'\ue263', 0xF8D0}, {'\ue264', 0xF8D1}, {'\ue265', 0xF8D2},
		{'\ue266', 0xF8D3}, {'\ue267', 0xF8D4}, {'\ue268', 0xF8D5},
		{'\ue269', 0xF8D6}, {'\ue26a', 0xF8D7}, {'\ue26b', 0xF8D8},
		{'\ue26c', 0xF8D9}, {'\ue26d', 0xF8DA}, {'\ue26e', 0xF8DB},
		{'\ue26f', 0xF8DC}, {'\ue270', 0xF8DD}, {'\ue271', 0xF8DE},
		{'\ue272', 0xF8DF}, {'\ue273', 0xF8E0}, {'\ue274', 0xF8E1},
		{'\ue275', 0xF8E2}, {'\ue276', 0xF8E3}, {'\ue277', 0xF8E4},
		{'\ue278', 0xF8E5}, {'\ue279', 0xF8E6}, {'\ue27a', 0xF8E7},
		{'\ue27b', 0xF8E8}, {'\ue27c', 0xF8E9}, {'\ue27d', 0xF8EA},
		{'\ue27e', 0xF8EB}, {'\ue27f', 0xF8EC}, {'\ue280', 0xF8ED},
		{'\ue281', 0xF8EE}, {'\ue282', 0xF8EF}, {'\ue283', 0xF8F0},
		{'\ue284', 0xF8F1}, {'\ue285', 0xF8F2}, {'\ue286', 0xF8F3},
		{'\ue287', 0xF8F4}, {'\ue288', 0xF8F5}, {'\ue289', 0xF8F6},
		{'\ue28a', 0xF8F7}, {'\ue28b', 0xF8F8}, {'\ue28c', 0xF8F9},
		{'\ue28d', 0xF8FA}, {'\ue28e', 0xF8FB}, {'\ue28f', 0xF8FC},
		{'\ue290', 0xF8FD}, {'\ue291', 0xF8FE}, {'\ue292', 0xF9A1},
		{'\ue293', 0xF9A2}, {'\ue294', 0xF9A3}, {'\ue295', 0xF9A4},
		{'\ue296', 0xF9A5}, {'\ue297', 0xF9A6}, {'\ue298', 0xF9A7},
		{'\ue299', 0xF9A8}, {'\ue29a', 0xF9A9}, {'\ue29b', 0xF9AA},
		{'\ue29c', 0xF9AB}, {'\ue29d', 0xF9AC}, {'\ue29e', 0xF9AD},
		{'\ue29f', 0xF9AE}, {'\ue2a0', 0xF9AF}, {'\ue2a1', 0xF9B0},
		{'\ue2a2', 0xF9B1}, {'\ue2a3', 0xF9B2}, {'\ue2a4', 0xF9B3},
		{'\ue2a5', 0xF9B4}, {'\ue2a6', 0xF9B5}, {'\ue2a7', 0xF9B6},
		{'\ue2a8', 0xF9B7}, {'\ue2a9', 0xF9B8}, {'\ue2aa', 0xF9B9},
		{'\ue2ab', 0xF9BA}, {'\ue2ac', 0xF9BB}, {'\ue2ad', 0xF9BC},
		{'\ue2ae', 0xF9BD}, {'\ue2af', 0xF9BE}, {'\ue2b0', 0xF9BF},
		{'\ue2b1', 0xF9C0}, {'\ue2b2', 0xF9C1}, {'\ue2b3', 0xF9C2},
		{'\ue2b4', 0xF9C3}, {'\ue2b5', 0xF9C4}, {'\ue2b6', 0xF9C5},
		{'\ue2b7', 0xF9C6}, {'\ue2b8', 0xF9C7}, {'\ue2b9', 0xF9C8},
		{'\ue2ba', 0xF9C9}, {'\ue2bb', 0xF9CA}, {'\ue2bc', 0xF9CB},
		{'\ue2bd', 0xF9CC}, {'\ue2be', 0xF9CD}, {'\ue2bf', 0xF9CE},
		{'\ue2c0', 0xF9CF}, {'\ue2c1', 0xF9D0}, {'\ue2c2', 0xF9D1},
		{'\ue2c3', 0xF9D2}, {'\ue2c4', 0xF9D3}, {'\ue2c5', 0xF9D4},
		{'\ue2c6', 0xF9D5}, {'\ue2c7', 0xF9D6}, {'\ue2c8', 0xF9D7},
		{'\ue2c9', 0xF9D8}, {'\ue2ca', 0xF9D9}, {'\ue2cb', 0xF9DA},
		{'\ue2cc', 0xF9DB}, {'\ue2cd', 0xF9DC}, {'\ue2ce', 0xF9DD},
		{'\ue2cf', 0xF9DE}, {'\ue2d0', 0xF9DF}, {'\ue2d1', 0xF9E0},
		{'\ue2d2', 0xF9E1}, {'\ue2d3', 0xF9E2}, {'\ue2d4', 0xF9E3},
		{'\ue2d5', 0xF9E4}, {'\ue2d6', 0xF9E5}, {'\ue2d7', 0xF9E6},
		{'\ue2d8', 0xF9E7}, {'\ue2d9', 0xF9E8}, {'\ue2da', 0xF9E9},
		{'\ue2db', 0xF9EA}, {'\ue2dc', 0xF9EB}, {'\ue2dd', 0xF9EC},
		{'\ue2de', 0xF9ED}, {'\ue2df', 0xF9EE}, {'\ue2e0', 0xF9EF},
		{'\ue2e1', 0xF9F0}, {'\ue2e2', 0xF9F1}, {'\ue2e3', 0xF9F2},
		{'\ue2e4', 0xF9F3}, {'\ue2e5', 0xF9F4}, {'\ue2e6', 0xF9F5},
		{'\ue2e7', 0xF9F6}, {'\ue2e8', 0xF9F7}, {'\ue2e9', 0xF9F8},
		{'\ue2ea', 0xF9F9}, {'\ue2eb', 0xF9FA}, {'\ue2ec', 0xF9FB},
		{'\ue2ed', 0xF9FC}, {'\ue2ee', 0xF9FD}, {'\ue2ef', 0xF9FE},
		{'\ue2f0', 0xFAA1}, {'\ue2f1', 0xFAA2}, {'\ue2f2', 0xFAA3},
		{'\ue2f3', 0xFAA4}, {'\ue2f4', 0xFAA5}, {'\ue2f5', 0xFAA6},
		{'\ue2f6', 0xFAA7}, {'\ue2f7', 0xFAA8}, {'\ue2f8', 0xFAA9},
		{'\ue2f9', 0xFAAA}, {'\ue2fa', 0xFAAB}, {'\ue2fb', 0xFAAC},
		{'\ue2fc', 0xFAAD}, {'\ue2fd', 0xFAAE}, {'\ue2fe', 0xFAAF},
		{'\ue2ff', 0xFAB0}, {'\ue300', 0xFAB1}, {'\ue301', 0xFAB2},
		{'\ue302', 0xFAB3}, {'\ue303', 0xFAB4}, {'\ue304', 0xFAB5},
		{'\ue305', 0xFAB6}, {'\ue306', 0xFAB7}, {'\ue307', 0xFAB8},
		{'\ue308', 0xFAB9}, {'\ue309', 0xFABA}, {'\ue30a', 0xFABB},
		{'\ue30b', 0xFABC}, {'\ue30c', 0xFABD}, {'\ue30d', 0xFABE},
		{'\ue30e', 0xFABF}, {'\ue30f', 0xFAC0}, {'\ue310', 0xFAC1},
		{'\ue311', 0xFAC2}, {'\ue312', 0xFAC3}, {'\ue313', 0xFAC4},
		{'\ue314', 0xFAC5}, {'\ue315', 0xFAC6}, {'\ue316', 0xFAC7},
		{'\ue317', 0xFAC8}, {'\ue318', 0xFAC9}, {'\ue319', 0xFACA},
		{'\ue31a', 0xFACB}, {'\ue31b', 0xFACC}, {'\ue31c', 0xFACD},
		{'\ue31d', 0xFACE}, {'\ue31e', 0xFACF}, {'\ue31f', 0xFAD0},
		{'\ue320', 0xFAD1}, {'\ue321', 0xFAD2}, {'\ue322', 0xFAD3},
		{'\ue323', 0xFAD4}, {'\ue324', 0xFAD5}, {'\ue325', 0xFAD6},
		{'\ue326', 0xFAD7}, {'\ue327', 0xFAD8}, {'\ue328', 0xFAD9},
		{'\ue329', 0xFADA}, {'\ue32a', 0xFADB}, {'\ue32b', 0xFADC},
		{'\ue32c', 0xFADD}, {'\ue32d', 0xFADE}, {'\ue32e', 0xFADF},
		{'\ue32f', 0xFAE0}, {'\ue330', 0xFAE1}, {'\ue331', 0xFAE2},
		{'\ue332', 0xFAE3}, {'\ue333', 0xFAE4}, {'\ue334', 0xFAE5},
		{'\ue335', 0xFAE6}, {'\ue336', 0xFAE7}, {'\ue337', 0xFAE8},
		{'\ue338', 0xFAE9}, {'\ue339', 0xFAEA}, {'\ue33a', 0xFAEB},
		{'\ue33b', 0xFAEC}, {'\ue33c', 0xFAED}, {'\ue33d', 0xFAEE},
		{'\ue33e', 0xFAEF}, {'\ue33f', 0xFAF0}, {'\ue340', 0xFAF1},
		{'\ue341', 0xFAF2}, {'\ue342', 0xFAF3}, {'\ue343', 0xFAF4},
		{'\ue344', 0xFAF5}, {'\ue345', 0xFAF6}, {'\ue346', 0xFAF7},
		{'\ue347', 0xFAF8}, {'\ue348', 0xFAF9}, {'\ue349', 0xFAFA},
		{'\ue34a', 0xFAFB}, {'\ue34b', 0xFAFC}, {'\ue34c', 0xFAFD},
		{'\ue34d', 0xFAFE}, {'\ue34e', 0xFBA1}, {'\ue34f', 0xFBA2},
		{'\ue350', 0xFBA3}, {'\ue351', 0xFBA4}, {'\ue352', 0xFBA5},
		{'\ue353', 0xFBA6}, {'\ue354', 0xFBA7}, {'\ue355', 0xFBA8},
		{'\ue356', 0xFBA9}, {'\ue357', 0xFBAA}, {'\ue358', 0xFBAB},
		{'\ue359', 0xFBAC}, {'\ue35a', 0xFBAD}, {'\ue35b', 0xFBAE},
		{'\ue35c', 0xFBAF}, {'\ue35d', 0xFBB0}, {'\ue35e', 0xFBB1},
		{'\ue35f', 0xFBB2}, {'\ue360', 0xFBB3}, {'\ue361', 0xFBB4},
		{'\ue362', 0xFBB5}, {'\ue363', 0xFBB6}, {'\ue364', 0xFBB7},
		{'\ue365', 0xFBB8}, {'\ue366', 0xFBB9}, {'\ue367', 0xFBBA},
		{'\ue368', 0xFBBB}, {'\ue369', 0xFBBC}, {'\ue36a', 0xFBBD},
		{'\ue36b', 0xFBBE}, {'\ue36c', 0xFBBF}, {'\ue36d', 0xFBC0},
		{'\ue36e', 0xFBC1}, {'\ue36f', 0xFBC2}, {'\ue370', 0xFBC3},
		{'\ue371', 0xFBC4}, {'\ue372', 0xFBC5}, {'\ue373', 0xFBC6},
		{'\ue374', 0xFBC7}, {'\ue375', 0xFBC8}, {'\ue376', 0xFBC9},
		{'\ue377', 0xFBCA}, {'\ue378', 0xFBCB}, {'\ue379', 0xFBCC},
		{'\ue37a', 0xFBCD}, {'\ue37b', 0xFBCE}, {'\ue37c', 0xFBCF},
		{'\ue37d', 0xFBD0}, {'\ue37e', 0xFBD1}, {'\ue37f', 0xFBD2},
		{'\ue380', 0xFBD3}, {'\ue381', 0xFBD4}, {'\ue382', 0xFBD5},
		{'\ue383', 0xFBD6}, {'\ue384', 0xFBD7}, {'\ue385', 0xFBD8},
		{'\ue386', 0xFBD9}, {'\ue387', 0xFBDA}, {'\ue388', 0xFBDB},
		{'\ue389', 0xFBDC}, {'\ue38a', 0xFBDD}, {'\ue38b', 0xFBDE},
		{'\ue38c', 0xFBDF}, {'\ue38d', 0xFBE0}, {'\ue38e', 0xFBE1},
		{'\ue38f', 0xFBE2}, {'\ue390', 0xFBE3}, {'\ue391', 0xFBE4},
		{'\ue392', 0xFBE5}, {'\ue393', 0xFBE6}, {'\ue394', 0xFBE7},
		{'\ue395', 0xFBE8}, {'\ue396', 0xFBE9}, {'\ue397', 0xFBEA},
		{'\ue398', 0xFBEB}, {'\ue399', 0xFBEC}, {'\ue39a', 0xFBED},
		{'\ue39b', 0xFBEE}, {'\ue39c', 0xFBEF}, {'\ue39d', 0xFBF0},
		{'\ue39e', 0xFBF1}, {'\ue39f', 0xFBF2}, {'\ue3a0', 0xFBF3},
		{'\ue3a1', 0xFBF4}, {'\ue3a2', 0xFBF5}, {'\ue3a3', 0xFBF6},
		{'\ue3a4', 0xFBF7}, {'\ue3a5', 0xFBF8}, {'\ue3a6', 0xFBF9},
		{'\ue3a7', 0xFBFA}, {'\ue3a8', 0xFBFB}, {'\ue3a9', 0xFBFC},
		{'\ue3aa', 0xFBFD}, {'\ue3ab', 0xFBFE}, {'\ue3ac', 0xFCA1},
		{'\ue3ad', 0xFCA2}, {'\ue3ae', 0xFCA3}, {'\ue3af', 0xFCA4},
		{'\ue3b0', 0xFCA5}, {'\ue3b1', 0xFCA6}, {'\ue3b2', 0xFCA7},
		{'\ue3b3', 0xFCA8}, {'\ue3b4', 0xFCA9}, {'\ue3b5', 0xFCAA},
		{'\ue3b6', 0xFCAB}, {'\ue3b7', 0xFCAC}, {'\ue3b8', 0xFCAD},
		{'\ue3b9', 0xFCAE}, {'\ue3ba', 0xFCAF}, {'\ue3bb', 0xFCB0},
		{'\ue3bc', 0xFCB1}, {'\ue3bd', 0xFCB2}, {'\ue3be', 0xFCB3},
		{'\ue3bf', 0xFCB4}, {'\ue3c0', 0xFCB5}, {'\ue3c1', 0xFCB6},
		{'\ue3c2', 0xFCB7}, {'\ue3c3', 0xFCB8}, {'\ue3c4', 0xFCB9},
		{'\ue3c5', 0xFCBA}, {'\ue3c6', 0xFCBB}, {'\ue3c7', 0xFCBC},
		{'\ue3c8', 0xFCBD}, {'\ue3c9', 0xFCBE}, {'\ue3ca', 0xFCBF},
		{'\ue3cb', 0xFCC0}, {'\ue3cc', 0xFCC1}, {'\ue3cd', 0xFCC2},
		{'\ue3ce', 0xFCC3}, {'\ue3cf', 0xFCC4}, {'\ue3d0', 0xFCC5},
		{'\ue3d1', 0xFCC6}, {'\ue3d2', 0xFCC7}, {'\ue3d3', 0xFCC8},
		{'\ue3d4', 0xFCC9}, {'\ue3d5', 0xFCCA}, {'\ue3d6', 0xFCCB},
		{'\ue3d7', 0xFCCC}, {'\ue3d8', 0xFCCD}, {'\ue3d9', 0xFCCE},
		{'\ue3da', 0xFCCF}, {'\ue3db', 0xFCD0}, {'\ue3dc', 0xFCD1},
		{'\ue3dd', 0xFCD2}, {'\ue3de', 0xFCD3}, {'\ue3df', 0xFCD4},
		{'\ue3e0', 0xFCD5}, {'\ue3e1', 0xFCD6}, {'\ue3e2', 0xFCD7},
		{'\ue3e3', 0xFCD8}, {'\ue3e4', 0xFCD9}, {'\ue3e5', 0xFCDA},
		{'\ue3e6', 0xFCDB}, {'\ue3e7', 0xFCDC}, {'\ue3e8', 0xFCDD},
		{'\ue3e9', 0xFCDE}, {'\ue3ea', 0xFCDF}, {'\ue3eb', 0xFCE0},
		{'\ue3ec', 0xFCE1}, {'\ue3ed', 0xFCE2}, {'\ue3ee', 0xFCE3},
		{'\ue3ef', 0xFCE4}, {'\ue3f0', 0xFCE5}, {'\ue3f1', 0xFCE6},
		{'\ue3f2', 0xFCE7}, {'\ue3f3', 0xFCE8}, {'\ue3f4', 0xFCE9},
		{'\ue3f5', 0xFCEA}, {'\ue3f6', 0xFCEB}, {'\ue3f7', 0xFCEC},
		{'\ue3f8', 0xFCED}, {'\ue3f9', 0xFCEE}, {'\ue3fa', 0xFCEF},
		{'\ue3fb', 0xFCF0}, {'\ue3fc', 0xFCF1}, {'\ue3fd', 0xFCF2},
		{'\ue3fe', 0xFCF3}, {'\ue3ff', 0xFCF4}, {'\ue400', 0xFCF5},
		{'\ue401', 0xFCF6}, {'\ue402', 0xFCF7}, {'\ue403', 0xFCF8},
		{'\ue404', 0xFCF9}, {'\ue405', 0xFCFA}, {'\ue406', 0xFCFB},
		{'\ue407', 0xFCFC}, {'\ue408', 0xFCFD}, {'\ue409', 0xFCFE},
		{'\ue40a', 0xFDA1}, {'\ue40b', 0xFDA2}, {'\ue40c', 0xFDA3},
		{'\ue40d', 0xFDA4}, {'\ue40e', 0xFDA5}, {'\ue40f', 0xFDA6},
		{'\ue410', 0xFDA7}, {'\ue411', 0xFDA8}, {'\ue412', 0xFDA9},
		{'\ue413', 0xFDAA}, {'\ue414', 0xFDAB}, {'\ue415', 0xFDAC},
		{'\ue416', 0xFDAD}, {'\ue417', 0xFDAE}, {'\ue418', 0xFDAF},
		{'\ue419', 0xFDB0}, {'\ue41a', 0xFDB1}, {'\ue41b', 0xFDB2},
		{'\ue41c', 0xFDB3}, {'\ue41d', 0xFDB4}, {'\ue41e', 0xFDB5},
		{'\ue41f', 0xFDB6}, {'\ue420', 0xFDB7}, {'\ue421', 0xFDB8},
		{'\ue422', 0xFDB9}, {'\ue423', 0xFDBA}, {'\ue424', 0xFDBB},
		{'\ue425', 0xFDBC}, {'\ue426', 0xFDBD}, {'\ue427', 0xFDBE},
		{'\ue428', 0xFDBF}, {'\ue429', 0xFDC0}, {'\ue42a', 0xFDC1},
		{'\ue42b', 0xFDC2}, {'\ue42c', 0xFDC3}, {'\ue42d', 0xFDC4},
		{'\ue42e', 0xFDC5}, {'\ue42f', 0xFDC6}, {'\ue430', 0xFDC7},
		{'\ue431', 0xFDC8}, {'\ue432', 0xFDC9}, {'\ue433', 0xFDCA},
		{'\ue434', 0xFDCB}, {'\ue435', 0xFDCC}, {'\ue436', 0xFDCD},
		{'\ue437', 0xFDCE}, {'\ue438', 0xFDCF}, {'\ue439', 0xFDD0},
		{'\ue43a', 0xFDD1}, {'\ue43b', 0xFDD2}, {'\ue43c', 0xFDD3},
		{'\ue43d', 0xFDD4}, {'\ue43e', 0xFDD5}, {'\ue43f', 0xFDD6},
		{'\ue440', 0xFDD7}, {'\ue441', 0xFDD8}, {'\ue442', 0xFDD9},
		{'\ue443', 0xFDDA}, {'\ue444', 0xFDDB}, {'\ue445', 0xFDDC},
		{'\ue446', 0xFDDD}, {'\ue447', 0xFDDE}, {'\ue448', 0xFDDF},
		{'\ue449', 0xFDE0}, {'\ue44a', 0xFDE1}, {'\ue44b', 0xFDE2},
		{'\ue44c', 0xFDE3}, {'\ue44d', 0xFDE4}, {'\ue44e', 0xFDE5},
		{'\ue44f', 0xFDE6}, {'\ue450', 0xFDE7}, {'\ue451', 0xFDE8},
		{'\ue452', 0xFDE9}, {'\ue453', 0xFDEA}, {'\ue454', 0xFDEB},
		{'\ue455', 0xFDEC}, {'\ue456', 0xFDED}, {'\ue457', 0xFDEE},
		{'\ue458', 0xFDEF}, {'\ue459', 0xFDF0}, {'\ue45a', 0xFDF1},
		{'\ue45b', 0xFDF2}, {'\ue45c', 0xFDF3}, {'\ue45d', 0xFDF4},
		{'\ue45e', 0xFDF5}, {'\ue45f', 0xFDF6}, {'\ue460', 0xFDF7},
		{'\ue461', 0xFDF8}, {'\ue462', 0xFDF9}, {'\ue463', 0xFDFA},
		{'\ue464', 0xFDFB}, {'\ue465', 0xFDFC}, {'\ue466', 0xFDFD},
		{'\ue467', 0xFDFE}, {'\ue468', 0xFEA1}, {'\ue469', 0xFEA2},
		{'\ue46a', 0xFEA3}, {'\ue46b', 0xFEA4}, {'\ue46c', 0xFEA5},
		{'\ue46d', 0xFEA6}, {'\ue46e', 0xFEA7}, {'\ue46f', 0xFEA8},
		{'\ue470', 0xFEA9}, {'\ue471', 0xFEAA}, {'\ue472', 0xFEAB},
		{'\ue473', 0xFEAC}, {'\ue474', 0xFEAD}, {'\ue475', 0xFEAE},
		{'\ue476', 0xFEAF}, {'\ue477', 0xFEB0}, {'\ue478', 0xFEB1},
		{'\ue479', 0xFEB2}, {'\ue47a', 0xFEB3}, {'\ue47b', 0xFEB4},
		{'\ue47c', 0xFEB5}, {'\ue47d', 0xFEB6}, {'\ue47e', 0xFEB7},
		{'\ue47f', 0xFEB8}, {'\ue480', 0xFEB9}, {'\ue481', 0xFEBA},
		{'\ue482', 0xFEBB}, {'\ue483', 0xFEBC}, {'\ue484', 0xFEBD},
		{'\ue485', 0xFEBE}, {'\ue486', 0xFEBF}, {'\ue487', 0xFEC0},
		{'\ue488', 0xFEC1}, {'\ue489', 0xFEC2}, {'\ue48a', 0xFEC3},
		{'\ue48b', 0xFEC4}, {'\ue48c', 0xFEC5}, {'\ue48d', 0xFEC6},
		{'\ue48e', 0xFEC7}, {'\ue48f', 0xFEC8}, {'\ue490', 0xFEC9},
		{'\ue491', 0xFECA}, {'\ue492', 0xFECB}, {'\ue493', 0xFECC},
		{'\ue494', 0xFECD}, {'\ue495', 0xFECE}, {'\ue496', 0xFECF},
		{'\ue497', 0xFED0}, {'\ue498', 0xFED1}, {'\ue499', 0xFED2},
		{'\ue49a', 0xFED3}, {'\ue49b', 0xFED4}, {'\ue49c', 0xFED5},
		{'\ue49d', 0xFED6}, {'\ue49e', 0xFED7}, {'\ue49f', 0xFED8},
		{'\ue4a0', 0xFED9}, {'\ue4a1', 0xFEDA}, {'\ue4a2', 0xFEDB},
		{'\ue4a3', 0xFEDC}, {'\ue4a4', 0xFEDD}, {'\ue4a5', 0xFEDE},
		{'\ue4a6', 0xFEDF}, {'\ue4a7', 0xFEE0}, {'\ue4a8', 0xFEE1},
		{'\ue4a9', 0xFEE2}, {'\ue4aa', 0xFEE3}, {'\ue4ab', 0xFEE4},
		{'\ue4ac', 0xFEE5}, {'\ue4ad', 0xFEE6}, {'\ue4ae', 0xFEE7},
		{'\ue4af', 0xFEE8}, {'\ue4b0', 0xFEE9}, {'\ue4b1', 0xFEEA},
		{'\ue4b2', 0xFEEB}, {'\ue4b3', 0xFEEC}, {'\ue4b4', 0xFEED},
		{'\ue4b5', 0xFEEE}, {'\ue4b6', 0xFEEF}, {'\ue4b7', 0xFEF0},
		{'\ue4b8', 0xFEF1}, {'\ue4b9', 0xFEF2}, {'\ue4ba', 0xFEF3},
		{'\ue4bb', 0xFEF4}, {'\ue4bc', 0xFEF5}, {'\ue4bd', 0xFEF6},
		{'\ue4be', 0xFEF7}, {'\ue4bf', 0xFEF8}, {'\ue4c0', 0xFEF9},
		{'\ue4c1', 0xFEFA}, {'\ue4c2', 0xFEFB}, {'\ue4c3', 0xFEFC},
		{'\ue4c4', 0xFEFD}, {'\ue4c5', 0xFEFE}, {'\ue4c6', 0xA140},
		{'\ue4c7', 0xA141}, {'\ue4c8', 0xA142}, {'\ue4c9', 0xA143},
		{'\ue4ca', 0xA144}, {'\ue4cb', 0xA145}, {'\ue4cc', 0xA146},
		{'\ue4cd', 0xA147}, {'\ue4ce', 0xA148}, {'\ue4cf', 0xA149},
		{'\ue4d0', 0xA14A}, {'\ue4d1', 0xA14B}, {'\ue4d2', 0xA14C},
		{'\ue4d3', 0xA14D}, {'\ue4d4', 0xA14E}, {'\ue4d5', 0xA14F},
		{'\ue4d6', 0xA150}, {'\ue4d7', 0xA151}, {'\ue4d8', 0xA152},
		{'\ue4d9', 0xA153}, {'\ue4da', 0xA154}, {'\ue4db', 0xA155},
		{'\ue4dc', 0xA156}, {'\ue4dd', 0xA157}, {'\ue4de', 0xA158},
		{'\ue4df', 0xA159}, {'\ue4e0', 0xA15A}, {'\ue4e1', 0xA15B},
		{'\ue4e2', 0xA15C}, {'\ue4e3', 0xA15D}, {'\ue4e4', 0xA15E},
		{'\ue4e5', 0xA15F}, {'\ue4e6', 0xA160}, {'\ue4e7', 0xA161},
		{'\ue4e8', 0xA162}, {'\ue4e9', 0xA163}, {'\ue4ea', 0xA164},
		{'\ue4eb', 0xA165}, {'\ue4ec', 0xA166}, {'\ue4ed', 0xA167},
		{'\ue4ee', 0xA168}, {'\ue4ef', 0xA169}, {'\ue4f0', 0xA16A},
		{'\ue4f1', 0xA16B}, {'\ue4f2', 0xA16C}, {'\ue4f3', 0xA16D},
		{'\ue4f4', 0xA16E}, {'\ue4f5', 0xA16F}, {'\ue4f6', 0xA170},
		{'\ue4f7', 0xA171}, {'\ue4f8', 0xA172}, {'\ue4f9', 0xA173},
		{'\ue4fa', 0xA174}, {'\ue4fb', 0xA175}, {'\ue4fc', 0xA176},
		{'\ue4fd', 0xA177}, {'\ue4fe', 0xA178}, {'\ue4ff', 0xA179},
		{'\ue500', 0xA17A}, {'\ue501', 0xA17B}, {'\ue502', 0xA17C},
		{'\ue503', 0xA17D}, {'\ue504', 0xA17E}, {'\ue505', 0xA180},
		{'\ue506', 0xA181}, {'\ue507', 0xA182}, {'\ue508', 0xA183},
		{'\ue509', 0xA184}, {'\ue50a', 0xA185}, {'\ue50b', 0xA186},
		{'\ue50c', 0xA187}, {'\ue50d', 0xA188}, {'\ue50e', 0xA189},
		{'\ue50f', 0xA18A}, {'\ue510', 0xA18B}, {'\ue511', 0xA18C},
		{'\ue512', 0xA18D}, {'\ue513', 0xA18E}, {'\ue514', 0xA18F},
		{'\ue515', 0xA190}, {'\ue516', 0xA191}, {'\ue517', 0xA192},
		{'\ue518', 0xA193}, {'\ue519', 0xA194}, {'\ue51a', 0xA195},
		{'\ue51b', 0xA196}, {'\ue51c', 0xA197}, {'\ue51d', 0xA198},
		{'\ue51e', 0xA199}, {'\ue51f', 0xA19A}, {'\ue520', 0xA19B},
		{'\ue521', 0xA19C}, {'\ue522', 0xA19D}, {'\ue523', 0xA19E},
		{'\ue524', 0xA19F}, {'\ue525', 0xA1A0}, {'\ue526', 0xA240},
		{'\ue527', 0xA241}, {'\ue528', 0xA242}, {'\ue529', 0xA243},
		{'\ue52a', 0xA244}, {'\ue52b', 0xA245}, {'\ue52c', 0xA246},
		{'\ue52d', 0xA247}, {'\ue52e', 0xA248}, {'\ue52f', 0xA249},
		{'\ue530', 0xA24A}, {'\ue531', 0xA24B}, {'\ue532', 0xA24C},
		{'\ue533', 0xA24D}, {'\ue534', 0xA24E}, {'\ue535', 0xA24F},
		{'\ue536', 0xA250}, {'\ue537', 0xA251}, {'\ue538', 0xA252},
		{'\ue539', 0xA253}, {'\ue53a', 0xA254}, {'\ue53b', 0xA255},
		{'\ue53c', 0xA256}, {'\ue53d', 0xA257}, {'\ue53e', 0xA258},
		{'\ue53f', 0xA259}, {'\ue540', 0xA25A}, {'\ue541', 0xA25B},
		{'\ue542', 0xA25C}, {'\ue543', 0xA25D}, {'\ue544', 0xA25E},
		{'\ue545', 0xA25F}, {'\ue546', 0xA260}, {'\ue547', 0xA261},
		{'\ue548', 0xA262}, {'\ue549', 0xA263}, {'\ue54a', 0xA264},
		{'\ue54b', 0xA265}, {'\ue54c', 0xA266}, {'\ue54d', 0xA267},
		{'\ue54e', 0xA268}, {'\ue54f', 0xA269}, {'\ue550', 0xA26A},
		{'\ue551', 0xA26B}, {'\ue552', 0xA26C}, {'\ue553', 0xA26D},
		{'\ue554', 0xA26E}, {'\ue555', 0xA26F}, {'\ue556', 0xA270},
		{'\ue557', 0xA271}, {'\ue558', 0xA272}, {'\ue559', 0xA273},
		{'\ue55a', 0xA274}, {'\ue55b', 0xA275}, {'\ue55c', 0xA276},
		{'\ue55d', 0xA277}, {'\ue55e', 0xA278}, {'\ue55f', 0xA279},
		{'\ue560', 0xA27A}, {'\ue561', 0xA27B}, {'\ue562', 0xA27C},
		{'\ue563', 0xA27D}, {'\ue564', 0xA27E}, {'\ue565', 0xA280},
		{'\ue566', 0xA281}, {'\ue567', 0xA282}, {'\ue568', 0xA283},
		{'\ue569', 0xA284}, {'\ue56a', 0xA285}, {'\ue56b', 0xA286},
		{'\ue56c', 0xA287}, {'\ue56d', 0xA288}, {'\ue56e', 0xA289},
		{'\ue56f', 0xA28A}, {'\ue570', 0xA28B}, {'\ue571', 0xA28C},
		{'\ue572', 0xA28D}, {'\ue573', 0xA28E}, {'\ue574', 0xA28F},
		{'\ue575', 0xA290}, {'\ue576', 0xA291}, {'\ue577', 0xA292},
		{'\ue578', 0xA293}, {'\ue579', 0xA294}, {'\ue57a', 0xA295},
		{'\ue57b', 0xA296}, {'\ue57c', 0xA297}, {'\ue57d', 0xA298},
		{'\ue57e', 0xA299}, {'\ue57f', 0xA29A}, {'\ue580', 0xA29B},
		{'\ue581', 0xA29C}, {'\ue582', 0xA29D}, {'\ue583', 0xA29E},
		{'\ue584', 0xA29F}, {'\ue585', 0xA2A0}, {'\ue586', 0xA340},
		{'\ue587', 0xA341}, {'\ue588', 0xA342}, {'\ue589', 0xA343},
		{'\ue58a', 0xA344}, {'\ue58b', 0xA345}, {'\ue58c', 0xA346},
		{'\ue58d', 0xA347}, {'\ue58e', 0xA348}, {'\ue58f', 0xA349},
		{'\ue590', 0xA34A}, {'\ue591', 0xA34B}, {'\ue592', 0xA34C},
		{'\ue593', 0xA34D}, {'\ue594', 0xA34E}, {'\ue595', 0xA34F},
		{'\ue596', 0xA350}, {'\ue597', 0xA351}, {'\ue598', 0xA352},
		{'\ue599', 0xA353}, {'\ue59a', 0xA354}, {'\ue59b', 0xA355},
		{'\ue59c', 0xA356}, {'\ue59d', 0xA357}, {'\ue59e', 0xA358},
		{'\ue59f', 0xA359}, {'\ue5a0', 0xA35A}, {'\ue5a1', 0xA35B},
		{'\ue5a2', 0xA35C}, {'\ue5a3', 0xA35D}, {'\ue5a4', 0xA35E},
		{'\ue5a5', 0xA35F}, {'\ue5a6', 0xA360}, {'\ue5a7', 0xA361},
		{'\ue5a8', 0xA362}, {'\ue5a9', 0xA363}, {'\ue5aa', 0xA364},
		{'\ue5ab', 0xA365}, {'\ue5ac', 0xA366}, {'\ue5ad', 0xA367},
		{'\ue5ae', 0xA368}, {'\ue5af', 0xA369}, {'\ue5b0', 0xA36A},
		{'\ue5b1', 0xA36B}, {'\ue5b2', 0xA36C}, {'\ue5b3', 0xA36D},
		{'\ue5b4', 0xA36E}, {'\ue5b5', 0xA36F}, {'\ue5b6', 0xA370},
		{'\ue5b7', 0xA371}, {'\ue5b8', 0xA372}, {'\ue5b9', 0xA373},
		{'\ue5ba', 0xA374}, {'\ue5bb', 0xA375}, {'\ue5bc', 0xA376},
		{'\ue5bd', 0xA377}, {'\ue5be', 0xA378}, {'\ue5bf', 0xA379},
		{'\ue5c0', 0xA37A}, {'\ue5c1', 0xA37B}, {'\ue5c2', 0xA37C},
		{'\ue5c3', 0xA37D}, {'\ue5c4', 0xA37E}, {'\ue5c5', 0xA380},
		{'\ue5c6', 0xA381}, {'\ue5c7', 0xA382}, {'\ue5c8', 0xA383},
		{'\ue5c9', 0xA384}, {'\ue5ca', 0xA385}, {'\ue5cb', 0xA386},
		{'\ue5cc', 0xA387}, {'\ue5cd', 0xA388}, {'\ue5ce', 0xA389},
		{'\ue5cf', 0xA38A}, {'\ue5d0', 0xA38B}, {'\ue5d1', 0xA38C},
		{'\ue5d2', 0xA38D}, {'\ue5d3', 0xA38E}, {'\ue5d4', 0xA38F},
		{'\ue5d5', 0xA390}, {'\ue5d6', 0xA391}, {'\ue5d7', 0xA392},
		{'\ue5d8', 0xA393}, {'\ue5d9', 0xA394}, {'\ue5da', 0xA395},
		{'\ue5db', 0xA396}, {'\ue5dc', 0xA397}, {'\ue5dd', 0xA398},
		{'\ue5de', 0xA399}, {'\ue5df', 0xA39A}, {'\ue5e0', 0xA39B},
		{'\ue5e1', 0xA39C}, {'\ue5e2', 0xA39D}, {'\ue5e3', 0xA39E},
		{'\ue5e4', 0xA39F}, {'\ue5e5', 0xA3A0}, {'\ue5e6', 0xA440},
		{'\ue5e7', 0xA441}, {'\ue5e8', 0xA442}, {'\ue5e9', 0xA443},
		{'\ue5ea', 0xA444}, {'\ue5eb', 0xA445}, {'\ue5ec', 0xA446},
		{'\ue5ed', 0xA447}, {'\ue5ee', 0xA448}, {'\ue5ef', 0xA449},
		{'\ue5f0', 0xA44A}, {'\ue5f1', 0xA44B}, {'\ue5f2', 0xA44C},
		{'\ue5f3', 0xA44D}, {'\ue5f4', 0xA44E}, {'\ue5f5', 0xA44F},
		{'\ue5f6', 0xA450}, {'\ue5f7', 0xA451}, {'\ue5f8', 0xA452},
		{'\ue5f9', 0xA453}, {'\ue5fa', 0xA454}, {'\ue5fb', 0xA455},
		{'\ue5fc', 0xA456}, {'\ue5fd', 0xA457}, {'\ue5fe', 0xA458},
		{'\ue5ff', 0xA459}, {'\ue600', 0xA45A}, {'\ue601', 0xA45B},
		{'\ue602', 0xA45C}, {'\ue603', 0xA45D}, {'\ue604', 0xA45E},
		{'\ue605', 0xA45F}, {'\ue606', 0xA460}, {'\ue607', 0xA461},
		{'\ue608', 0xA462}, {'\ue609', 0xA463}, {'\ue60a', 0xA464},
		{'\ue60b', 0xA465}, {'\ue60c', 0xA466}, {'\ue60d', 0xA467},
		{'\ue60e', 0xA468}, {'\ue60f', 0xA469}, {'\ue610', 0xA46A},
		{'\ue611', 0xA46B}, {'\ue612', 0xA46C}, {'\ue613', 0xA46D},
		{'\ue614', 0xA46E}, {'\ue615', 0xA46F}, {'\ue616', 0xA470},
		{'\ue617', 0xA471}, {'\ue618', 0xA472}, {'\ue619', 0xA473},
		{'\ue61a', 0xA474}, {'\ue61b', 0xA475}, {'\ue61c', 0xA476},
		{'\ue61d', 0xA477}, {'\ue61e', 0xA478}, {'\ue61f', 0xA479},
		{'\ue620', 0xA47A}, {'\ue621', 0xA47B}, {'\ue622', 0xA47C},
		{'\ue623', 0xA47D}, {'\ue624', 0xA47E}, {'\ue625', 0xA480},
		{'\ue626', 0xA481}, {'\ue627', 0xA482}, {'\ue628', 0xA483},
		{'\ue629', 0xA484}, {'\ue62a', 0xA485}, {'\ue62b', 0xA486},
		{'\ue62c', 0xA487}, {'\ue62d', 0xA488}, {'\ue62e', 0xA489},
		{'\ue62f', 0xA48A}, {'\ue630', 0xA48B}, {'\ue631', 0xA48C},
		{'\ue632', 0xA48D}, {'\ue633', 0xA48E}, {'\ue634', 0xA48F},
		{'\ue635', 0xA490}, {'\ue636', 0xA491}, {'\ue637', 0xA492},
		{'\ue638', 0xA493}, {'\ue639', 0xA494}, {'\ue63a', 0xA495},
		{'\ue63b', 0xA496}, {'\ue63c', 0xA497}, {'\ue63d', 0xA498},
		{'\ue63e', 0xA499}, {'\ue63f', 0xA49A}, {'\ue640', 0xA49B},
		{'\ue641', 0xA49C}, {'\ue642', 0xA49D}, {'\ue643', 0xA49E},
		{'\ue644', 0xA49F}, {'\ue645', 0xA4A0}, {'\ue646', 0xA540},
		{'\ue647', 0xA541}, {'\ue648', 0xA542}, {'\ue649', 0xA543},
		{'\ue64a', 0xA544}, {'\ue64b', 0xA545}, {'\ue64c', 0xA546},
		{'\ue64d', 0xA547}, {'\ue64e', 0xA548}, {'\ue64f', 0xA549},
		{'\ue650', 0xA54A}, {'\ue651', 0xA54B}, {'\ue652', 0xA54C},
		{'\ue653', 0xA54D}, {'\ue654', 0xA54E}, {'\ue655', 0xA54F},
		{'\ue656', 0xA550}, {'\ue657', 0xA551}, {'\ue658', 0xA552},
		{'\ue659', 0xA553}, {'\ue65a', 0xA554}, {'\ue65b', 0xA555},
		{'\ue65c', 0xA556}, {'\ue65d', 0xA557}, {'\ue65e', 0xA558},
		{'\ue65f', 0xA559}, {'\ue660', 0xA55A}, {'\ue661', 0xA55B},
		{'\ue662', 0xA55C}, {'\ue663', 0xA55D}, {'\ue664', 0xA55E},
		{'\ue665', 0xA55F}, {'\ue666', 0xA560}, {'\ue667', 0xA561},
		{'\ue668', 0xA562}, {'\ue669', 0xA563}, {'\ue66a', 0xA564},
		{'\ue66b', 0xA565}, {'\ue66c', 0xA566}, {'\ue66d', 0xA567},
		{'\ue66e', 0xA568}, {'\ue66f', 0xA569}, {'\ue670', 0xA56A},
		{'\ue671', 0xA56B}, {'\ue672', 0xA56C}, {'\ue673', 0xA56D},
		{'\ue674', 0xA56E}, {'\ue675', 0xA56F}, {'\ue676', 0xA570},
		{'\ue677', 0xA571}, {'\ue678', 0xA572}, {'\ue679', 0xA573},
		{'\ue67a', 0xA574}, {'\ue67b', 0xA575}, {'\ue67c', 0xA576},
		{'\ue67d', 0xA577}, {'\ue67e', 0xA578}, {'\ue67f', 0xA579},
		{'\ue680', 0xA57A}, {'\ue681', 0xA57B}, {'\ue682', 0xA57C},
		{'\ue683', 0xA57D}, {'\ue684', 0xA57E}, {'\ue685', 0xA580},
		{'\ue686', 0xA581}, {'\ue687', 0xA582}, {'\ue688', 0xA583},
		{'\ue689', 0xA584}, {'\ue68a', 0xA585}, {'\ue68b', 0xA586},
		{'\ue68c', 0xA587}, {'\ue68d', 0xA588}, {'\ue68e', 0xA589},
		{'\ue68f', 0xA58A}, {'\ue690', 0xA58B}, {'\ue691', 0xA58C},
		{'\ue692', 0xA58D}, {'\ue693', 0xA58E}, {'\ue694', 0xA58F},
		{'\ue695', 0xA590}, {'\ue696', 0xA591}, {'\ue697', 0xA592},
		{'\ue698', 0xA593}, {'\ue699', 0xA594}, {'\ue69a', 0xA595},
		{'\ue69b', 0xA596}, {'\ue69c', 0xA597}, {'\ue69d', 0xA598},
		{'\ue69e', 0xA599}, {'\ue69f', 0xA59A}, {'\ue6a0', 0xA59B},
		{'\ue6a1', 0xA59C}, {'\ue6a2', 0xA59D}, {'\ue6a3', 0xA59E},
		{'\ue6a4', 0xA59F}, {'\ue6a5', 0xA5A0}, {'\ue6a6', 0xA640},
		{'\ue6a7', 0xA641}, {'\ue6a8', 0xA642}, {'\ue6a9', 0xA643},
		{'\ue6aa', 0xA644}, {'\ue6ab', 0xA645}, {'\ue6ac', 0xA646},
		{'\ue6ad', 0xA647}, {'\ue6ae', 0xA648}, {'\ue6af', 0xA649},
		{'\ue6b0', 0xA64A}, {'\ue6b1', 0xA64B}, {'\ue6b2', 0xA64C},
		{'\ue6b3', 0xA64D}, {'\ue6b4', 0xA64E}, {'\ue6b5', 0xA64F},
		{'\ue6b6', 0xA650}, {'\ue6b7', 0xA651}, {'\ue6b8', 0xA652},
		{'\ue6b9', 0xA653}, {'\ue6ba', 0xA654}, {'\ue6bb', 0xA655},
		{'\ue6bc', 0xA656}, {'\ue6bd', 0xA657}, {'\ue6be', 0xA658},
		{'\ue6bf', 0xA659}, {'\ue6c0', 0xA65A}, {'\ue6c1', 0xA65B},
		{'\ue6c2', 0xA65C}, {'\ue6c3', 0xA65D}, {'\ue6c4', 0xA65E},
		{'\ue6c5', 0xA65F}, {'\ue6c6', 0xA660}, {'\ue6c7', 0xA661},
		{'\ue6c8', 0xA662}, {'\ue6c9', 0xA663}, {'\ue6ca', 0xA664},
		{'\ue6cb', 0xA665}, {'\ue6cc', 0xA666}, {'\ue6cd', 0xA667},
		{'\ue6ce', 0xA668}, {'\ue6cf', 0xA669}, {'\ue6d0', 0xA66A},
		{'\ue6d1', 0xA66B}, {'\ue6d2', 0xA66C}, {'\ue6d3', 0xA66D},
		{'\ue6d4', 0xA66E}, {'\ue6d5', 0xA66F}, {'\ue6d6', 0xA670},
		{'\ue6d7', 0xA671}, {'\ue6d8', 0xA672}, {'\ue6d9', 0xA673},
		{'\ue6da', 0xA674}, {'\ue6db', 0xA675}, {'\ue6dc', 0xA676},
		{'\ue6dd', 0xA677}, {'\ue6de', 0xA678}, {'\ue6df', 0xA679},
		{'\ue6e0', 0xA67A}, {'\ue6e1', 0xA67B}, {'\ue6e2', 0xA67C},
		{'\ue6e3', 0xA67D}, {'\ue6e4', 0xA67E}, {'\ue6e5', 0xA680},
		{'\ue6e6', 0xA681}, {'\ue6e7', 0xA682}, {'\ue6e8', 0xA683},
		{'\ue6e9', 0xA684}, {'\ue6ea', 0xA685}, {'\ue6eb', 0xA686},
		{'\ue6ec', 0xA687}, {'\ue6ed', 0xA688}, {'\ue6ee', 0xA689},
		{'\ue6ef', 0xA68A}, {'\ue6f0', 0xA68B}, {'\ue6f1', 0xA68C},
		{'\ue6f2', 0xA68D}, {'\ue6f3', 0xA68E}, {'\ue6f4', 0xA68F},
		{'\ue6f5', 0xA690}, {'\ue6f6', 0xA691}, {'\ue6f7', 0xA692},
		{'\ue6f8', 0xA693}, {'\ue6f9', 0xA694}, {'\ue6fa', 0xA695},
		{'\ue6fb', 0xA696}, {'\ue6fc', 0xA697}, {'\ue6fd', 0xA698},
		{'\ue6fe', 0xA699}, {'\ue6ff', 0xA69A}, {'\ue700', 0xA69B},
		{'\ue701', 0xA69C}, {'\ue702', 0xA69D}, {'\ue703', 0xA69E},
		{'\ue704', 0xA69F}, {'\ue705', 0xA6A0}, {'\ue706', 0xA740},
		{'\ue707', 0xA741}, {'\ue708', 0xA742}, {'\ue709', 0xA743},
		{'\ue70a', 0xA744}, {'\ue70b', 0xA745}, {'\ue70c', 0xA746},
		{'\ue70d', 0xA747}, {'\ue70e', 0xA748}, {'\ue70f', 0xA749},
		{'\ue710', 0xA74A}, {'\ue711', 0xA74B}, {'\ue712', 0xA74C},
		{'\ue713', 0xA74D}, {'\ue714', 0xA74E}, {'\ue715', 0xA74F},
		{'\ue716', 0xA750}, {'\ue717', 0xA751}, {'\ue718', 0xA752},
		{'\ue719', 0xA753}, {'\ue71a', 0xA754}, {'\ue71b', 0xA755},
		{'\ue71c', 0xA756}, {'\ue71d', 0xA757}, {'\ue71e', 0xA758},
		{'\ue71f', 0xA759}, {'\ue720', 0xA75A}, {'\ue721', 0xA75B},
		{'\ue722', 0xA75C}, {'\ue723', 0xA75D}, {'\ue724', 0xA75E},
		{'\ue725', 0xA75F}, {'\ue726', 0xA760}, {'\ue727', 0xA761},
		{'\ue728', 0xA762}, {'\ue729', 0xA763}, {'\ue72a', 0xA764},
		{'\ue72b', 0xA765}, {'\ue72c', 0xA766}, {'\ue72d', 0xA767},
		{'\ue72e', 0xA768}, {'\ue72f', 0xA769}, {'\ue730', 0xA76A},
		{'\ue731', 0xA76B}, {'\ue732', 0xA76C}, {'\ue733', 0xA76D},
		{'\ue734', 0xA76E}, {'\ue735', 0xA76F}, {'\ue736', 0xA770},
		{'\ue737', 0xA771}, {'\ue738', 0xA772}, {'\ue739', 0xA773},
		{'\ue73a', 0xA774}, {'\ue73b', 0xA775}, {'\ue73c', 0xA776},
		{'\ue73d', 0xA777}, {'\ue73e', 0xA778}, {'\ue73f', 0xA779},
		{'\ue740', 0xA77A}, {'\ue741', 0xA77B}, {'\ue742', 0xA77C},
		{'\ue743', 0xA77D}, {'\ue744', 0xA77E}, {'\ue745', 0xA780},
		{'\ue746', 0xA781}, {'\ue747', 0xA782}, {'\ue748', 0xA783},
		{'\ue749', 0xA784}, {'\ue74a', 0xA785}, {'\ue74b', 0xA786},
		{'\ue74c', 0xA787}, {'\ue74d', 0xA788}, {'\ue74e', 0xA789},
		{'\ue74f', 0xA78A}, {'\ue750', 0xA78B}, {'\ue751', 0xA78C},
		{'\ue752', 0xA78D}, {'\ue753', 0xA78E}, {'\ue754', 0xA78F},
		{'\ue755', 0xA790}, {'\ue756', 0xA791}, {'\ue757', 0xA792},
		{'\ue758', 0xA793}, {'\ue759', 0xA794}, {'\ue75a', 0xA795},
		{'\ue75b', 0xA796}, {'\ue75c', 0xA797}, {'\ue75d', 0xA798},
		{'\ue75e', 0xA799}, {'\ue75f', 0xA79A}, {'\ue760', 0xA79B},
		{'\ue761', 0xA79C}, {'\ue762', 0xA79D}, {'\ue763', 0xA79E},
		{'\ue764', 0xA79F}, {'\ue765', 0xA7A0}, {'\ue766', 0xA2AB},
		{'\ue767', 0xA2AC}, {'\ue768', 0xA2AD}, {'\ue769', 0xA2AE},
		{'\ue76a', 0xA2AF}, {'\ue76b', 0xA2B0}, {'\ue76d', 0xA2E4},
		{'\ue76e', 0xA2EF}, {'\ue76f', 0xA2F0}, {'\ue770', 0xA2FD},
		{'\ue771', 0xA2FE}, {'\ue772', 0xA4F4}, {'\ue773', 0xA4F5},
		{'\ue774', 0xA4F6}, {'\ue775', 0xA4F7}, {'\ue776', 0xA4F8},
		{'\ue777', 0xA4F9}, {'\ue778', 0xA4FA}, {'\ue779', 0xA4FB},
		{'\ue77a', 0xA4FC}, {'\ue77b', 0xA4FD}, {'\ue77c', 0xA4FE},
		{'\ue77d', 0xA5F7}, {'\ue77e', 0xA5F8}, {'\ue77f', 0xA5F9},
		{'\ue780', 0xA5FA}, {'\ue781', 0xA5FB}, {'\ue782', 0xA5FC},
		{'\ue783', 0xA5FD}, {'\ue784', 0xA5FE}, {'\ue785', 0xA6B9},
		{'\ue786', 0xA6BA}, {'\ue787', 0xA6BB}, {'\ue788', 0xA6BC},
		{'\ue789', 0xA6BD}, {'\ue78a', 0xA6BE}, {'\ue78b', 0xA6BF},
		{'\ue78c', 0xA6C0}, {'\ue78d', 0x84318236}, {'\ue78e', 0x84318238},
		{'\ue78f', 0x84318237}, {'\ue790', 0x84318239}, {'\ue791', 0x84318330},
		{'\ue792', 0x84318331}, {'\ue793', 0x84318332}, {'\ue794', 0x84318333},
		{'\ue795', 0x84318334}, {'\ue796', 0x84318335}, {'\ue797', 0xA6F6},
		{'\ue798', 0xA6F7}, {'\ue799', 0xA6F8}, {'\ue79a', 0xA6F9},
		{'\ue79b', 0xA6FA}, {'\ue79c', 0xA6FB}, {'\ue79d', 0xA6FC},
		{'\ue79e', 0xA6FD}, {'\ue79f', 0xA6FE}, {'\ue7a0', 0xA7C2},
		{'\ue7a1', 0xA7C3}, {'\ue7a2', 0xA7C4}, {'\ue7a3', 0xA7C5},
		{'\ue7a4', 0xA7C6}, {'\ue7a5', 0xA7C7}, {'\ue7a6', 0xA7C8},
		{'\ue7a7', 0xA7C9}, {'\ue7a8', 0xA7CA}, {'\ue7a9', 0xA7CB},
		{'\ue7aa', 0xA7CC}, {'\ue7ab', 0xA7CD}, {'\ue7ac', 0xA7CE},
		{'\ue7ad', 0xA7CF}, {'\ue7ae', 0xA7D0}, {'\ue7af', 0xA7F2},
		{'\ue7b0', 0xA7F3}, {'\ue7b1', 0xA7F4}, {'\ue7b2', 0xA7F5},
		{'\ue7b3', 0xA7F6}, {'\ue7b4', 0xA7F7}, {'\ue7b5', 0xA7F8},
		{'\ue7b6', 0xA7F9}, {'\ue7b7', 0xA7FA}, {'\ue7b8', 0xA7FB},
		{'\ue7b9', 0xA7FC}, {'\ue7ba', 0xA7FD}, {'\ue7bb', 0xA7FE},
		{'\ue7bc', 0xA896}, {'\ue7bd', 0xA897}, {'\ue7be', 0xA898},
		{'\ue7bf', 0xA899}, {'\ue7c0', 0xA89A}, {'\ue7c1', 0xA89B},
		{'\ue7c2', 0xA89C}, {'\ue7c3', 0xA89D}, {'\ue7c4', 0xA89E},
		{'\ue7c5', 0xA89F}, {'\ue7c6', 0xA8A0}, {'\ue7c7', 0x8135F437},
		{'\ue7c9', 0xA8C1}, {'\ue7ca', 0xA8C2}, {'\ue7cb', 0xA8C3},
		{'\ue7cc', 0xA8C4}, {'\ue7cd', 0xA8EA}, {'\ue7ce', 0xA8EB},
		{'\ue7cf', 0xA8EC}, {'\ue7d0', 0xA8ED}, {'\ue7d1', 0xA8EE},
		{'\ue7d2', 0xA8EF}, {'\ue7d3', 0xA8F0}, {'\ue7d4', 0xA8F1},
		{'\ue7d5', 0xA8F2}, {'\ue7d6', 0xA8F3}, {'\ue7d7', 0xA8F4},
		{'\ue7d8', 0xA8F5}, {'\ue7d9', 0xA8F6}, {'\ue7da', 0xA8F7},
		{'\ue7db', 0xA8F8}, {'\ue7dc', 0xA8F9}, {'\ue7dd', 0xA8FA},
		{'\ue7de', 0xA8FB}, {'\ue7df', 0xA8FC}, {'\ue7e0', 0xA8FD},
		{'\ue7e1', 0xA8FE}, {'\ue7e2', 0xA958}, {'\ue7e3', 0xA95B},
		{'\ue7e4', 0xA95D}, {'\ue7e5', 0xA95E}, {'\ue7e6', 0xA95F},
		{'\ue7f4', 0xA997}, {'\ue7f5', 0xA998}, {'\ue7f6', 0xA999},
		{'\ue7f7', 0xA99A}, {'\ue7f8', 0xA99B}, {'\ue7f9', 0xA99C},
		{'\ue7fa', 0xA99D}, {'\ue7fb', 0xA99E}, {'\ue7fc', 0xA99F},
		{'\ue7fd', 0xA9A0}, {'\ue7fe', 0xA9A1}, {'\ue7ff', 0xA9A2},
		{'\ue800', 0xA9A3}, {'\ue801', 0xA9F0}, {'\ue802', 0xA9F1},
		{'\ue803', 0xA9F2}, {'\ue804', 0xA9F3}, {'\ue805', 0xA9F4},
		{'\ue806', 0xA9F5}, {'\ue807', 0xA9F6}, {'\ue808', 0xA9F7},
		{'\ue809', 0xA9F8}, {'\ue80a', 0xA9F9}, {'\ue80b', 0xA9FA},
		{'\ue80c', 0xA9FB}, {'\ue80d', 0xA9FC}, {'\ue80e', 0xA9FD},
		{'\ue80f', 0xA9FE}, {'\ue810', 0xD7FA}, {'\ue811', 0xD7FB},
		{'\ue812', 0xD7FC}, {'\ue813', 0xD7FD}, {'\ue814', 0xD7FE},
		{'\ue816', 0xFE51}, {'\ue817', 0xFE52}, {'\ue818', 0xFE53},
		{'\ue81e', 0x82359037}, {'\ue826', 0x82359038}, {'\ue82b', 0x82359039},
		{'\ue82c', 0x82359130}, {'\ue831', 0xFE6C}, {'\ue832', 0x82359131},
		{'\ue83b', 0xFE76}, {'\ue843', 0x82359132}, {'\ue854', 0x82359133},
		{'\ue855', 0xFE91}, {'\ue864', 0x82359134}, {'\ufe10', 0xA6D9},
		{'\ufe11', 0xA6DB}, {'\ufe12', 0xA6DA}, {'\ufe13', 0xA6DC},
		{'\ufe14', 0xA6DD}, {'\ufe15', 0xA6DE}, {'\ufe16', 0xA6DF},
		{'\ufe17', 0xA6EC}, {'\ufe18', 0xA6ED}, {'\ufe19', 0xA6F3},
		{'\U00020087', 0x95329031}, {'\U00020089', 0x95329033}, {'\U000200cc', 0x95329730},
		{'\U000215d7', 0x9536B937}, {'\U0002298f', 0x9630BA35}, {'\U000241fe', 0x9635B630},
	}
	for _, v := range gb18030EncodingList {
		unicodeToGB18030[v.unicode] = v.gb18030
		gb18030ToUnicode[v.gb18030] = v.unicode
	}
}

var (
	unicodeToGB18030 = map[rune]uint32{}
	gb18030ToUnicode = map[uint32]rune{}
	// GB18030Case follows the cases from MySQL
	GB18030Case = unicode.SpecialCase{
		unicode.CaseRange{Lo: 0xB5, Hi: 0xB5, Delta: [unicode.MaxCase]rune{0, 775, 0}},
		unicode.CaseRange{Lo: 0x1C5, Hi: 0x1C5, Delta: [unicode.MaxCase]rune{0, 1, 0}},
		unicode.CaseRange{Lo: 0x1C8, Hi: 0x1C8, Delta: [unicode.MaxCase]rune{0, 1, 0}},
		unicode.CaseRange{Lo: 0x1CB, Hi: 0x1CB, Delta: [unicode.MaxCase]rune{0, 1, 0}},
		unicode.CaseRange{Lo: 0x1F2, Hi: 0x1F2, Delta: [unicode.MaxCase]rune{0, 1, 0}},
		unicode.CaseRange{Lo: 0x25C, Hi: 0x25C, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x261, Hi: 0x261, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x265, Hi: 0x266, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x26A, Hi: 0x26A, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x26C, Hi: 0x26C, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x282, Hi: 0x282, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x287, Hi: 0x287, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x29D, Hi: 0x29E, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x37F, Hi: 0x37F, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x3C2, Hi: 0x3C2, Delta: [unicode.MaxCase]rune{0, 1, 0}},
		unicode.CaseRange{Lo: 0x3D0, Hi: 0x3D0, Delta: [unicode.MaxCase]rune{0, -30, 0}},
		unicode.CaseRange{Lo: 0x3D1, Hi: 0x3D1, Delta: [unicode.MaxCase]rune{0, -25, 0}},
		unicode.CaseRange{Lo: 0x3D5, Hi: 0x3D5, Delta: [unicode.MaxCase]rune{0, -15, 0}},
		unicode.CaseRange{Lo: 0x3D6, Hi: 0x3D6, Delta: [unicode.MaxCase]rune{0, -22, 0}},
		unicode.CaseRange{Lo: 0x3F0, Hi: 0x3F0, Delta: [unicode.MaxCase]rune{0, -54, 0}},
		unicode.CaseRange{Lo: 0x3F1, Hi: 0x3F1, Delta: [unicode.MaxCase]rune{0, -48, 0}},
		unicode.CaseRange{Lo: 0x3F3, Hi: 0x3F3, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x3F5, Hi: 0x3F5, Delta: [unicode.MaxCase]rune{0, -64, 0}},
		unicode.CaseRange{Lo: 0x526, Hi: 0x52F, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10C7, Hi: 0x10C7, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10CD, Hi: 0x10CD, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10D0, Hi: 0x10FA, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10FD, Hi: 0x10FF, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x13A0, Hi: 0x13F5, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x13F8, Hi: 0x13FD, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1C80, Hi: 0x1C88, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1C90, Hi: 0x1CBA, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1CBD, Hi: 0x1CBF, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1D79, Hi: 0x1D79, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1D7D, Hi: 0x1D7D, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1D8E, Hi: 0x1D8E, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1E9B, Hi: 0x1E9B, Delta: [unicode.MaxCase]rune{0, -58, 0}},
		unicode.CaseRange{Lo: 0x1FBE, Hi: 0x1FBE, Delta: [unicode.MaxCase]rune{0, -7173, 0}},
		unicode.CaseRange{Lo: 0x2CF2, Hi: 0x2CF3, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x2D27, Hi: 0x2D27, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x2D2D, Hi: 0x2D2D, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA660, Hi: 0xA661, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA698, Hi: 0xA69B, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA78D, Hi: 0xA78D, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA790, Hi: 0xA794, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA796, Hi: 0xA7AE, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA7B0, Hi: 0xA7BF, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA7C2, Hi: 0xA7CA, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xA7F5, Hi: 0xA7F6, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xAB53, Hi: 0xAB53, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0xAB70, Hi: 0xABBF, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x104B0, Hi: 0x104D3, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x104D8, Hi: 0x104FB, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10C80, Hi: 0x10CB2, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x10CC0, Hi: 0x10CF2, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x118A0, Hi: 0x118DF, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x16E40, Hi: 0x16E7F, Delta: [unicode.MaxCase]rune{0, 0, 0}},
		unicode.CaseRange{Lo: 0x1E900, Hi: 0x1E943, Delta: [unicode.MaxCase]rune{0, 0, 0}},
	}
)
