/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.http;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.http.AbstractCommandHandler;
import org.tinymediamanager.core.tasks.ExportTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowExporter;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowARDetectorTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowFetchRatingsTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowMissingArtworkDownloadTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowReloadMediaInformationTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowTrailerDownloadTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

class TvShowCommandTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowCommandTask.class);
    private final List<AbstractCommandHandler.Command> commands;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final TvShowSettings tvShowSettings = TvShowModuleManager.getInstance().getSettings();
    private final List<TvShow> newTvShows = new ArrayList<TvShow>();
    private final List<TvShowEpisode> newEpisodes = new ArrayList<TvShowEpisode>();
    private TmmTask activeTask;

    public TvShowCommandTask(List<AbstractCommandHandler.Command> commands) {
        super("TV show - HTTP commands");
        this.commands = commands;
    }

    @Override
    protected void doInBackground() {
        this.updateDataSources();
        this.reloadMediaInfo();
        this.aspectRatioDetection();
        this.scrape();
        this.fetchRatings();
        this.downloadTrailer();
        this.downloadSubtitles();
        this.downloadMissingArtwork();
        this.rename();
        this.export();
    }

    private void updateDataSources() {
        TreeSet<String> dataSources = new TreeSet<String>();
        HashSet<TvShow> tvShowFolders = new HashSet<TvShow>();
        ArrayList<TvShow> existingTvShows = new ArrayList<TvShow>(this.tvShowList.getTvShows());
        ArrayList<TvShowEpisode> existingEpisodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow : existingTvShows) {
            existingEpisodes.addAll(tvShow.getEpisodes());
        }
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"update".equals(command.action)) continue;
            dataSources.addAll(this.getDataSourcesForScope(command.scope));
            tvShowFolders.addAll(this.getTvShowFoldersForScope(command.scope));
        }
        if (!dataSources.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("update.datasource"));
            this.publishState(TmmResourceBundle.getString("update.datasource"), this.getProgressDone());
            this.activeTask = new TvShowUpdateDatasourceTask(dataSources);
            this.activeTask.run();
            this.activeTask = null;
        }
        if (!tvShowFolders.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("update.datasource"));
            this.publishState(TmmResourceBundle.getString("update.datasource"), this.getProgressDone());
            this.activeTask = new TvShowUpdateDatasourceTask((List<TvShow>)new ArrayList<TvShow>(tvShowFolders));
            this.activeTask.run();
            this.activeTask = null;
        }
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            if (!existingTvShows.contains(tvShow)) {
                this.newTvShows.add(tvShow);
                continue;
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (existingEpisodes.contains(episode)) continue;
                this.newEpisodes.add(episode);
            }
        }
    }

    private List<String> getDataSourcesForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<String> dataSources = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)scope.name)) {
            scope.name = "all";
        }
        switch (scope.name) {
            case "all": {
                dataSources.addAll(this.tvShowSettings.getTvShowDataSource());
                break;
            }
            case "single": {
                for (String index : ListUtils.nullSafe(Arrays.asList(scope.args))) {
                    try {
                        int i = Integer.parseInt(index);
                        if (this.tvShowSettings.getTvShowDataSource().size() < i - 1) continue;
                        dataSources.add(this.tvShowSettings.getTvShowDataSource().get(i - 1));
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not parse index from command - {}", (Object)e.getMessage());
                    }
                }
                break;
            }
        }
        return dataSources;
    }

    public void reloadMediaInfo() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"reloadMediaInfo".equals(command.action)) continue;
            LOGGER.debug("HTTP API: reload media info - '{}'", (Object)command);
            List<TvShow> tvshows = this.getTvShowsForScope(command.scope);
            List<TvShowEpisode> tvShowEpisodes = this.getEpisodesForScope(command.scope);
            if (tvshows.isEmpty() || tvShowEpisodes.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("tvshow.updatemediainfo"));
            this.publishState(TmmResourceBundle.getString("tvshow.updatemediainfo"), this.getProgressDone());
            this.activeTask = new TvShowReloadMediaInformationTask(tvshows, tvShowEpisodes);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    public void aspectRatioDetection() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"detectAspectRatio".equals(command.action)) continue;
            LOGGER.debug("HTTP API: detecting aspect ratio - '{}'", (Object)command);
            List<TvShowEpisode> tvShowEpisodes = this.getEpisodesForScope(command.scope);
            if (tvShowEpisodes.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("tvshow.ard"));
            this.publishState(TmmResourceBundle.getString("tvshow.ard"), this.getProgressDone());
            this.activeTask = new TvShowARDetectorTask(tvShowEpisodes);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private List<TvShow> getTvShowFoldersForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>();
        switch (scope.name) {
            case "show": {
                block6: for (String path : ListUtils.nullSafe(Arrays.asList(scope.args))) {
                    for (TvShow tvShow : this.tvShowList.getTvShows()) {
                        if (!tvShow.getPathNIO().toAbsolutePath().toString().equals(path)) continue;
                        tvShows.add(tvShow);
                        continue block6;
                    }
                }
                break;
            }
        }
        return tvShows;
    }

    private void scrape() {
        LinkedHashSet<TvShow> tvShowsToScrape = new LinkedHashSet<TvShow>();
        LinkedHashSet<TvShowEpisode> episodesToScrape = new LinkedHashSet<TvShowEpisode>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"scrape".equals(command.action)) continue;
            tvShowsToScrape.addAll(this.getTvShowsForScope(command.scope));
            episodesToScrape.addAll(this.getEpisodesForScope(command.scope));
        }
        HashSet<TvShowEpisode> removedEpisode = new HashSet<TvShowEpisode>();
        for (TvShowEpisode ep : episodesToScrape) {
            if (!tvShowsToScrape.contains(ep.getTvShow())) continue;
            removedEpisode.add(ep);
        }
        episodesToScrape.removeAll(removedEpisode);
        if (!tvShowsToScrape.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("tvshow.scraping"));
            this.publishState(TmmResourceBundle.getString("tvshow.scraping"), this.getProgressDone());
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = new TvShowSearchAndScrapeOptions();
            Iterator<Object> tvShowScraperMetadataConfig = this.tvShowSettings.getTvShowScraperMetadataConfig();
            List<TvShowEpisodeScraperMetadataConfig> list = this.tvShowSettings.getEpisodeScraperMetadataConfig();
            tvShowSearchAndScrapeOptions.loadDefaults();
            TvShowScrapeTask.TvShowScrapeParams tvShowScrapeParams = new TvShowScrapeTask.TvShowScrapeParams((List<TvShow>)new ArrayList<TvShow>(tvShowsToScrape), tvShowSearchAndScrapeOptions, (List<TvShowScraperMetadataConfig>)((Object)tvShowScraperMetadataConfig), list);
            tvShowScrapeParams.setOverwriteExistingItems(!this.tvShowSettings.isDoNotOverwriteExistingData());
            this.activeTask = new TvShowScrapeTask(tvShowScrapeParams);
            this.activeTask.run();
            while (TmmTaskManager.getInstance().isImageDownloadsRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.activeTask = null;
        }
        if (!episodesToScrape.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("tvshow.scraping"));
            this.publishState(TmmResourceBundle.getString("tvshow.scraping"), this.getProgressDone());
            HashMap<TvShow, List> hashMap = new HashMap<TvShow, List>();
            for (TvShowEpisode tvShowEpisode : episodesToScrape) {
                List episodes = hashMap.computeIfAbsent(tvShowEpisode.getTvShow(), k -> new ArrayList());
                episodes.add(tvShowEpisode);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                TvShow tvShow = (TvShow)entry.getKey();
                TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions();
                options.loadDefaults();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tvShow.getLastScraperId(), tvShow.getLastScrapeLanguage()})) {
                    options.setMetadataScraper(MediaScraper.getMediaScraperById(tvShow.getLastScraperId(), ScraperType.TV_SHOW));
                    options.setLanguage(MediaLanguages.valueOf(tvShow.getLastScrapeLanguage()));
                }
                List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig();
                this.activeTask = new TvShowEpisodeScrapeTask((List)entry.getValue(), options, episodeScraperMetadataConfig, !TvShowModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
                this.activeTask.run();
                while (TmmTaskManager.getInstance().isPoolRunning()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.activeTask = null;
            }
        }
        if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
            HashSet<TvShow> hashSet = new HashSet<TvShow>(tvShowsToScrape);
            for (TvShowEpisode tvShowEpisode : episodesToScrape) {
                hashSet.add(tvShowEpisode.getTvShow());
            }
            TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(new ArrayList<TvShow>(hashSet));
            task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
            task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
            task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    private void fetchRatings() {
        LinkedHashSet<TvShow> tvShowsToScrape = new LinkedHashSet<TvShow>();
        LinkedHashSet<TvShowEpisode> episodesToScrape = new LinkedHashSet<TvShowEpisode>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"fetchRatings".equals(command.action)) continue;
            tvShowsToScrape.addAll(this.getTvShowsForScope(command.scope));
            episodesToScrape.addAll(this.getEpisodesForScope(command.scope));
        }
        if (!tvShowsToScrape.isEmpty() || !episodesToScrape.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("tvshow.fetchratings"));
            this.publishState(TmmResourceBundle.getString("tvshow.fetchratings"), this.getProgressDone());
            this.activeTask = new TvShowFetchRatingsTask(tvShowsToScrape, episodesToScrape, RatingProvider.RatingSource.getRatingSourcesForTvShows());
            this.activeTask.run();
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.activeTask = null;
        }
    }

    private void downloadTrailer() {
        LinkedHashSet<TvShow> tvShowsToProcess = new LinkedHashSet<TvShow>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadTrailer".equals(command.action)) continue;
            LOGGER.debug("HTTP API: downloading trailers - '{}'", (Object)command);
            boolean onlyMissingTrailer = true;
            if (StringUtils.isNotBlank((CharSequence)command.args.get("onlyMissing"))) {
                onlyMissingTrailer = Boolean.parseBoolean(command.args.get("onlyMissing"));
            }
            for (TvShow tvShow : this.getTvShowsForScope(command.scope)) {
                if (onlyMissingTrailer) {
                    if (!tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty()) continue;
                    tvShowsToProcess.add(tvShow);
                    continue;
                }
                tvShowsToProcess.add(tvShow);
            }
        }
        if (!tvShowsToProcess.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("trailer.download"));
            this.publishState(TmmResourceBundle.getString("trailer.download"), this.getProgressDone());
            for (TvShow tvShow : tvShowsToProcess) {
                this.activeTask = new TvShowTrailerDownloadTask(tvShow);
                this.activeTask.run();
                this.activeTask = null;
            }
        }
    }

    private void downloadSubtitles() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadSubtitle".equals(command.action)) continue;
            String language = command.args.get("language");
            MediaLanguages mediaLanguages = null;
            if (StringUtils.isNotBlank((CharSequence)language)) {
                mediaLanguages = MediaLanguages.get(language);
            }
            if (mediaLanguages == null) {
                mediaLanguages = this.tvShowSettings.getScraperLanguage();
            }
            ArrayList<TvShowEpisode> episodesToProcess = new ArrayList<TvShowEpisode>();
            LOGGER.debug("HTTP API: downloading missing subtitles - '{}'", (Object)command);
            boolean onlyMissingSubs = true;
            if (StringUtils.isNotBlank((CharSequence)command.args.get("onlyMissing"))) {
                onlyMissingSubs = Boolean.parseBoolean(command.args.get("onlyMissing"));
            }
            for (TvShowEpisode episode : this.getEpisodesForScope(command.scope)) {
                if (onlyMissingSubs) {
                    boolean subtitleFound = false;
                    for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
                        for (MediaFileSubtitle subtitle : mf.getSubtitles()) {
                            MediaLanguages subtitleLanguage;
                            if (!StringUtils.isNotBlank((CharSequence)subtitle.getLanguage()) || (subtitleLanguage = MediaLanguages.get(subtitle.getLanguage())) != mediaLanguages) continue;
                            subtitleFound = true;
                            break;
                        }
                        if (!subtitleFound) continue;
                        break;
                    }
                    if (subtitleFound) continue;
                    episodesToProcess.add(episode);
                    continue;
                }
                episodesToProcess.add(episode);
            }
            if (episodesToProcess.isEmpty()) continue;
            this.setTaskName(TmmResourceBundle.getString("tvshow.download.subtitles"));
            this.publishState(TmmResourceBundle.getString("tvshow.download.subtitles"), this.getProgressDone());
            this.activeTask = new TvShowSubtitleSearchAndDownloadTask(episodesToProcess, mediaLanguages);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void downloadMissingArtwork() {
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"downloadMissingArtwork".equals(command.action)) continue;
            this.setTaskName(TmmResourceBundle.getString("tvshow.downloadmissingartwork"));
            this.publishState(TmmResourceBundle.getString("tvshow.downloadmissingartwork"), this.getProgressDone());
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeConfig = new TvShowSearchAndScrapeOptions();
            tvShowSearchAndScrapeConfig.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
            tvShowSearchAndScrapeConfig.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
            ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper artworkScraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableArtworkScrapers()) {
                if (!TvShowModuleManager.getInstance().getSettings().getArtworkScrapers().contains(artworkScraper.getId())) continue;
                selectedArtworkScrapers.add(artworkScraper);
            }
            tvShowSearchAndScrapeConfig.setArtworkScraper(selectedArtworkScrapers);
            this.activeTask = new TvShowMissingArtworkDownloadTask(this.getTvShowsForScope(command.scope), Collections.emptyList(), this.getEpisodesForScope(command.scope), tvShowSearchAndScrapeConfig, TvShowModuleManager.getInstance().getSettings().getTvShowScraperMetadataConfig(), TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig());
            this.activeTask.run();
            this.activeTask = null;
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void rename() {
        LinkedHashSet<TvShow> tvShowsToRename = new LinkedHashSet<TvShow>();
        LinkedHashSet<TvShowEpisode> episodesToRename = new LinkedHashSet<TvShowEpisode>();
        for (AbstractCommandHandler.Command command : this.commands) {
            if (!"rename".equals(command.action)) continue;
            tvShowsToRename.addAll(this.getTvShowsForScope(command.scope));
            episodesToRename.addAll(this.getEpisodesForScope(command.scope));
        }
        if (!tvShowsToRename.isEmpty()) {
            this.setTaskName(TmmResourceBundle.getString("tvshow.rename"));
            this.publishState(TmmResourceBundle.getString("tvshow.rename"), this.getProgressDone());
            this.activeTask = new TvShowRenameTask(tvShowsToRename, episodesToRename);
            this.activeTask.run();
            this.activeTask = null;
        }
    }

    private void export() {
        for (AbstractCommandHandler.Command command : this.commands) {
            String exportPath;
            List<TvShow> toExport;
            if (!"export".equals(command.action) || (toExport = this.getTvShowsForScope(command.scope)).isEmpty()) continue;
            String templateName = command.args.get("template");
            ExportTemplate template = MediaEntityExporter.findTemplates(MediaEntityExporter.TemplateType.TV_SHOW).stream().filter(t -> t.getPath().endsWith(templateName)).findFirst().orElse(null);
            if (template == null || StringUtils.isBlank((CharSequence)(exportPath = command.args.get("exportPath")))) continue;
            try {
                LOGGER.debug("HTTP API: exporting TV shows - '{}'", (Object)command);
                this.setTaskName(TmmResourceBundle.getString("tvshow.export"));
                this.publishState(TmmResourceBundle.getString("tvshow.export"), this.getProgressDone());
                this.activeTask = new ExportTask(TmmResourceBundle.getString("tvshow.export"), new TvShowExporter(Paths.get(template.getPath(), new String[0])), toExport, Paths.get(exportPath, new String[0]));
                this.activeTask.run();
            }
            catch (Exception e) {
                LOGGER.debug("Could not export TV shows - '{}'", (Object)e.getMessage());
            }
            this.activeTask = null;
        }
    }

    private List<TvShow> getTvShowsForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<TvShow> tvShowsToProcess = new ArrayList<TvShow>();
        if (StringUtils.isBlank((CharSequence)scope.name)) {
            scope.name = "new";
        }
        switch (scope.name) {
            case "path": {
                if (scope.args == null || scope.args.length <= 0) break;
                ArrayList<Path> paths = new ArrayList<Path>();
                for (String path : scope.args) {
                    paths.add(Path.of(path, new String[0]).toAbsolutePath());
                }
                tvShowsToProcess.addAll(this.tvShowList.getTvShows().stream().filter(movie -> paths.contains(movie.getPathNIO().toAbsolutePath())).collect(Collectors.toList()));
                break;
            }
            case "dataSource": {
                if (scope.args == null || scope.args.length <= 0) break;
                List<String> dataSources = Arrays.asList(scope.args);
                tvShowsToProcess.addAll(this.tvShowList.getTvShows().stream().filter(movie -> dataSources.contains(movie.getDataSource())).collect(Collectors.toList()));
                break;
            }
            case "all": {
                tvShowsToProcess.addAll(this.tvShowList.getTvShows());
                break;
            }
            case "unscraped": {
                tvShowsToProcess.addAll(this.tvShowList.getUnscrapedTvShows());
                break;
            }
            default: {
                tvShowsToProcess.addAll(this.newTvShows);
            }
        }
        return tvShowsToProcess;
    }

    private List<TvShowEpisode> getEpisodesForScope(AbstractCommandHandler.CommandScope scope) {
        ArrayList<TvShowEpisode> episodesToProcess = new ArrayList<TvShowEpisode>();
        if (StringUtils.isBlank((CharSequence)scope.name)) {
            scope.name = "new";
        }
        switch (scope.name) {
            case "path": {
                if (scope.args == null || scope.args.length <= 0) break;
                ArrayList<Path> paths = new ArrayList<Path>();
                for (String path : scope.args) {
                    paths.add(Path.of(path, new String[0]).toAbsolutePath());
                }
                for (TvShow tvShow2 : this.tvShowList.getTvShows().stream().filter(tvShow -> paths.contains(tvShow.getPathNIO().toAbsolutePath())).toList()) {
                    episodesToProcess.addAll(tvShow2.getEpisodes());
                }
                break;
            }
            case "dataSource": {
                if (scope.args == null || scope.args.length <= 0) break;
                List<String> dataSources = Arrays.asList(scope.args);
                for (TvShow tvShow3 : this.tvShowList.getTvShows().stream().filter(tvShow -> dataSources.contains(tvShow.getDataSource())).toList()) {
                    episodesToProcess.addAll(tvShow3.getEpisodes());
                }
                break;
            }
            case "unscraped": {
                episodesToProcess.addAll(this.tvShowList.getUnscrapedEpisodes());
                break;
            }
            case "all": {
                for (TvShow tvShow4 : this.tvShowList.getTvShows()) {
                    episodesToProcess.addAll(tvShow4.getEpisodes());
                }
                break;
            }
            default: {
                episodesToProcess.addAll(this.newEpisodes);
            }
        }
        return episodesToProcess;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.activeTask != null) {
            this.activeTask.cancel();
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }
}

