/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.label.ImageLabel;

public class LightBox {
    private final JPanel backgroundPanel;
    private final JPanel imagePanel;
    private final ImageLabel image;
    private final JFrame frame;

    private LightBox(JFrame parent, String url, String path) {
        this.frame = parent;
        this.backgroundPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g1) {
                super.paintComponent(g1);
                Graphics2D g = (Graphics2D)g1;
                g.setPaint(Color.black);
                Composite savedComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setComposite(savedComposite);
            }
        };
        this.backgroundPanel.setOpaque(false);
        this.backgroundPanel.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.imagePanel = new JPanel();
        this.imagePanel.setLayout((LayoutManager)new MigLayout("", "[75lp,grow]", "[75lp,grow]"));
        this.imagePanel.setSize(new Dimension((int)((double)this.frame.getContentPane().getWidth() * 0.95), (int)((double)this.frame.getContentPane().getHeight() * 0.95)));
        this.imagePanel.setOpaque(false);
        this.image = new ImageLabel(true);
        this.image.setScaleUpIfTooSmall(false);
        this.image.setPreferCache(false);
        this.image.setIsLightbox(true);
        this.image.setPosition(ImageLabel.Position.CENTER);
        this.image.setCacheUrl(true);
        SwingUtilities.invokeLater(() -> {
            if (StringUtils.isNotBlank((CharSequence)path)) {
                this.image.setImagePath(path);
            } else if (StringUtils.isNotBlank((CharSequence)url)) {
                this.image.setImageUrl(url);
            }
        });
        this.imagePanel.add((Component)this.image, "cell 0 0,grow");
        MouseAdapter clickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LightBox.this.frame.getLayeredPane().remove(LightBox.this.imagePanel);
                LightBox.this.frame.getLayeredPane().remove(LightBox.this.backgroundPanel);
                LightBox.this.frame.validate();
                LightBox.this.frame.repaint();
            }
        };
        this.backgroundPanel.addMouseListener(clickListener);
        this.imagePanel.addMouseListener(clickListener);
        this.image.addMouseListener(clickListener);
    }

    private void show() {
        this.frame.getLayeredPane().add((Component)this.backgroundPanel, JLayeredPane.PALETTE_LAYER);
        this.imagePanel.setLocation((this.frame.getLayeredPane().getWidth() - this.imagePanel.getWidth()) / 2, (this.frame.getLayeredPane().getHeight() - this.imagePanel.getHeight()) / 2);
        this.frame.getLayeredPane().add((Component)this.imagePanel, JLayeredPane.MODAL_LAYER);
    }

    public static void showLightBox(JFrame frame, String path, String url) {
        LightBox lightBox = new LightBox(frame, url, path);
        lightBox.show();
    }
}

