/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Path;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.textfield.TmmRoundTextArea;

public class ExternalToolsSettingsPanel
extends JPanel {
    private final Settings settings = Settings.getInstance();
    private final ButtonGroup buttonGroupFfmpeg = new ButtonGroup();
    private final ButtonGroup buttonGroupYtDlp = new ButtonGroup();
    private JTextField tfMediaPlayerPath;
    private JButton btnSearchMediaPlayer;
    private JRadioButton rdbtnFFmpegInternal;
    private JRadioButton rdbtnFFmpegExternal;
    private JTextField tfFFmpegPath;
    private JButton btnSearchFFMpegBinary;
    private JRadioButton rdbtnYtDlpInternal;
    private JRadioButton rdbtnYtDlpExternal;
    private JTextField tfYtDlpPath;
    private JButton btnSearchYtDlpBinary;
    private JTextArea taYtDlpParams;

    ExternalToolsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnSearchMediaPlayer.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseplayer.path");
            Path file = TmmUIHelper.selectApplication(TmmResourceBundle.getString("Button.chooseplayer"), path);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfMediaPlayerPath.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseplayer.path", file.getParent().toString());
            }
        });
        this.btnSearchFFMpegBinary.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseffmpeg.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("Button.chooseffmpeglocation"), path, null);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfFFmpegPath.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseffmpeg.path", file.getParent().toString());
            }
        });
        this.btnSearchYtDlpBinary.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseytdlp.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("Button.chooseytdlplocation"), path, null);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfYtDlpPath.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseytdlp.path", file.getParent().toString());
            }
        });
        if (this.settings.isUseInternalMediaFramework()) {
            this.rdbtnFFmpegInternal.setSelected(true);
        } else {
            this.rdbtnFFmpegExternal.setSelected(true);
        }
        if (this.settings.isUseInternalYtDlp()) {
            this.rdbtnYtDlpInternal.setSelected(true);
        } else {
            this.rdbtnYtDlpExternal.setSelected(true);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelMediaPlayer = new JPanel();
        panelMediaPlayer.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("Settings.mediaplayer"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaPlayer, lblLanguageT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#media-player"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.tfMediaPlayerPath = new JTextField();
        panelMediaPlayer.add((Component)this.tfMediaPlayerPath, "cell 1 0 2 1");
        this.tfMediaPlayerPath.setColumns(35);
        this.btnSearchMediaPlayer = new JButton(TmmResourceBundle.getString("Button.chooseplayer"));
        panelMediaPlayer.add((Component)this.btnSearchMediaPlayer, "cell 1 0");
        ReadOnlyTextArea tpMediaPlayer = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaplayer.hint"));
        panelMediaPlayer.add((Component)tpMediaPlayer, "cell 1 1 2 1,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpMediaPlayer, 0.83333);
        JPanel panelFFmpeg = new JPanel();
        panelFFmpeg.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][400lp,grow][]", "[][][][]"));
        TmmLabel lblFFmpegT = new TmmLabel("FFmpeg", 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelFFmpeg, lblFFmpegT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#ffmpeg"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.rdbtnFFmpegInternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.internal"));
        this.buttonGroupFfmpeg.add(this.rdbtnFFmpegInternal);
        panelFFmpeg.add((Component)this.rdbtnFFmpegInternal, "cell 1 0 2 1");
        this.rdbtnFFmpegExternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.external"));
        this.buttonGroupFfmpeg.add(this.rdbtnFFmpegExternal);
        panelFFmpeg.add((Component)this.rdbtnFFmpegExternal, "cell 1 1 2 1");
        this.tfFFmpegPath = new JTextField();
        panelFFmpeg.add((Component)this.tfFFmpegPath, "cell 2 2");
        this.tfFFmpegPath.setColumns(35);
        this.btnSearchFFMpegBinary = new JButton(TmmResourceBundle.getString("Button.chooseffmpeglocation"));
        panelFFmpeg.add((Component)this.btnSearchFFMpegBinary, "cell 2 2");
        ReadOnlyTextArea tpFFMpegLocation = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaframework.hint"));
        panelFFmpeg.add((Component)tpFFMpegLocation, "cell 2 3,growx");
        TmmFontHelper.changeFont((JComponent)tpFFMpegLocation, 0.83333);
        JPanel panelYtDlp = new JPanel();
        panelYtDlp.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][400lp,grow][]", "[][][][]15lp![][][]15lp![][]"));
        TmmLabel lblYtDlpT = new TmmLabel("yt-dlp", 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelYtDlp, lblYtDlpT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#yt-dlp"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx, wmin 0");
        this.rdbtnYtDlpInternal = new JRadioButton(TmmResourceBundle.getString("Settings.ytdlp.internal"));
        this.buttonGroupYtDlp.add(this.rdbtnYtDlpInternal);
        panelYtDlp.add((Component)this.rdbtnYtDlpInternal, "cell 1 0 2 1");
        this.rdbtnYtDlpExternal = new JRadioButton(TmmResourceBundle.getString("Settings.ytdlp.external"));
        this.buttonGroupYtDlp.add(this.rdbtnYtDlpExternal);
        panelYtDlp.add((Component)this.rdbtnYtDlpExternal, "cell 1 1 2 1");
        this.tfYtDlpPath = new JTextField();
        panelYtDlp.add((Component)this.tfYtDlpPath, "cell 2 2");
        this.tfYtDlpPath.setColumns(35);
        this.btnSearchYtDlpBinary = new JButton(TmmResourceBundle.getString("Button.chooseytdlplocation"));
        panelYtDlp.add((Component)this.btnSearchYtDlpBinary, "cell 2 2");
        ReadOnlyTextArea tpYtDlpLocation = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.ytdlp.hint"));
        panelYtDlp.add((Component)tpYtDlpLocation, "cell 2 3,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpYtDlpLocation, 0.83333);
        JLabel lblYtDlpParams = new JLabel(TmmResourceBundle.getString("Settings.ytdlp.params"));
        panelYtDlp.add((Component)lblYtDlpParams, "cell 1 4 2 1");
        this.taYtDlpParams = new TmmRoundTextArea();
        panelYtDlp.add((Component)this.taYtDlpParams, "cell 1 4 2 1,growx, wmin 0");
        ReadOnlyTextArea taYtDlpParamHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.ytdlp.params.hint"));
        panelYtDlp.add((Component)taYtDlpParamHint, "cell 1 5 2 1, growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)taYtDlpParamHint, 0.83333);
        ReadOnlyTextArea taYtDlpDefaultParams = new ReadOnlyTextArea("-f \"bv*+ba/best\" -S res: 1080 --merge-output-format mkv --concurrent-fragments 4 --abort-on-unavailable-fragment --fragment-retries 99");
        panelYtDlp.add((Component)taYtDlpDefaultParams, "cell 1 6 2 1, growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)taYtDlpDefaultParams, 0.83333);
        ReadOnlyTextArea taYtCookieHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.ytdlp.cookies.hint"));
        panelYtDlp.add((Component)taYtCookieHint, "cell 1 7 2 1, growx, wmin 0");
        JButton btnOpenFaq = new JButton("yt-dlp FAQ");
        btnOpenFaq.addActionListener(e -> {
            String url = "https://github.com/yt-dlp/yt-dlp/wiki/FAQ#how-do-i-pass-cookies-to-yt-dlp";
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelYtDlp.add((Component)btnOpenFaq, "cell 1 8 2 1");
    }

    private void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"mediaPlayer");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfMediaPlayerPath, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"mediaFramework");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.tfFFmpegPath, (Property)jTextFieldBeanProperty_4);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"useInternalMediaFramework");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.rdbtnFFmpegInternal, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"externalYtDlpPath");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.tfYtDlpPath, (Property)jTextFieldBeanProperty_5);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"useInternalYtDlp");
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.rdbtnYtDlpInternal, (Property)jCheckBoxBeanProperty_1);
        autoBinding_12.bind();
        BeanProperty settingsBeanProperty_13 = BeanProperty.create((String)"ytDlpParams");
        BeanProperty jTextFieldBeanProperty_6 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_13, (Object)this.taYtDlpParams, (Property)jTextFieldBeanProperty_6);
        autoBinding_13.bind();
    }
}

