/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ManagedImage;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class ManagedFullImage
extends ManagedImage
implements ImageObserver {
    private String name;
    private URL url = null;
    private int numReferences = 0;
    private int numPrepares = 0;
    Image image = null;
    private boolean loaded = false;
    private int width = 0;
    private int height = 0;
    private boolean flushing = false;

    ManagedFullImage(String string) {
        this.name = string;
    }

    ManagedFullImage(String string, URL uRL) {
        this.name = string;
        this.url = uRL;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    synchronized void addReference() {
        ++this.numReferences;
    }

    @Override
    synchronized void removeReference() {
        --this.numReferences;
    }

    @Override
    synchronized boolean isReferenced() {
        return this.numReferences > 0;
    }

    @Override
    public synchronized void prepare() {
        ++this.numPrepares;
    }

    @Override
    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public synchronized boolean hadErrorLoading() {
        return this.loaded && this.height == 0 && this.width == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(Component component) {
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            while (!this.loaded && this.numPrepares > 0) {
                if (this.image == null) {
                    this.startLoading(component);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            return;
        }
    }

    @Override
    public synchronized void startLoading(Component component) {
        while (this.flushing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.image != null || this.numPrepares <= 0) {
            return;
        }
        this.image = this.url == null ? AssetFinder.loadImage(this.name) : Toolkit.getDefaultToolkit().createImage(this.url);
        this.notifyAll();
        Thread.currentThread();
        Thread.yield();
        component.prepareImage(this.image, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            if (image != this.image) {
                return false;
            }
            if ((n & 0xC0) != 0) {
                Debug.println("Error loading image " + this);
                this.loaded = true;
                this.width = 0;
                this.height = 0;
                this.notifyAll();
            } else if ((n & 0x20) != 0) {
                this.loaded = true;
                this.width = n4;
                this.height = n5;
                this.notifyAll();
            } else {
                return true;
            }
        }
        AssetFinder.notifyLoaded(this);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unprepare() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Image image = null;
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            --this.numPrepares;
            if (this.numPrepares > 0) {
                return;
            }
            if (this.image != null) {
                n = this.width;
                n2 = this.height;
                this.width = 0;
                this.height = 0;
                image = this.image;
                this.flushing = true;
                this.image = null;
            }
            bl = this.loaded;
            this.loaded = false;
            this.notifyAll();
        }
        if (image != null) {
            image.flush();
            managedFullImage = this;
            synchronized (managedFullImage) {
                this.flushing = false;
                this.notifyAll();
            }
        }
        if (bl) {
            AssetFinder.notifyUnloaded(this, n, n2);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, Component component) {
        if (this.width > 0) {
            graphics2D.drawImage(this.image, n, n2, component);
        }
    }

    @Override
    public void drawScaled(Graphics2D graphics2D, Rectangle rectangle, Component component) {
        if (this.width > 0) {
            graphics2D.drawImage(this.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, this.width, this.height, component);
        }
    }

    @Override
    public void drawClipped(Graphics2D graphics2D, int n, int n2, Rectangle rectangle, Component component) {
        if (this.width > 0) {
            graphics2D.drawImage(this.image, n, n2, n + rectangle.width, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, component);
        }
    }

    @Override
    void destroy() {
        Image image;
        if (this.loaded) {
            Debug.println("Warning:  Destroying loaded image " + this + ".");
            Debug.println("          unprepare() should always be called before ungetImage().");
        }
        if ((image = this.image) != null) {
            image.flush();
        }
    }
}

