/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class TmmUILayoutStore {
    private static TmmUILayoutStore instance;
    private final TmmProperties properties = TmmProperties.getInstance();
    private final Set<String> componentSet = new HashSet<String>();
    private boolean skipSaving = false;

    private TmmUILayoutStore() {
    }

    public static synchronized TmmUILayoutStore getInstance() {
        if (instance == null) {
            instance = new TmmUILayoutStore();
        }
        return instance;
    }

    public void install(JComponent component) {
        if (StringUtils.isBlank((CharSequence)component.getName())) {
            return;
        }
        if (component instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)component;
            this.installJSplitPane(splitPane);
        } else if (component instanceof TmmTable) {
            TmmTable tmmTable = (TmmTable)component;
            this.installTmmTable(tmmTable);
        }
    }

    private void installJSplitPane(JSplitPane splitPane) {
        String componentName = splitPane.getName();
        this.componentSet.add(componentName);
        int dividerLocation = this.properties.getPropertyAsInteger(componentName + ".dividerLocation");
        if (dividerLocation > 0) {
            splitPane.setDividerLocation(dividerLocation);
        }
    }

    private void installTmmTable(TmmTable table) {
        String componentName = table.getName();
        this.componentSet.add(componentName);
        String hiddenColumnsAsString = this.properties.getProperty(componentName + ".hiddenColumns");
        if (StringUtils.isNotBlank((CharSequence)hiddenColumnsAsString)) {
            List<String> hiddenColumns = Arrays.asList(hiddenColumnsAsString.split(","));
            table.readHiddenColumns(hiddenColumns);
            if (table instanceof TmmTreeTable) {
                TmmTreeTable treeTable = (TmmTreeTable)table;
                if (treeTable.getSortStrategy() != null && StringUtils.isNotBlank((CharSequence)this.properties.getProperty(componentName + ".sortState"))) {
                    treeTable.setSortStrategy(this.properties.getProperty(componentName + ".sortState"));
                }
            } else if (table.getTableComparatorChooser() != null && StringUtils.isNotBlank((CharSequence)this.properties.getProperty(componentName + ".sortState"))) {
                table.getTableComparatorChooser().fromString(this.properties.getProperty(componentName + ".sortState"));
            }
        } else if (hiddenColumnsAsString == null) {
            table.setDefaultHiddenColumns();
        }
    }

    public void loadSettings(JFrame frame) {
        if ("mainWindow".equals(frame.getName())) {
            Rectangle rect = this.getWindowBounds("mainWindow");
            if (rect.width > 0) {
                GraphicsDevice graphicsDevice = this.getScreenForBounds(rect);
                if (graphicsDevice.getDefaultConfiguration() != frame.getGraphicsConfiguration()) {
                    JFrame dummy = new JFrame(graphicsDevice.getDefaultConfiguration());
                    frame.setLocationRelativeTo(dummy);
                    dummy.dispose();
                }
                if (SystemUtils.IS_OS_LINUX && this.properties.getPropertyAsBoolean("mainWindowMaximized")) {
                    --rect.width;
                    --rect.height;
                }
                frame.setBounds(rect);
                if (this.properties.getPropertyAsBoolean("mainWindowMaximized")) {
                    frame.setExtendedState(frame.getExtendedState() | 6);
                    frame.validate();
                }
            } else {
                frame.setLocationRelativeTo(null);
            }
        }
    }

    private boolean isRectFullyVisible(Rectangle rect) {
        long rectArea = this.square(rect);
        long coveredArea = 0L;
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle screenBounds = device.getDefaultConfiguration().getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
            screenBounds.width = screenBounds.width - screenInsets.left - screenInsets.right;
            screenBounds.height = screenBounds.height - screenInsets.top - screenInsets.bottom;
            if ((coveredArea += this.square(screenBounds.intersection(rect))) < rectArea) continue;
            return true;
        }
        return false;
    }

    private long square(Rectangle rect) {
        return Math.abs(rect.width * rect.height);
    }

    public void loadSettings(JDialog dialog) {
        if (!StringUtils.isBlank((CharSequence)dialog.getName()) && !dialog.getName().contains("dialog")) {
            Rectangle rect = this.getWindowBounds(dialog.getName());
            if (rect.width == 0 && rect.height == 0) {
                dialog.pack();
                dialog.setLocationRelativeTo(dialog.getParent());
                return;
            }
            Dimension minimumSize = dialog.getMinimumSize();
            if (rect.width < minimumSize.width) {
                rect.width = minimumSize.width;
            }
            if (rect.height < minimumSize.height) {
                rect.height = minimumSize.height;
            }
            if (rect.width > 0 && this.getVirtualBounds().contains(rect)) {
                GraphicsDevice ge = this.getScreenForBounds(rect);
                if (ge.getDefaultConfiguration() != dialog.getGraphicsConfiguration()) {
                    JFrame dummy = new JFrame(ge.getDefaultConfiguration());
                    dialog.setLocationRelativeTo(dummy);
                    dummy.dispose();
                }
                dialog.setBounds(rect);
            } else {
                dialog.pack();
                dialog.setLocationRelativeTo(dialog.getParent());
            }
        } else {
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
        }
    }

    private GraphicsDevice getScreenForBounds(Rectangle rectangle) {
        GraphicsDevice[] gs;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(rectangle)) continue;
            return device;
        }
        return ge.getDefaultScreenDevice();
    }

    public void saveSettings(JFrame frame) {
        if (!Settings.getInstance().isStoreWindowPreferences() || this.skipSaving) {
            return;
        }
        if ("mainWindow".equals(frame.getName()) && frame instanceof MainWindow) {
            this.storeWindowBounds("mainWindow", frame.getBounds());
            if ((frame.getExtendedState() & 6) == 6) {
                this.addParam("mainWindowMaximized", true);
            } else {
                this.addParam("mainWindowMaximized", false);
            }
        }
        this.saveChildren(frame);
    }

    private void saveChildren(Container container) {
        Component[] comps;
        for (Component comp : comps = container.getComponents()) {
            if (this.componentSet.contains(comp.getName()) && comp instanceof JComponent && this.componentSet.contains(comp.getName())) {
                this.saveComponent(comp);
            }
            if (!(comp instanceof Container)) continue;
            Container container1 = (Container)comp;
            this.saveChildren(container1);
        }
    }

    private void saveComponent(Component component) {
        if (component instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)component;
            this.saveJSplitPane(splitPane);
        } else if (component instanceof TmmTreeTable) {
            TmmTreeTable treeTable = (TmmTreeTable)component;
            this.saveTmmTreeTable(treeTable);
        } else if (component instanceof TmmTable) {
            TmmTable tmmTable = (TmmTable)component;
            this.saveTmmTable(tmmTable);
        }
    }

    private void saveJSplitPane(JSplitPane splitPane) {
        String componentName = splitPane.getName();
        if (splitPane.getLastDividerLocation() != -1) {
            this.addParam(componentName + ".dividerLocation", splitPane.getDividerLocation());
        }
    }

    private void saveTmmTable(TmmTable table) {
        String componentName = table.getName();
        this.addParam(componentName + ".hiddenColumns", String.join((CharSequence)",", table.getHiddenColumns()));
        if (table.getTableComparatorChooser() != null) {
            this.addParam(componentName + ".sortState", table.getTableComparatorChooser().toString());
        }
    }

    private void saveTmmTreeTable(TmmTreeTable table) {
        String componentName = table.getName();
        this.addParam(componentName + ".hiddenColumns", String.join((CharSequence)",", table.getHiddenColumns()));
        if (table.getSortStrategy() != null) {
            this.addParam(componentName + ".sortState", table.getSortStrategy().toString());
        }
    }

    public void hideNewColumn(String tableIdentifier, String columnName) {
        if (StringUtils.isBlank((CharSequence)tableIdentifier)) {
            return;
        }
        String hiddenColumnsAsString = this.properties.getProperty(tableIdentifier + ".hiddenColumns");
        if (StringUtils.isNotBlank((CharSequence)hiddenColumnsAsString)) {
            ArrayList<String> hiddenColumns = new ArrayList<String>(Arrays.asList(hiddenColumnsAsString.split(",")));
            if (!hiddenColumns.contains(columnName)) {
                hiddenColumns.add(columnName);
            }
            this.addParam(tableIdentifier + ".hiddenColumns", String.join((CharSequence)",", hiddenColumns));
            this.properties.writeProperties();
        }
    }

    public void setSkipSaving(boolean skipSaving) {
        this.skipSaving = skipSaving;
    }

    public void saveSettings(JDialog dialog) {
        if (!Settings.getInstance().isStoreWindowPreferences() || StringUtils.isBlank((CharSequence)dialog.getName()) || this.skipSaving) {
            return;
        }
        if (!dialog.getName().contains("dialog")) {
            this.storeWindowBounds(dialog.getName(), dialog.getBounds());
        }
        this.saveChildren(dialog);
    }

    private void storeWindowBounds(String name, Rectangle bounds) {
        this.addParam(name + ".bounds", bounds.x + "," + bounds.y + "," + bounds.width + "," + bounds.height);
    }

    private Rectangle getWindowBounds(String name) {
        Rectangle rect = new Rectangle();
        String boundsAsString = this.properties.getProperty(name + ".bounds");
        if (StringUtils.isBlank((CharSequence)boundsAsString)) {
            return rect;
        }
        try {
            String[] parts = boundsAsString.split(",");
            rect.x = Integer.parseInt(parts[0]);
            rect.y = Integer.parseInt(parts[1]);
            rect.width = Integer.parseInt(parts[2]);
            rect.height = Integer.parseInt(parts[3]);
        }
        catch (Exception e) {
            return rect;
        }
        boolean isFullyVisible = this.isRectFullyVisible(rect);
        if (!isFullyVisible) {
            GraphicsDevice[] gs;
            GraphicsConfiguration graphicsConfiguration = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : gs = ge.getScreenDevices()) {
                GraphicsConfiguration gc = device.getDefaultConfiguration();
                Rectangle bounds = gc.getBounds();
                if (!bounds.contains(rect)) continue;
                graphicsConfiguration = gc;
                break;
            }
            if (graphicsConfiguration == null) {
                graphicsConfiguration = ge.getDefaultScreenDevice().getDefaultConfiguration();
            }
            Rectangle screenBounds = graphicsConfiguration.getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            if (rect.width > screenBounds.width - screenInsets.left - screenInsets.right) {
                rect.width = screenBounds.width - screenInsets.left - screenInsets.right;
            }
            if (rect.x < screenBounds.x + screenInsets.left) {
                rect.x = screenBounds.x + screenInsets.left;
            }
            if (rect.height > screenBounds.height - screenInsets.top - screenInsets.bottom) {
                rect.height = screenBounds.height - screenInsets.top - screenInsets.bottom;
            }
            if (rect.y < screenBounds.y + screenInsets.top) {
                rect.y = screenBounds.y + screenInsets.top;
            }
        }
        return rect;
    }

    private void addParam(String key, Object value) {
        this.properties.putProperty(key, value.toString());
    }

    private Rectangle getVirtualBounds() {
        GraphicsDevice[] lstGDs;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : lstGDs = ge.getScreenDevices()) {
            bounds.add(gd.getDefaultConfiguration().getBounds());
        }
        return bounds;
    }
}

