/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.IntegerTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;
import org.tinymediamanager.ui.renderer.RuntimeTableCellRenderer;

public class TvShowTableFormat
extends TmmTreeTableFormat<TmmTreeNode> {
    private final TvShowList tvShowList;
    private final TvShowSettings settings;
    private final Calendar calendar = Calendar.getInstance();

    public TvShowTableFormat() {
        Date date2;
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.settings = TvShowModuleManager.getInstance().getSettings();
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.CertificationComparator certificationComparator = new TmmTableFormat.CertificationComparator();
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        Comparator<Integer> integerComparator = Comparator.comparingInt(o -> o);
        Comparator floatComparator = (o1, o2) -> {
            float value1 = 0.0f;
            float value2 = 0.0f;
            try {
                value1 = Float.parseFloat(o1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value2 = Float.parseFloat(o2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Float.compare(value1, value2);
        };
        TmmTableFormat.DateComparator dateComparator = new TmmTableFormat.DateComparator();
        TmmTableFormat.DateTimeComparator dateTimeComparator = new TmmTableFormat.DateTimeComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.VideoFormatComparator videoFormatComparator = new TmmTableFormat.VideoFormatComparator();
        TmmTableFormat.FileSizeComparator fileSizeComparator = new TmmTableFormat.FileSizeComparator();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.originaltitle"), "originalTitle", this::getOriginialTitle, String.class);
        col.setDefaultHidden(true);
        col.setColumnComparator(stringComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.sorttitle"), "sortTitle", this::getSortTitle, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setCellTooltip(this::getSortTitle);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.year"), "year", this::getYear, Integer.class);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("2000") + this.getCellPadding());
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.season.count"), "seasons", this::getSeasons, Integer.class);
        col.setHeaderIcon(IconManager.SEASONS);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99") + this.getCellPadding());
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode.count"), "episodes", this::getEpisodes, Integer.class);
        col.setHeaderIcon(IconManager.EPISODES);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("999") + this.getCellPadding());
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.missingepisode.count"), "missingEpisodes", this::getMissingEpisodes, Integer.class);
        col.setHeaderIcon(IconManager.MISSING);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("999") + this.getCellPadding());
        col.setColumnComparator(integerComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.status"), "status", this::getStatus, String.class);
        col.setMinWidth(fontMetrics.stringWidth("Continuing") + this.getCellPadding());
        col.setColumnComparator(stringComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.path"), "path", this::getFolderPath, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", this::getFileName, String.class);
        col.setColumnResizeable(true);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99.9") + this.getCellPadding());
        col.setColumnComparator(floatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.votes"), "votes", this::getVotes, Integer.class);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1000000") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.userrating"), "userrating", this::getUserRating, Float.class);
        col.setHeaderIcon(IconManager.USER_RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99.9") + this.getCellPadding());
        col.setColumnComparator(floatComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "IMDb", "imdb", this::getImdbRating, Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.rating") + " - IMDb");
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("IMDb") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aired"), "aired", this::getAiredDate, Date.class);
        col.setHeaderIcon(IconManager.DATE_AIRED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        try {
            date2 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date2)) + this.getCellPadding());
        }
        catch (Exception date2) {
            // empty catch block
        }
        col.setColumnComparator(dateComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "T250", "top250", this::getTop250, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.top250"));
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("250") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.certification"), "certification", this::getCertification, MediaCertification.class);
        col.setColumnComparator(certificationComparator);
        col.setHeaderIcon(IconManager.CERTIFICATION);
        col.setColumnResizeable(true);
        col.setMinWidth(fontMetrics.stringWidth("not rated") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dateadded") + " (" + TmmResourceBundle.getString("metatag.tvshow") + ")", "dateAdded", this::getDateAdded, Date.class);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date2 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date2)) + this.getCellPadding());
        }
        catch (Exception date3) {
            // empty catch block
        }
        col.setColumnComparator(dateTimeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dateadded") + " (" + TmmResourceBundle.getString("metatag.episode") + ")", "dateAddedEpisode", this::getDateAddedEpisode, Date.class);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date2 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date2)) + this.getCellPadding());
        }
        catch (Exception date4) {
            // empty catch block
        }
        col.setColumnComparator(dateTimeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filecreationdate"), "fileCreationDate", this::getFileCreationDate, Date.class);
        col.setHeaderIcon(IconManager.DATE_CREATED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date2 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date2)) + this.getCellPadding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        col.setColumnComparator(dateTimeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [min]", "runtime", this::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("9999") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [hh:mm]", "runtime2", this::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.HOURS_MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99:00") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", this::getFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1080p") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(videoFormatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.hdr"), "hdr", this::isHDR, ImageIcon.class);
        col.setHeaderIcon(IconManager.HDR);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.hdrformat"), "hdrFormat", this::getVideoHDRFormat, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.HDR);
        col.setMinWidth(fontMetrics.stringWidth("HDR10") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videocodec"), "videoCodec", this::getVideoCodec, String.class);
        col.setHeaderIcon(IconManager.VIDEO_CODEC);
        col.setMinWidth(fontMetrics.stringWidth("MPEG-2") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(stringComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videobitrate"), "videoBitrate", this::getVideoBitrate, Integer.class);
        col.setHeaderIcon(IconManager.VIDEO_BITRATE);
        col.setMinWidth(fontMetrics.stringWidth("20000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audio"), "audio", this::getAudio, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth(fontMetrics.stringWidth("DTS 7ch") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audiostreamcount"), "audiostreamcount", this::getAudioStreamCount, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth(fontMetrics.stringWidth("9") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setCellTooltip(this::audioStreamTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videofilesize"), "fileSize", this::getVideoFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("500.00 M") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(fileSizeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.totalfilesize"), "totalFileSize", this::getTotalFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("500.00 M") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(fileSizeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aspectratio"), "aspectratio", this::getAspectRatio, Float.class);
        col.setHeaderIcon(IconManager.ASPECT_RATIO);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1.78") + this.getCellPadding());
        col.setDefaultHidden(true);
        col.setColumnComparator(floatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "mediaSource", this::getMediaSource, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.SOURCE);
        col.setMinWidth(fontMetrics.stringWidth("Blu-ray") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("movieextendedsearch.newepisodes"), "new", this::getNewIcon, ImageIcon.class);
        col.setHeaderIcon(IconManager.NEW);
        col.setColumnResizeable(false);
        col.setCellTooltip(this::newTooltip);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.metadata"), "metadata", this::hasMetadata, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setCellTooltip(this::hasMetadataTooltip);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.images"), "images", this::hasArtwork, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setCellTooltip(this::hasImageTooltip);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.trailer"), "trailer", this::hasTrailer, ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.TRAILER);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.subtitles"), "subtitles", this::hasSubtitles, ImageIcon.class);
        col.setHeaderIcon(IconManager.SUBTITLES);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.musictheme"), "theme", this::hasDownloadedMusicTheme, ImageIcon.class);
        col.setHeaderIcon(IconManager.MUSIC_HEADER);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.note"), "note", this::hasNote, ImageIcon.class);
        col.setHeaderIcon(IconManager.INFO);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
    }

    @Override
    public String getColumnName(int i) {
        if (i == -1) {
            return TmmResourceBundle.getString("metatag.title");
        }
        return super.getColumnName(i);
    }

    private Integer getYear(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getYear();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            Date firstAired = season.getFirstAired();
            if (firstAired != null) {
                this.calendar.setTime(firstAired);
                return this.calendar.get(1);
            }
            return null;
        }
        return null;
    }

    private Integer getSeasons(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getSeasonCount();
        }
        return null;
    }

    private Integer getEpisodes(TmmTreeNode node) {
        TvShowSeason season;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getEpisodeCount();
        }
        if (userObject instanceof TvShowSeason && !(season = (TvShowSeason)userObject).getEpisodes().isEmpty()) {
            return season.getEpisodes().size();
        }
        return null;
    }

    private Integer getMissingEpisodes(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getDummyEpisodeCount();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return season.getDummyEpisodeCount();
        }
        return null;
    }

    private String getStatus(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getStatus().getLocalizedName();
        }
        return null;
    }

    private String getFileName(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMainVideoFile().getFilename();
        }
        return null;
    }

    private String getFolderPath(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getPathNIO().toAbsolutePath().toString();
        }
        if (userObject instanceof TvShowEpisode && (episode = (TvShowEpisode)userObject).getPathNIO() != null) {
            return episode.getPathNIO().toAbsolutePath().toString();
        }
        return null;
    }

    private ImageIcon getNewIcon(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            if (tvShow.isNewlyAdded()) {
                return IconManager.NEW_GREEN;
            }
            if (tvShow.hasNewlyAddedEpisodes()) {
                return IconManager.NEW_ORANGE;
            }
        } else {
            if (userObject instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)userObject;
                return this.getNewIcon(season.isNewlyAdded());
            }
            if (userObject instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)userObject;
                return this.getNewIcon(episode.isNewlyAdded());
            }
        }
        return null;
    }

    private String newTooltip(TmmTreeNode node) {
        TvShowEpisode episode;
        TvShowSeason season;
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            if (tvShow.isNewlyAdded()) {
                return TmmResourceBundle.getString("tvshow.new");
            }
            if (tvShow.hasNewlyAddedEpisodes()) {
                return TmmResourceBundle.getString("tvshowepisode.new");
            }
        } else if (userObject instanceof TvShowSeason ? (season = (TvShowSeason)userObject).isNewlyAdded() : userObject instanceof TvShowEpisode && (episode = (TvShowEpisode)userObject).isNewlyAdded()) {
            return TmmResourceBundle.getString("tvshowepisode.new");
        }
        return null;
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating != MediaMetadata.EMPTY_RATING && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private Integer getVotes(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating != MediaMetadata.EMPTY_RATING && mediaRating.getRating() > 0.0f) {
            return mediaRating.getVotes();
        }
        return null;
    }

    private String getUserRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getUserRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getImdbRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating("imdb")) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private Date getAiredDate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getFirstAired();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return season.getFirstAired();
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getFirstAired();
        }
        return null;
    }

    private Date getDateAdded(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getDateAddedForUi();
        }
        if (userObject instanceof TvShowEpisode && !(episode = (TvShowEpisode)userObject).isDummy()) {
            return episode.getDateAddedForUi();
        }
        return null;
    }

    private Date getDateAddedEpisode(TmmTreeNode node) {
        TvShowEpisode episode;
        TvShow tvShow;
        ArrayList<TvShowEpisode> modifyableList;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow && !(modifyableList = new ArrayList<TvShowEpisode>((tvShow = (TvShow)userObject).getEpisodes())).isEmpty()) {
            TvShowEpisode latest = Collections.max(modifyableList, Comparator.comparing(MediaEntity::getDateAddedForUi));
            return latest.getDateAddedForUi();
        }
        if (userObject instanceof TvShowEpisode && !(episode = (TvShowEpisode)userObject).isDummy()) {
            return episode.getDateAddedForUi();
        }
        return null;
    }

    private Date getFileCreationDate(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode && !(episode = (TvShowEpisode)userObject).isDummy()) {
            return episode.getMainVideoFile().getDateCreated();
        }
        return null;
    }

    private String getFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMediaInfoVideoFormat();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueVideoFormat(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueVideoFormat(tvShow.getEpisodes());
        }
        return "";
    }

    private String detectUniqueVideoFormat(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String videoFormat = episodes.get(0).getMediaInfoVideoFormat();
        for (TvShowEpisode episode : episodes) {
            if (videoFormat.equals(episode.getMediaInfoVideoFormat())) continue;
            return null;
        }
        return videoFormat;
    }

    private String getVideoCodec(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMediaInfoVideoCodec();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueVideoCodec(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueVideoCodec(tvShow.getEpisodes());
        }
        return "";
    }

    private String detectUniqueVideoCodec(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String videoCodec = episodes.get(0).getMediaInfoVideoCodec();
        for (TvShowEpisode episode : episodes) {
            if (videoCodec.equals(episode.getMediaInfoVideoCodec())) continue;
            return null;
        }
        return videoCodec;
    }

    private Integer getVideoBitrate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMediaInfoVideoBitrate();
        }
        return null;
    }

    private String getAudio(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMediaInfoAudioCodec() + " " + episode.getMediaInfoAudioChannels();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueAudio(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueAudio(tvShow.getEpisodes());
        }
        return null;
    }

    private String detectUniqueAudio(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String audio = episodes.get(0).getMediaInfoAudioCodec() + " " + episodes.get(0).getMediaInfoAudioChannels();
        for (TvShowEpisode episode : episodes) {
            String otherAudio = episode.getMediaInfoAudioCodec() + " " + episode.getMediaInfoAudioChannels();
            if (audio.equals(otherAudio)) continue;
            return null;
        }
        return audio;
    }

    private Integer getAudioStreamCount(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getAudioStreamCount(episode);
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueAudioStreamCount(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueAudioStreamCount(tvShow.getEpisodes());
        }
        return null;
    }

    private int getAudioStreamCount(TvShowEpisode episode) {
        int count = episode.getMainVideoFile().getAudioStreams().size();
        for (MediaFile audioFile : episode.getMediaFiles(MediaFileType.AUDIO)) {
            count += audioFile.getAudioStreams().size();
        }
        return count;
    }

    private Integer detectUniqueAudioStreamCount(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        int streamCount = this.getAudioStreamCount(episodes.get(0));
        for (TvShowEpisode episode : episodes) {
            int otherAudioStreamCount = this.getAudioStreamCount(episode);
            if (streamCount == otherAudioStreamCount) continue;
            return null;
        }
        return streamCount;
    }

    private String audioStreamTooltip(TmmTreeNode node) {
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.createAudioStreamCountText(episode);
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueAudioStreamCountText(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueAudioStreamCountText(tvShow.getEpisodes());
        }
        return null;
    }

    private String detectUniqueAudioStreamCountText(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String tooltipText = this.createAudioStreamCountText(episodes.get(0));
        for (TvShowEpisode episode : episodes) {
            String otherTooltipText = this.createAudioStreamCountText(episode);
            if (Objects.equals(tooltipText, otherTooltipText)) continue;
            return null;
        }
        return tooltipText;
    }

    private String createAudioStreamCountText(TvShowEpisode episode) {
        ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>(episode.getMainVideoFile().getAudioStreams());
        if (!audioStreams.isEmpty()) {
            ArrayList<Object> tooltipText = new ArrayList<Object>();
            for (MediaFileAudioStream audioStream : audioStreams) {
                Object stream = audioStream.getCodec();
                if (StringUtils.isNotBlank((CharSequence)audioStream.getLanguage())) {
                    stream = (String)stream + " - " + audioStream.getLanguage();
                }
                if (StringUtils.isNotBlank((CharSequence)audioStream.getTitle())) {
                    stream = (String)stream + " (" + audioStream.getTitle() + ")";
                }
                tooltipText.add(stream);
            }
            return StringUtils.join(tooltipText, (String)"\n");
        }
        return null;
    }

    private MediaSource getMediaSource(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getMediaSource();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueSource(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueSource(tvShow.getEpisodes());
        }
        return null;
    }

    private MediaSource detectUniqueSource(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        MediaSource source = episodes.get(0).getMediaSource();
        for (TvShowEpisode episode : episodes) {
            if (source == episode.getMediaSource()) continue;
            return null;
        }
        return source;
    }

    private Integer getRuntime(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getRuntime();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            if (TvShowModuleManager.getInstance().getSettings().isRuntimeFromMediaInfo()) {
                return season.getRuntimeOfEpisodes();
            }
        } else if (userObject instanceof TvShow) {
            TvShow show = (TvShow)userObject;
            if (TvShowModuleManager.getInstance().getSettings().isRuntimeFromMediaInfo()) {
                return show.getRuntimeOfEpisodes();
            }
            return show.getRuntime();
        }
        return null;
    }

    private Integer getTop250(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow show = (TvShow)userObject;
            return show.getTop250() > 0 ? Integer.valueOf(show.getTop250()) : null;
        }
        return null;
    }

    private String getVideoFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return Utils.formatFileSizeForDisplay(tvShow.getVideoFilesize());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return Utils.formatFileSizeForDisplay(season.getVideoFilesize());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return Utils.formatFileSizeForDisplay(episode.getVideoFilesize());
        }
        return null;
    }

    private String getTotalFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return Utils.formatFileSizeForDisplay(tvShow.getTotalFilesize());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return Utils.formatFileSizeForDisplay(season.getTotalFilesize());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return Utils.formatFileSizeForDisplay(episode.getTotalFilesize());
        }
        return null;
    }

    private Float getAspectRatio(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return Float.valueOf(episode.getMediaInfoAspectRatio());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueAspectRatio(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueAspectRatio(tvShow.getEpisodes());
        }
        return null;
    }

    private Float detectUniqueAspectRatio(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        float aspectRatio = episodes.get(0).getMediaInfoAspectRatio();
        for (TvShowEpisode episode : episodes) {
            if (aspectRatio == episode.getMediaInfoAspectRatio()) continue;
            return null;
        }
        return Float.valueOf(aspectRatio);
    }

    private ImageIcon isHDR(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(StringUtils.isNotEmpty((CharSequence)episode.getVideoHDRFormat()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueIsHDR(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueIsHDR(tvShow.getEpisodes());
        }
        return null;
    }

    private ImageIcon detectUniqueIsHDR(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String hdrFormat = episodes.get(0).getVideoHDRFormat();
        for (TvShowEpisode episode : episodes) {
            if (hdrFormat.equals(episode.getVideoHDRFormat())) continue;
            return null;
        }
        return this.getCheckIcon(StringUtils.isNotEmpty((CharSequence)hdrFormat));
    }

    private String getVideoHDRFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getVideoHDRFormat();
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.detectUniqueHDRFormat(season.getEpisodes());
        }
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.detectUniqueHDRFormat(tvShow.getEpisodes());
        }
        return null;
    }

    private String detectUniqueHDRFormat(List<TvShowEpisode> episodes) {
        if (episodes.isEmpty()) {
            return null;
        }
        String hdrFormat = episodes.get(0).getVideoHDRFormat();
        for (TvShowEpisode episode : episodes) {
            if (hdrFormat.equals(episode.getVideoHDRFormat())) continue;
            return null;
        }
        return hdrFormat;
    }

    private ImageIcon hasMetadata(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingMetadata(tvShow).isEmpty(), tvShow.getHasEpisodeMetadata()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingMetadata(season).isEmpty(), season.getHasEpisodeMetadata()));
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(this.tvShowList.detectMissingMetadata(episode).isEmpty());
        }
        return null;
    }

    private ImageIcon hasArtwork(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingArtwork(tvShow).isEmpty(), tvShow.getHasSeasonAndEpisodeImages()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingArtwork(season).isEmpty(), season.getHasEpisodeImages()));
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(this.tvShowList.detectMissingArtwork(episode).isEmpty());
        }
        return null;
    }

    private ImageIcon hasTrailer(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.getHasTrailer());
        }
        return null;
    }

    private ImageIcon hasSubtitles(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasSubtitles());
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.isWatched());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.isWatched());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.isWatched());
        }
        return null;
    }

    private MediaCertification getCertification(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getCertification();
        }
        return null;
    }

    private String hasMetadataTooltip(TmmTreeNode node) {
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isTvShowDisplayAllMissingMetadata()) {
            for (TvShowScraperMetadataConfig config2 : TvShowScraperMetadataConfig.values()) {
                if (!config2.isMetaData() && !config2.isCast()) continue;
                tvShowValues.add(config2);
            }
        } else {
            tvShowValues.addAll(this.settings.getTvShowCheckMetadata());
        }
        ArrayList<TvShowScraperMetadataConfig> seasonValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isTvShowDisplayAllMissingMetadata()) {
            for (TvShowScraperMetadataConfig config3 : TvShowScraperMetadataConfig.values()) {
                if (!config3.isMetaData() || !config3.name().startsWith("SEASON")) continue;
                seasonValues.add(config3);
            }
        } else {
            for (TvShowScraperMetadataConfig config4 : this.settings.getTvShowCheckMetadata()) {
                if (!config4.isMetaData() || !config4.name().startsWith("SEASON")) continue;
                seasonValues.add(config4);
            }
        }
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        if (this.settings.isEpisodeDisplayAllMissingMetadata()) {
            for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : TvShowEpisodeScraperMetadataConfig.values()) {
                if (!tvShowEpisodeScraperMetadataConfig.isMetaData() && !tvShowEpisodeScraperMetadataConfig.isCast()) continue;
                episodeValues.add(tvShowEpisodeScraperMetadataConfig);
            }
        } else {
            episodeValues.addAll(this.settings.getEpisodeCheckMetadata());
        }
        Object object = node.getUserObject();
        if (object instanceof TvShow) {
            TvShow tvShow = (TvShow)object;
            List<TvShowScraperMetadataConfig> list = this.tvShowList.detectMissingFields(tvShow, tvShowValues);
            boolean missingEpisodeData = false;
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty()) continue;
                missingEpisodeData = true;
                break;
            }
            Object text = "";
            if (!list.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (TvShowScraperMetadataConfig metadataConfig : list) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                text = missing.toString();
            }
            if (missingEpisodeData) {
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + TmmResourceBundle.getString("tvshow.tree.episode.metadata.problem");
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
        } else {
            Object object2 = node.getUserObject();
            if (object2 instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)object2;
                List<TvShowScraperMetadataConfig> list = this.tvShowList.detectMissingFields(season, seasonValues);
                boolean missingEpisodeData = false;
                for (TvShowEpisode episode : season.getEpisodes()) {
                    if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty()) continue;
                    missingEpisodeData = true;
                    break;
                }
                Object text = "";
                if (!list.isEmpty()) {
                    StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                    for (TvShowScraperMetadataConfig metadataConfig : list) {
                        missing.append("\n").append(metadataConfig.getDescription());
                    }
                    text = missing.toString();
                }
                if (missingEpisodeData) {
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = (String)text + "\n\n";
                    }
                    text = (String)text + TmmResourceBundle.getString("tvshow.tree.episode.metadata.problem");
                }
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    return text;
                }
            } else {
                TvShowEpisode episode;
                List<TvShowEpisodeScraperMetadataConfig> list;
                Object object3 = node.getUserObject();
                if (object3 instanceof TvShowEpisode && !(list = this.tvShowList.detectMissingFields(episode = (TvShowEpisode)object3, episodeValues)).isEmpty()) {
                    StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                    for (TvShowEpisodeScraperMetadataConfig metadataConfig : list) {
                        missing.append("\n").append(metadataConfig.getDescription());
                    }
                    return missing.toString();
                }
            }
        }
        return null;
    }

    private String hasImageTooltip(TmmTreeNode node) {
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isTvShowDisplayAllMissingArtwork()) {
            for (TvShowScraperMetadataConfig config2 : TvShowScraperMetadataConfig.values()) {
                if (!config2.isArtwork()) continue;
                tvShowValues.add(config2);
            }
        } else {
            tvShowValues.addAll(this.settings.getTvShowCheckArtwork());
        }
        ArrayList<TvShowScraperMetadataConfig> seasonValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isSeasonDisplayAllMissingArtwork()) {
            for (TvShowScraperMetadataConfig config3 : TvShowScraperMetadataConfig.values()) {
                if (!config3.isArtwork() || !config3.name().startsWith("SEASON")) continue;
                seasonValues.add(config3);
            }
        } else {
            seasonValues.addAll(this.settings.getSeasonCheckArtwork());
        }
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        if (this.settings.isEpisodeDisplayAllMissingArtwork()) {
            for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : TvShowEpisodeScraperMetadataConfig.values()) {
                if (!tvShowEpisodeScraperMetadataConfig.isArtwork()) continue;
                episodeValues.add(tvShowEpisodeScraperMetadataConfig);
            }
        } else {
            episodeValues.addAll(this.settings.getEpisodeCheckArtwork());
        }
        Object object = node.getUserObject();
        if (object instanceof TvShow) {
            TvShow tvShow = (TvShow)object;
            List<TvShowScraperMetadataConfig> list = this.tvShowList.detectMissingFields(tvShow, tvShowValues);
            boolean missingSeasonEpisodeData = false;
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (!this.tvShowList.detectMissingFields(season, seasonValues).isEmpty()) {
                    missingSeasonEpisodeData = true;
                    break;
                }
                for (TvShowEpisode episode : season.getEpisodes()) {
                    if (episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty()) continue;
                    missingSeasonEpisodeData = true;
                    break;
                }
                if (!missingSeasonEpisodeData) continue;
                break;
            }
            Object text = "";
            if (!list.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (TvShowScraperMetadataConfig metadataConfig : list) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                text = missing.toString();
            }
            if (missingSeasonEpisodeData) {
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + TmmResourceBundle.getString("tvshow.tree.season.artwork.problem");
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
        } else {
            Object object2 = node.getUserObject();
            if (object2 instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)object2;
                List<TvShowScraperMetadataConfig> list = this.tvShowList.detectMissingFields(season, seasonValues);
                boolean missingEpisodeData = false;
                for (TvShowEpisode episode : season.getEpisodes()) {
                    if (episode.isDummy() || this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty()) continue;
                    missingEpisodeData = true;
                    break;
                }
                Object text = "";
                if (!list.isEmpty()) {
                    StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                    for (TvShowScraperMetadataConfig metadataConfig : list) {
                        missing.append("\n").append(metadataConfig.getDescription());
                    }
                    text = missing.toString();
                }
                if (missingEpisodeData) {
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = (String)text + "\n\n";
                    }
                    text = (String)text + TmmResourceBundle.getString("tvshow.tree.episode.artwork.problem");
                }
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    return text;
                }
            } else {
                TvShowEpisode episode;
                List<TvShowEpisodeScraperMetadataConfig> list;
                Object object3 = node.getUserObject();
                if (object3 instanceof TvShowEpisode && !(list = this.tvShowList.detectMissingFields(episode = (TvShowEpisode)object3, episodeValues)).isEmpty()) {
                    StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                    for (TvShowEpisodeScraperMetadataConfig metadataConfig : list) {
                        missing.append("\n").append(metadataConfig.getDescription());
                    }
                    return missing.toString();
                }
            }
        }
        return null;
    }

    private String getOriginialTitle(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getOriginalTitle();
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return episode.getOriginalTitle();
        }
        return null;
    }

    private String getSortTitle(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getSortTitle();
        }
        return null;
    }

    private ImageIcon hasDownloadedMusicTheme(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.getHasMusicTheme());
        }
        return null;
    }

    private ImageIcon hasNote(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.getHasNote());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasNote());
        }
        return null;
    }
}

