/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WildcardIndex
extends Index {
    @Nullable
    private String fieldName;
    private final Map<String, Object> wildcardProjection = new LinkedHashMap<String, Object>();

    public WildcardIndex() {
    }

    public WildcardIndex(@Nullable String path) {
        this.fieldName = path;
    }

    public WildcardIndex includeId() {
        this.wildcardProjection.put(FieldName.ID.name(), 1);
        return this;
    }

    @Override
    public WildcardIndex named(String name) {
        super.named(name);
        return this;
    }

    @Override
    public Index unique() {
        throw new UnsupportedOperationException("Wildcard Index does not support 'unique'");
    }

    @Override
    public Index expire(long seconds) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    @Override
    public Index expire(long value, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    @Override
    public Index expire(Duration duration) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    public WildcardIndex wildcardProjectionInclude(String ... paths) {
        for (String path : paths) {
            this.wildcardProjection.put(path, 1);
        }
        return this;
    }

    public WildcardIndex wildcardProjectionExclude(String ... paths) {
        for (String path : paths) {
            this.wildcardProjection.put(path, 0);
        }
        return this;
    }

    public WildcardIndex wildcardProjection(Map<String, Object> includeExclude) {
        this.wildcardProjection.putAll(includeExclude);
        return this;
    }

    private String getTargetFieldName() {
        return StringUtils.hasText((String)this.fieldName) ? this.fieldName + ".$**" : "$**";
    }

    @Override
    public Document getIndexKeys() {
        return new Document(this.getTargetFieldName(), (Object)1);
    }

    @Override
    public Document getIndexOptions() {
        Document options = new Document((Map)super.getIndexOptions());
        if (!CollectionUtils.isEmpty(this.wildcardProjection)) {
            options.put("wildcardProjection", (Object)new Document(this.wildcardProjection));
        }
        return options;
    }
}

