/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mongodb.BulkOperationException;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.BulkOperationsSupport;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultBulkOperations
extends BulkOperationsSupport
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final BulkOperationContext bulkOperationContext;
    private final List<BulkOperationsSupport.SourceAwareWriteModelHolder> models = new ArrayList<BulkOperationsSupport.SourceAwareWriteModelHolder>();
    @Nullable
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;

    DefaultBulkOperations(MongoOperations mongoOperations, String collectionName, BulkOperationContext bulkOperationContext) {
        super(collectionName);
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(bulkOperationContext.bulkMode());
    }

    void setDefaultWriteConcern(@Nullable WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(document, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(document);
        this.addModel(source, (WriteModel<Document>)new InsertOneModel((Object)this.getMappedObject(source)));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null");
        documents.forEach(this::insert);
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, UpdateDefinition update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        return this.update(query, update, false, false);
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, UpdateDefinition>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null");
        for (Pair<Query, UpdateDefinition> update : updates) {
            this.update((Query)update.getFirst(), (UpdateDefinition)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, UpdateDefinition update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        this.update(query, update, false, true);
        return this;
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, UpdateDefinition>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null");
        for (Pair<Query, UpdateDefinition> update : updates) {
            this.update((Query)update.getFirst(), (UpdateDefinition)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, UpdateDefinition update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        DeleteOptions deleteOptions = new DeleteOptions();
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
        this.addModel(query, (WriteModel<Document>)new DeleteManyModel((Bson)query.getQueryObject(), deleteOptions));
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkOperations replaceOne(Query query, Object replacement, FindAndReplaceOptions options) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)replacement, (String)"Replacement must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        ReplaceOptions replaceOptions = new ReplaceOptions();
        replaceOptions.upsert(options.isUpsert());
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((ReplaceOptions)replaceOptions).collation(arg_0));
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(replacement, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(replacement);
        this.addModel(source, (WriteModel<Document>)new ReplaceOneModel(this.getMappedQuery((Bson)query.getQueryObject()), (Object)this.getMappedObject(source), replaceOptions));
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        try {
            BulkWriteResult result = this.mongoOperations.execute(this.collectionName, this::bulkWriteTo);
            Assert.state((result != null ? 1 : 0) != 0, (String)"Result must not be null");
            this.models.forEach(this::maybeEmitAfterSaveEvent);
            this.models.forEach(this::maybeInvokeAfterSaveCallback);
            BulkWriteResult bulkWriteResult = result;
            return bulkWriteResult;
        }
        finally {
            this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(this.bulkOperationContext.bulkMode());
        }
    }

    private BulkWriteResult bulkWriteTo(MongoCollection<Document> collection) {
        if (this.defaultWriteConcern != null) {
            collection = collection.withWriteConcern(this.defaultWriteConcern);
        }
        try {
            return collection.bulkWrite(this.models.stream().map(this::extractAndMapWriteModel).collect(Collectors.toList()), this.bulkOptions);
        }
        catch (RuntimeException ex) {
            if (ex instanceof MongoBulkWriteException) {
                MongoBulkWriteException mongoBulkWriteException = (MongoBulkWriteException)ex;
                if (mongoBulkWriteException.getWriteConcernError() != null) {
                    throw new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
                }
                throw new BulkOperationException(ex.getMessage(), mongoBulkWriteException);
            }
            throw ex;
        }
    }

    private WriteModel<Document> extractAndMapWriteModel(BulkOperationsSupport.SourceAwareWriteModelHolder it) {
        this.maybeEmitBeforeSaveEvent(it);
        WriteModel<Document> writeModel = it.model();
        if (writeModel instanceof InsertOneModel) {
            InsertOneModel model = (InsertOneModel)writeModel;
            target = (Document)model.getDocument();
            this.maybeInvokeBeforeSaveCallback(it.source(), target);
        } else {
            target = it.model();
            if (target instanceof ReplaceOneModel) {
                ReplaceOneModel model = (ReplaceOneModel)target;
                target = (Document)model.getReplacement();
                this.maybeInvokeBeforeSaveCallback(it.source(), target);
            }
        }
        return this.mapWriteModel(it.source(), it.model());
    }

    private BulkOperations update(Query query, UpdateDefinition update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        UpdateOptions options = DefaultBulkOperations.computeUpdateOptions(query, update, upsert);
        if (multi) {
            this.addModel(update, (WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        } else {
            this.addModel(update, (WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        }
        return this;
    }

    @Override
    protected void maybeEmitEvent(ApplicationEvent event) {
        this.bulkOperationContext.publishEvent(event);
    }

    @Override
    protected UpdateMapper updateMapper() {
        return this.bulkOperationContext.updateMapper();
    }

    @Override
    protected QueryMapper queryMapper() {
        return this.bulkOperationContext.queryMapper();
    }

    @Override
    protected Optional<? extends MongoPersistentEntity<?>> entity() {
        return this.bulkOperationContext.entity();
    }

    private Document getMappedObject(Object source) {
        if (source instanceof Document) {
            Document document = (Document)source;
            return document;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(source, sink);
        return sink;
    }

    private void addModel(Object source, WriteModel<Document> model) {
        this.models.add(new BulkOperationsSupport.SourceAwareWriteModelHolder(source, model));
    }

    private void maybeInvokeAfterSaveCallback(BulkOperationsSupport.SourceAwareWriteModelHolder holder) {
        WriteModel<Document> writeModel = holder.model();
        if (writeModel instanceof InsertOneModel) {
            InsertOneModel model = (InsertOneModel)writeModel;
            target = (Document)model.getDocument();
            this.maybeInvokeAfterSaveCallback(holder.source(), target);
        } else {
            target = holder.model();
            if (target instanceof ReplaceOneModel) {
                ReplaceOneModel model = (ReplaceOneModel)target;
                target = (Document)model.getReplacement();
                this.maybeInvokeAfterSaveCallback(holder.source(), target);
            }
        }
    }

    private void publishEvent(MongoMappingEvent<?> event) {
        this.bulkOperationContext.publishEvent(event);
    }

    private Object maybeInvokeBeforeConvertCallback(Object value) {
        return this.bulkOperationContext.callback(BeforeConvertCallback.class, value, this.collectionName);
    }

    private Object maybeInvokeBeforeSaveCallback(Object value, Document mappedDocument) {
        return this.bulkOperationContext.callback(BeforeSaveCallback.class, value, mappedDocument, this.collectionName);
    }

    private Object maybeInvokeAfterSaveCallback(Object value, Document mappedDocument) {
        return this.bulkOperationContext.callback(AfterSaveCallback.class, value, mappedDocument, this.collectionName);
    }

    record BulkOperationContext(BulkOperations.BulkMode bulkMode, Optional<? extends MongoPersistentEntity<?>> entity, QueryMapper queryMapper, UpdateMapper updateMapper, @Nullable ApplicationEventPublisher eventPublisher, @Nullable EntityCallbacks entityCallbacks) {
        public boolean skipEntityCallbacks() {
            return this.entityCallbacks == null;
        }

        public boolean skipEventPublishing() {
            return this.eventPublisher == null;
        }

        public <T> T callback(Class<? extends EntityCallback> callbackType, T entity, String collectionName) {
            if (this.skipEntityCallbacks()) {
                return entity;
            }
            return (T)this.entityCallbacks.callback(callbackType, entity, new Object[]{collectionName});
        }

        public <T> T callback(Class<? extends EntityCallback> callbackType, T entity, Document document, String collectionName) {
            if (this.skipEntityCallbacks()) {
                return entity;
            }
            return (T)this.entityCallbacks.callback(callbackType, entity, new Object[]{document, collectionName});
        }

        public void publishEvent(ApplicationEvent event) {
            if (this.skipEventPublishing()) {
                return;
            }
            this.eventPublisher.publishEvent(event);
        }
    }
}

