/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.EvolutionStart;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class EvolutionIterator<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Iterator<EvolutionResult<G, C>> {
    private final Function<EvolutionStart<G, C>, EvolutionResult<G, C>> _evolution;
    private final Supplier<EvolutionStart<G, C>> _initial;
    private EvolutionStart<G, C> _start;

    EvolutionIterator(Supplier<EvolutionStart<G, C>> initial, Function<EvolutionStart<G, C>, EvolutionResult<G, C>> evolution) {
        this._evolution = Objects.requireNonNull(evolution);
        this._initial = Objects.requireNonNull(initial);
    }

    @Override
    public EvolutionResult<G, C> next() {
        if (this._start == null) {
            this._start = this._initial.get();
        }
        EvolutionResult<G, C> result = this._evolution.apply(this._start);
        this._start = result.next();
        return result;
    }

    @Override
    public boolean hasNext() {
        return true;
    }
}

