/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.exception;

import com.ubnt.net.Dto;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.springframework.http.HttpStatus;

@Schema(extensions={@Extension(properties={@ExtensionProperty(name="x-tags", value="Errors")})})
public final class IntegrationErrorMessage
implements Dto {
    @Schema(example="400")
    private final int statusCode;
    @Schema(example="UNAUTHORIZED")
    private final String statusName;
    @Schema(example="Missing credentials")
    private final String message;
    @Schema(example="2024-11-27T08:13:46.966Z")
    private final Instant timestamp;
    @Schema(example="/integration/v1/sites/123")
    private final String requestPath;
    @Schema(example="3fa85f64-5717-4562-b3fc-2c963f66afa6", description="In case of Internal Server Error (core = 500), request ID can be used to track down the error in the server log")
    private final UUID requestId;

    public static IntegrationErrorMessage of(HttpStatus httpStatus, String string, Instant instant, String string2, UUID uUID) {
        return new IntegrationErrorMessage(httpStatus.value(), httpStatus.name(), string, instant, string2, uUID);
    }

    @ConstructorProperties(value={"statusCode", "statusName", "message", "timestamp", "requestPath", "requestId"})
    @Generated
    public IntegrationErrorMessage(int n2, String string, String string2, Instant instant, String string3, UUID uUID) {
        this.statusCode = n2;
        this.statusName = string;
        this.message = string2;
        this.timestamp = instant;
        this.requestPath = string3;
        this.requestId = uUID;
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getStatusName() {
        return this.statusName;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getRequestPath() {
        return this.requestPath;
    }

    @Generated
    public UUID getRequestId() {
        return this.requestId;
    }

    @Generated
    public String toString() {
        return "IntegrationErrorMessage(statusCode=" + this.getStatusCode() + ", statusName=" + this.getStatusName() + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ", requestPath=" + this.getRequestPath() + ", requestId=" + this.getRequestId() + ")";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationErrorMessage)) {
            return false;
        }
        IntegrationErrorMessage integrationErrorMessage = (IntegrationErrorMessage)object;
        if (this.getStatusCode() != integrationErrorMessage.getStatusCode()) {
            return false;
        }
        String string = this.getStatusName();
        String string2 = integrationErrorMessage.getStatusName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getMessage();
        String string4 = integrationErrorMessage.getMessage();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Instant instant = this.getTimestamp();
        Instant instant2 = integrationErrorMessage.getTimestamp();
        if (instant == null ? instant2 != null : !((Object)instant).equals(instant2)) {
            return false;
        }
        String string5 = this.getRequestPath();
        String string6 = integrationErrorMessage.getRequestPath();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        UUID uUID = this.getRequestId();
        UUID uUID2 = integrationErrorMessage.getRequestId();
        return !(uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + this.getStatusCode();
        String string = this.getStatusName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getMessage();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Instant instant = this.getTimestamp();
        n2 = n2 * 59 + (instant == null ? 43 : ((Object)instant).hashCode());
        String string3 = this.getRequestPath();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        UUID uUID = this.getRequestId();
        n2 = n2 * 59 + (uUID == null ? 43 : ((Object)uUID).hashCode());
        return n2;
    }
}

