/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficflow;

import com.ubnt.data.Site;
import com.ubnt.model.api.stats.StatsPeriod;
import com.ubnt.model.api.trafficflow.TrafficFlowDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataParametersDto;
import com.ubnt.model.api.trafficflow.TrafficFlowListDto;
import com.ubnt.model.api.trafficflow.TrafficFlowParametersDto;
import com.ubnt.model.api.trafficstats.AppTrafficDto;
import com.ubnt.net.class;
import com.ubnt.net.private;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.trafficflow.l;
import com.ubnt.service.trafficflow.oooOo;
import com.ubnt.service.trafficflow.search.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.String;
import com.ubnt.service.trafficflow.stats.D;
import com.ubnt.service.trafficflow.stats.F;
import com.ubnt.service.trafficflow.stats.dto.TrafficFlowStatisticsDto;
import com.ubnt.service.trafficflow.stats.super;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Traffic Flow")
public class TrafficFlowController {
    static final int \u00d400000 = 30;
    static final int \u00d300000 = 100;
    private final oooOo \u00f400000;
    private final l \u00d800000;
    private final F \u00d600000;
    private final com.ubnt.service.stat.dpi.super super;
    private final Clock \u00d200000;
    private final super class;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/traffic-flows"})
    @Operation(summary="List Traffic Flows", description="Since 9.1.64")
    public TrafficFlowListDto listTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        Page<TrafficFlowDto> page = this.\u00f400000.\u00d2O0000(site.getId(), this.\u00d800000.\u00d200000(trafficFlowParametersDto));
        return TrafficFlowListDto.of(page);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/{id}"})
    @Operation(summary="Get Traffic Flow by ID", description="Since 9.2.60")
    public TrafficFlowDto getTrafficFlowById(@PathVariable(value="siteName") Site site, @PathVariable(value="id") java.lang.String string) {
        return this.\u00f400000.\u00d500000(string, site.getId()).orElseThrow(String::new);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/alarm/{alarmId}"})
    @Operation(summary="Get Traffic Flow by IPS alarm ID", description="Since 9.1.98")
    public TrafficFlowDto getTrafficFlowByAlarmId(@PathVariable(value="siteName") Site site, @PathVariable(value="alarmId") java.lang.String string) {
        return this.\u00f400000.\u00d5O0000(site.getId(), string).orElseThrow(String::new);
    }

    @PostMapping(value={"/api/site/{siteName}/traffic-flows/export"}, consumes={"application/json"}, produces={"text/csv"})
    @AllowReadPrivileges
    @Operation(summary="Export Traffic Flows in CSV format", description="Since 9.1.93")
    public ResponseBodyEmitter exportTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        class clazz = new class();
        Flux<java.lang.String> flux = this.\u00f400000.OO0000(site.getId(), this.\u00d800000.\u00d200000(trafficFlowParametersDto));
        clazz.onTimeout(() -> flux.subscribe().dispose());
        clazz.onCompletion(() -> flux.subscribe().dispose());
        flux.subscribe(string -> {
            try {
                clazz.send(string, private.o00000);
            }
            catch (Exception exception) {
                clazz.completeWithError(exception);
            }
        }, arg_0 -> ((ResponseBodyEmitter)clazz).completeWithError(arg_0), () -> ((ResponseBodyEmitter)clazz).complete());
        return clazz;
    }

    @AllowReadPrivileges
    @Operation(summary="Get traffic flow stats for the last 1H/1D/1W/1M", description="Since 9.1.82")
    @GetMapping(value={"/api/site/{siteName}/traffic-flow-latest-statistics"})
    public TrafficFlowStatisticsDto getTrafficFlowStats(@PathVariable(value="siteName") Site site, @RequestParam(value="period") StatsPeriod statsPeriod, @RequestParam(value="top", required=false) Integer n3) {
        Instant instant = this.\u00d200000.instant();
        long l2 = statsPeriod.subtractFrom(instant).toEpochMilli();
        long l3 = instant.toEpochMilli();
        D d2 = this.\u00d600000.\u00f8\u00d8O000(site.getId(), l2, l3).get(0);
        List<AppTrafficDto> list = this.super.\u00d6\u00f4O000(site.getId(), l2, l3);
        return this.class.\u00d500000(site, d2, list, Optional.ofNullable(n3).map(n2 -> Math.max(Math.min(n2, 100), 1)).orElse(30));
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/filter-data"})
    @Operation(summary="Get Traffic Flows filter data", description="Since 9.1.100")
    public TrafficFlowFilterDataDto getTrafficFlowFilterData(@PathVariable(value="siteName") Site site, @Valid TrafficFlowFilterDataParametersDto trafficFlowFilterDataParametersDto) {
        return this.\u00f400000.Object(site.getId(), this.\u00d800000.o00000(trafficFlowFilterDataParametersDto));
    }

    @ConstructorProperties(value={"trafficFlowService", "trafficFlowParametersDtoMapper", "summarizedTrafficFlowStatisticsProvider", "summarizedGatewayDpiStatisticsProvider", "clock", "trafficFlowStatisticsDtoMapper"})
    @Generated
    public TrafficFlowController(oooOo oooOo2, l l2, F f2, com.ubnt.service.stat.dpi.super super_, Clock clock, super super_2) {
        this.\u00f400000 = oooOo2;
        this.\u00d800000 = l2;
        this.\u00d600000 = f2;
        this.super = super_;
        this.\u00d200000 = clock;
        this.class = super_2;
    }
}

