/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.tinymediamanager.core.entities.MediaEntity;

public class RenamerPreviewContainer {
    final MediaEntity entity;
    final Path oldPath;
    final List<MediaFileTypeContainer> files;
    public Path newPath;
    public boolean renamerProblems = false;

    public RenamerPreviewContainer(MediaEntity entity) {
        this.entity = entity;
        this.files = new ArrayList<MediaFileTypeContainer>();
        this.oldPath = entity != null && !entity.getDataSource().isEmpty() ? entity.getPathNIO() : null;
    }

    public MediaEntity get() {
        return this.entity;
    }

    public Path getOldPath() {
        return this.oldPath;
    }

    public Path getOldPathRelative() {
        return Paths.get(this.entity.getDataSource(), new String[0]).relativize(this.entity.getPathNIO());
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public Path getNewPathRelative() {
        return Paths.get(this.entity.getDataSource(), new String[0]).relativize(this.newPath);
    }

    public boolean isNeedsRename() {
        if (!this.entity.getPathNIO().equals(this.newPath)) {
            return true;
        }
        return this.files.stream().anyMatch(mftc -> !mftc.isUnchanged());
    }

    public boolean hasRenamerProblems() {
        return this.renamerProblems;
    }

    public List<MediaFileTypeContainer> getFiles() {
        return this.files;
    }

    public void addFile(MediaFileTypeContainer file) {
        this.files.add(file);
    }

    public static class MediaFileTypeContainer {
        public Set<String> oldFiles = new TreeSet<String>();
        public Set<String> newFiles = new TreeSet<String>();
        public boolean duped = false;

        public boolean isUnchanged() {
            return this.oldFiles.equals(this.newFiles);
        }
    }
}

