/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class KodiUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiUrl.class);
    private String urlString;
    private Url url;
    private String functionName;
    private KodiScraper scraper;

    public KodiUrl(Element url) {
        this.updateFromElement(url);
    }

    public KodiUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        if (url.strip().contains("<url")) {
            url = StrgUtils.substr(url, "(<url.*?>.*?</url>)").strip();
            try {
                url = StringEscapeUtils.unescapeHtml4((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = StringEscapeUtils.unescapeXml((String)url);
                url = url.replaceAll("\\&", "\\&amp;");
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = f.newDocumentBuilder();
                Document d = parser.parse(new ByteArrayInputStream(url.getBytes()));
                Element e = (Element)d.getElementsByTagName("url").item(0);
                this.updateFromElement(e);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid xml url: " + url, e);
            }
        } else {
            this.urlString = url.strip();
        }
        LOGGER.trace("KodiUrl using Url from String: " + this.urlString);
    }

    public KodiUrl(String url, KodiScraper kodiScraper) {
        this(url);
        this.scraper = kodiScraper;
    }

    public KodiUrl(Element url, KodiScraper kodiScraper) {
        this(url);
        this.scraper = kodiScraper;
    }

    private void updateFromElement(Element e) {
        this.urlString = e.getTextContent();
        if (this.urlString != null) {
            this.urlString = this.urlString.strip();
        }
        LOGGER.trace("KodiUrl using Url from Xml: " + this.urlString);
        this.functionName = e.getAttribute("function");
    }

    private Url getUrl() throws Exception {
        if (this.url == null) {
            this.url = new InMemoryCachedUrl(this.urlString);
        }
        return this.url;
    }

    /*
     * Exception decompiling
     */
    public InputStream getInputStream() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toExternalForm() {
        return this.urlString;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getTextContent() throws Exception {
        try (InputStream is = this.getInputStream();){
            if (is == null) {
                LOGGER.debug("InputStream was NULL!!!");
                String string = "";
                return string;
            }
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    public String toString() {
        return "KodiUrl[" + this.urlString + "]";
    }
}

