/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.pcap;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.ubnt.model.OO0O.B.ooOO;
import com.ubnt.model.api.pcap.ImmutablePacketCaptureStartRequestDto;
import com.ubnt.model.api.pcap.PacketCaptureTrafficType;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.return.F;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutablePacketCaptureStartRequestDto.class)
@Schema(name="Packet Capture Start Request")
@Value.Immutable
@F
public interface PacketCaptureStartRequestDto {
    @JsonProperty(value="mac")
    @MacAddress
    @NotEmpty
    @Schema(description="MAC address of the device to capture packets", example="00:11:22:33:44:55")
    public String mac();

    @JsonProperty(value="duration")
    @Min(value=10L)
    @Max(value=300L)
    @Schema(description="Duration of the packet capture in seconds", example="30")
    @Value.Default
    default public @Min(value=10L) @Max(value=300L) int durationInSeconds() {
        return 30;
    }

    @JsonProperty(value="network_id")
    @NotEmpty
    @Schema(description="Network ID of the network to capture packets", example="5f4b1b1e4b0f4b1e4b0f4b1e")
    public String networkId();

    @JsonProperty(value="radio_bands")
    @Schema(description="Radios to capture packets from", example="[\"ng\", \"na\", \"6e\"]")
    @Value.Default
    default public List<ooOO> radioBands() {
        return List.of();
    }

    @JsonProperty(value="max_size")
    @Min(value=10L)
    @Max(value=51200L)
    @Schema(description="Maximum size of the packet capture file in kilobytes", example="5120")
    @Value.Default
    default public @Min(value=10L) @Max(value=51200L) int maxSizeInKBytes() {
        return 5120;
    }

    @JsonProperty(value="traffic_type")
    @NotNull
    @Schema(description="Type of traffic to capture", example="WIRELESS")
    public PacketCaptureTrafficType trafficType();

    @VisibleForTesting
    public static ImmutablePacketCaptureStartRequestDto.Builder builder() {
        return ImmutablePacketCaptureStartRequestDto.builder();
    }
}

