/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.traffic;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.IpVersion;
import com.ubnt.model.api.traffic.ImmutableTrafficIpDto;
import com.ubnt.model.api.traffic.TrafficPortRangeDto;
import com.ubnt.return.F;
import com.ubnt.service.traffic.TrafficIpDocumentPart;
import com.ubnt.service.traffic.TrafficPortRangeDocumentPart;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableTrafficIpDto.class)
@JsonDeserialize(builder=ImmutableTrafficIpDto.Builder.class)
@Value.Immutable
@F
public interface TrafficIpDto {
    @NotNull
    @JsonProperty(value="ip_version")
    public IpVersion ipVersion();

    @NotEmpty
    @JsonProperty(value="ip_or_subnet")
    public String ipOrSubnet();

    @JsonProperty(value="ports")
    public List<@Min(value=1L) @Max(value=65535L) Integer> ports();

    @JsonProperty(value="port_ranges")
    @Valid
    public List<TrafficPortRangeDto> portRanges();

    default public TrafficIpDocumentPart toDocument() {
        return TrafficIpDocumentPart.builder().\u00d200000(this.ipVersion()).Object(this.ipOrSubnet()).\u00f500000(this.ports()).\u00d600000(this.portRanges().stream().map(trafficPortRangeDto -> TrafficPortRangeDocumentPart.of(trafficPortRangeDto.portStart(), trafficPortRangeDto.portStop())).collect(Collectors.toList())).\u00d500000();
    }

    public static ImmutableTrafficIpDto.Builder builder() {
        return ImmutableTrafficIpDto.builder();
    }

    public static TrafficIpDto fromDocument(TrafficIpDocumentPart trafficIpDocumentPart) {
        return TrafficIpDto.builder().ipVersion(trafficIpDocumentPart.getIpVersion()).ipOrSubnet(trafficIpDocumentPart.getIpOrSubnet()).ports(trafficIpDocumentPart.getPorts()).portRanges(trafficIpDocumentPart.getPortRanges().stream().map(trafficPortRangeDocumentPart -> TrafficPortRangeDto.of(trafficPortRangeDocumentPart.getPortStart(), trafficPortRangeDocumentPart.getPortStop())).collect(Collectors.toList())).build();
    }
}

