/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import lombok.Generated;
import lombok.NonNull;

public class ArrayIterable<T>
implements Iterable<T> {
    @NonNull
    private final T[] array;
    private final boolean reverse;

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.array, this.reverse);
    }

    @Generated
    public ArrayIterable(@NonNull T[] array, boolean reverse) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.array = array;
        this.reverse = reverse;
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] array;
        private final int increment;
        private int i;

        public ArrayIterator(T[] array, boolean reverse) {
            this.array = array;
            if (reverse) {
                this.i = array.length - 1;
                this.increment = -1;
            } else {
                this.i = 0;
                this.increment = 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.i >= 0 && this.i < this.array.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T element = this.array[this.i];
            this.i += this.increment;
            return element;
        }
    }
}

