/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class ItemLayerGeometry
implements UnbakedGeometry {
    private static final ItemLayerGeometry INSTANCE = new ItemLayerGeometry((Int2ObjectMap<ResourceLocation>)Int2ObjectMaps.emptyMap(), (Int2ObjectMap<ResourceLocation>)Int2ObjectMaps.emptyMap());
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;
    private final Int2ObjectMap<ResourceLocation> renderTypeFastNames;

    private ItemLayerGeometry(Int2ObjectMap<ResourceLocation> renderTypeNames, Int2ObjectMap<ResourceLocation> renderTypeFastNames) {
        this.renderTypeNames = renderTypeNames;
        this.renderTypeFastNames = renderTypeFastNames;
    }

    public QuadCollection bake(TextureSlots textures, ModelBaker baker, ModelState state, ModelDebugName name) {
        String layer;
        Material material;
        ArrayList elements = new ArrayList();
        int i = 0;
        while ((material = textures.getMaterial(layer = "layer" + i++)) != null) {
            SpriteContents contents = baker.sprites().get(material, name).contents();
            elements.addAll(ItemModelGenerator.processFrames((int)i, (String)layer, (SpriteContents)contents));
        }
        return SimpleUnbakedGeometry.bake(elements, (TextureSlots)textures, (SpriteGetter)baker.sprites(), (ModelState)state, (ModelDebugName)name);
    }

    public static final class Loader
    implements IGeometryLoader {
        public static final Loader INSTANCE = new Loader();

        @Override
        public UnbakedGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return INSTANCE;
        }

        private static Int2ObjectMap<ResourceLocation> readRenderTypeNames(JsonObject jsonObject, String key) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has(key)) {
                JsonObject renderTypes = jsonObject.getAsJsonObject(key);
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = ResourceLocation.parse((String)((String)entry.getKey()));
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate " + key + " for layer " + String.valueOf(layer));
                    }
                }
            }
            return renderTypeNames;
        }
    }
}

