/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.packets.OpenContainer;

public interface IForgeServerPlayer {
    private ServerPlayer self() {
        return (ServerPlayer)this;
    }

    default public void openMenu(MenuProvider containerSupplier, BlockPos pos) {
        this.openMenu(containerSupplier, (FriendlyByteBuf buf) -> buf.writeBlockPos(pos));
    }

    default public void openMenu(MenuProvider containerSupplier, Consumer<FriendlyByteBuf> extraDataWriter) {
        ServerPlayer player = this.self();
        if (player.level().isClientSide) {
            return;
        }
        player.doCloseContainer();
        player.nextContainerCounter();
        int openContainerId = player.containerCounter;
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraDataWriter.accept(extraData);
        extraData.readerIndex(0);
        FriendlyByteBuf output = new FriendlyByteBuf(Unpooled.buffer());
        output.writeVarInt(extraData.readableBytes());
        output.writeBytes((ByteBuf)extraData);
        if (output.readableBytes() > 32600 || output.readableBytes() < 1) {
            throw new IllegalArgumentException("Invalid PacketBuffer for openGui, found " + output.readableBytes() + " bytes");
        }
        AbstractContainerMenu c = containerSupplier.createMenu(openContainerId, player.getInventory(), (Player)player);
        if (c == null) {
            return;
        }
        OpenContainer msg = new OpenContainer(c.getType(), openContainerId, containerSupplier.getDisplayName(), output);
        NetworkInitialization.PLAY.send(msg, player.connection.getConnection());
        player.containerMenu = c;
        player.initMenu(player.containerMenu);
        ForgeEventFactory.onPlayerOpenContainer(player, c);
    }
}

