/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ElderGuardianParticleGroup;
import net.minecraft.client.particle.ItemPickupParticleGroup;
import net.minecraft.client.particle.NoRenderParticleGroup;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.ParticleResources;
import net.minecraft.client.particle.QuadParticleGroup;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.ParticlesRenderState;
import net.minecraft.core.particles.ParticleLimit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleEngine {
    private static final List<ParticleRenderType> RENDER_ORDER = List.of(ParticleRenderType.SINGLE_QUADS, ParticleRenderType.ITEM_PICKUP, ParticleRenderType.ELDER_GUARDIANS);
    protected ClientLevel level;
    private final Map<ParticleRenderType, ParticleGroup<?>> particles = Maps.newIdentityHashMap();
    private final Queue<TrackingEmitter> trackingEmitters = Queues.newArrayDeque();
    private final Queue<Particle> particlesToAdd = Queues.newArrayDeque();
    private final Object2IntOpenHashMap<ParticleLimit> trackedParticleCounts = new Object2IntOpenHashMap();
    private final ParticleResources resourceManager;
    private final RandomSource random = RandomSource.create();
    private static final Map<ParticleRenderType, Function<ParticleEngine, ParticleGroup<?>>> factories = new HashMap();
    private static final List<ParticleRenderType> particleRenderOrder = new ArrayList<ParticleRenderType>(RENDER_ORDER);

    public ParticleEngine(ClientLevel p_107299_, ParticleResources p_423228_) {
        this.level = p_107299_;
        this.resourceManager = p_423228_;
    }

    public void createTrackingEmitter(Entity p_107330_, ParticleOptions p_107331_) {
        this.trackingEmitters.add(new TrackingEmitter(this.level, p_107330_, p_107331_));
    }

    public void createTrackingEmitter(Entity p_107333_, ParticleOptions p_107334_, int p_107335_) {
        this.trackingEmitters.add(new TrackingEmitter(this.level, p_107333_, p_107334_, p_107335_));
    }

    @Nullable
    public Particle createParticle(ParticleOptions p_107371_, double p_107372_, double p_107373_, double p_107374_, double p_107375_, double p_107376_, double p_107377_) {
        Particle particle = this.makeParticle(p_107371_, p_107372_, p_107373_, p_107374_, p_107375_, p_107376_, p_107377_);
        if (particle != null) {
            this.add(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(T p_107396_, double p_107397_, double p_107398_, double p_107399_, double p_107400_, double p_107401_, double p_107402_) {
        ParticleProvider<?> particleprovider = this.resourceManager.getProvider(p_107396_.getType());
        return particleprovider == null ? null : particleprovider.createParticle(p_107396_, this.level, p_107397_, p_107398_, p_107399_, p_107400_, p_107401_, p_107402_, this.random);
    }

    public void add(Particle p_107345_) {
        Optional<ParticleLimit> optional = p_107345_.getParticleLimit();
        if (optional.isPresent()) {
            if (this.hasSpaceInParticleLimit(optional.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount(optional.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.particles.forEach((p_420862_, p_420863_) -> {
            Profiler.get().push(p_420862_.name());
            p_420863_.tickParticles();
            Profiler.get().pop();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (TrackingEmitter trackingemitter : this.trackingEmitters) {
                trackingemitter.tick();
                if (trackingemitter.isAlive()) continue;
                list.add(trackingemitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            Particle particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.getGroup(), this::createParticleGroup).add(particle);
            }
        }
    }

    private ParticleGroup<?> createParticleGroup(ParticleRenderType p_428647_) {
        if (p_428647_ == ParticleRenderType.ITEM_PICKUP) {
            return new ItemPickupParticleGroup(this);
        }
        if (p_428647_ == ParticleRenderType.ELDER_GUARDIANS) {
            return new ElderGuardianParticleGroup(this);
        }
        if (factories.containsKey(p_428647_)) {
            return factories.get(p_428647_).apply(this);
        }
        return p_428647_ == ParticleRenderType.NO_RENDER ? new NoRenderParticleGroup(this) : new QuadParticleGroup(this, p_428647_);
    }

    protected void updateCount(ParticleLimit p_423291_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_423291_, p_172283_);
    }

    public static void registerParticleGroup(ParticleRenderType type, Function<ParticleEngine, ParticleGroup<?>> factory) {
        if (factories.putIfAbsent(type, factory) != null) {
            throw new IllegalArgumentException(type.name() + " already has a factory registered. Previous factory was " + String.valueOf(factories.get(type)) + ". This factory was " + String.valueOf(factory));
        }
        particleRenderOrder.add(type);
    }

    public void extract(ParticlesRenderState p_423938_, Frustum p_424803_, Camera p_430521_, float p_426823_) {
        for (ParticleRenderType particlerendertype : particleRenderOrder) {
            ParticleGroup<?> particlegroup = this.particles.get(particlerendertype);
            if (particlegroup == null || particlegroup.isEmpty()) continue;
            p_423938_.add(particlegroup.extractRenderState(p_424803_, p_430521_, p_426823_));
        }
    }

    public void setLevel(@Nullable ClientLevel p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(ParticleGroup::size).sum());
    }

    private boolean hasSpaceInParticleLimit(ParticleLimit p_426844_) {
        return this.trackedParticleCounts.getInt((Object)p_426844_) < p_426844_.limit();
    }

    public void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }
}

