/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<Boolean> AUTHENTICATED_KEY = AttributeKey.valueOf((String)"authenticated");
    public static final String AUTH_HEADER = "Authorization";
    public static final String BEARER_PREFIX = "Bearer ";
    private final SecurityConfig securityConfig;

    public AuthenticationHandler(SecurityConfig $$0) {
        this.securityConfig = $$0;
    }

    public void channelRead(ChannelHandlerContext $$0, Object $$1) throws Exception {
        Boolean $$5;
        String $$2 = this.getClientIp($$0);
        if ($$1 instanceof HttpRequest) {
            HttpRequest $$3 = (HttpRequest)$$1;
            SecurityCheckResult $$4 = this.performSecurityChecks($$3);
            if ($$4.isAllowed()) {
                $$0.channel().attr(AUTHENTICATED_KEY).set((Object)true);
            } else {
                this.LOGGER.debug("Authentication rejected for connection with ip {}: {}", (Object)$$2, (Object)$$4.getReason());
                $$0.channel().attr(AUTHENTICATED_KEY).set((Object)false);
                this.sendUnauthorizedResponse($$0, $$4.getReason());
                return;
            }
        }
        if (Boolean.TRUE.equals($$5 = (Boolean)$$0.channel().attr(AUTHENTICATED_KEY).get())) {
            super.channelRead($$0, $$1);
        } else {
            this.LOGGER.debug("Dropping unauthenticated connection with ip {}", (Object)$$2);
            $$0.close();
        }
    }

    private SecurityCheckResult performSecurityChecks(HttpRequest $$0) {
        if (!this.validateAuthentication($$0)) {
            return SecurityCheckResult.denied("Invalid or missing API key");
        }
        return SecurityCheckResult.allowed();
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateAuthentication(HttpRequest $$0) {
        void $$3;
        String $$1 = $$0.headers().get(AUTH_HEADER);
        if ($$1 == null || $$1.trim().isEmpty()) {
            return false;
        }
        if (!$$1.startsWith(BEARER_PREFIX)) {
            return false;
        }
        String $$2 = $$1.substring(BEARER_PREFIX.length()).trim();
        return this.isValidApiKey((String)$$3);
    }

    public boolean isValidApiKey(String $$0) {
        if ($$0 == null || $$0.isEmpty()) {
            return false;
        }
        byte[] $$1 = $$0.getBytes(StandardCharsets.UTF_8);
        byte[] $$2 = this.securityConfig.secretKey().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual($$1, $$2);
    }

    private String getClientIp(ChannelHandlerContext $$0) {
        InetSocketAddress $$1 = (InetSocketAddress)$$0.channel().remoteAddress();
        return $$1.getAddress().getHostAddress();
    }

    private void sendUnauthorizedResponse(ChannelHandlerContext $$0, String $$12) {
        String $$2 = "{\"error\":\"Unauthorized\",\"message\":\"" + $$12 + "\"}";
        byte[] $$3 = $$2.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse $$4 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])$$3));
        $$4.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        $$4.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)$$3.length);
        $$4.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        $$0.writeAndFlush((Object)$$4).addListener($$1 -> $$0.close());
    }

    static class SecurityCheckResult {
        private final boolean allowed;
        private final String reason;

        private SecurityCheckResult(boolean $$0, String $$1) {
            this.allowed = $$0;
            this.reason = $$1;
        }

        public static SecurityCheckResult allowed() {
            return new SecurityCheckResult(true, null);
        }

        public static SecurityCheckResult denied(String $$0) {
            return new SecurityCheckResult(false, $$0);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

