/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;

public class CopperChestBlock
extends ChestBlock {
    public static final MapCodec<CopperChestBlock> CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)WeatheringCopper.WeatherState.CODEC.fieldOf("weathering_state").forGetter(CopperChestBlock::getState), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("open_sound").forGetter(ChestBlock::getOpenChestSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("close_sound").forGetter(ChestBlock::getCloseChestSound), CopperChestBlock.propertiesCodec()).apply((Applicative)$$0, CopperChestBlock::new));
    private static final Map<Block, Supplier<Block>> COPPER_TO_COPPER_CHEST_MAPPING = Map.of(Blocks.COPPER_BLOCK, () -> Blocks.COPPER_CHEST, Blocks.EXPOSED_COPPER, () -> Blocks.EXPOSED_COPPER_CHEST, Blocks.WEATHERED_COPPER, () -> Blocks.WEATHERED_COPPER_CHEST, Blocks.OXIDIZED_COPPER, () -> Blocks.OXIDIZED_COPPER_CHEST, Blocks.WAXED_COPPER_BLOCK, () -> Blocks.COPPER_CHEST, Blocks.WAXED_EXPOSED_COPPER, () -> Blocks.EXPOSED_COPPER_CHEST, Blocks.WAXED_WEATHERED_COPPER, () -> Blocks.WEATHERED_COPPER_CHEST, Blocks.WAXED_OXIDIZED_COPPER, () -> Blocks.OXIDIZED_COPPER_CHEST);
    private final WeatheringCopper.WeatherState weatherState;

    @Override
    public MapCodec<? extends CopperChestBlock> codec() {
        return CODEC;
    }

    public CopperChestBlock(WeatheringCopper.WeatherState $$0, SoundEvent $$1, SoundEvent $$2, BlockBehaviour.Properties $$3) {
        super(() -> BlockEntityType.CHEST, $$1, $$2, $$3);
        this.weatherState = $$0;
    }

    @Override
    public boolean chestCanConnectTo(BlockState $$0) {
        return $$0.is(BlockTags.COPPER_CHESTS) && $$0.hasProperty(ChestBlock.TYPE);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        BlockState $$1 = super.getStateForPlacement($$0);
        return CopperChestBlock.getLeastOxidizedChestOfConnectedBlocks($$1, $$0.getLevel(), $$0.getClickedPos());
    }

    private static BlockState getLeastOxidizedChestOfConnectedBlocks(BlockState $$0, Level $$1, BlockPos $$2) {
        Block block;
        BlockState $$3 = $$1.getBlockState($$2.relative(CopperChestBlock.getConnectedDirection($$0)));
        if (!$$0.getValue(ChestBlock.TYPE).equals(ChestType.SINGLE) && (block = $$0.getBlock()) instanceof CopperChestBlock) {
            CopperChestBlock $$4 = (CopperChestBlock)block;
            block = $$3.getBlock();
            if (block instanceof CopperChestBlock) {
                CopperChestBlock $$5 = (CopperChestBlock)block;
                BlockState $$6 = $$0;
                BlockState $$7 = $$3;
                if ($$4.isWaxed() != $$5.isWaxed()) {
                    $$6 = CopperChestBlock.unwaxBlock($$4, $$0).orElse($$6);
                    $$7 = CopperChestBlock.unwaxBlock($$5, $$3).orElse($$7);
                }
                Block $$8 = $$4.weatherState.ordinal() <= $$5.weatherState.ordinal() ? $$6.getBlock() : $$7.getBlock();
                return $$8.withPropertiesOf($$6);
            }
        }
        return $$0;
    }

    @Override
    protected BlockState updateShape(BlockState $$0, LevelReader $$1, ScheduledTickAccess $$2, BlockPos $$3, Direction $$4, BlockPos $$5, BlockState $$6, RandomSource $$7) {
        ChestType $$9;
        BlockState $$8 = super.updateShape($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
        if (this.chestCanConnectTo($$6) && !($$9 = $$8.getValue(ChestBlock.TYPE)).equals(ChestType.SINGLE) && CopperChestBlock.getConnectedDirection($$8) == $$4) {
            return $$6.getBlock().withPropertiesOf($$8);
        }
        return $$8;
    }

    private static Optional<BlockState> unwaxBlock(CopperChestBlock $$0, BlockState $$12) {
        if (!$$0.isWaxed()) {
            return Optional.of($$12);
        }
        return Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)$$12.getBlock())).map($$1 -> $$1.withPropertiesOf($$12));
    }

    public WeatheringCopper.WeatherState getState() {
        return this.weatherState;
    }

    public static BlockState getFromCopperBlock(Block $$0, Direction $$1, Level $$2, BlockPos $$3) {
        CopperChestBlock $$4 = (CopperChestBlock)COPPER_TO_COPPER_CHEST_MAPPING.getOrDefault($$0, Blocks.COPPER_CHEST::asBlock).get();
        ChestType $$5 = $$4.getChestType($$2, $$3, $$1);
        BlockState $$6 = (BlockState)((BlockState)$$4.defaultBlockState().setValue(FACING, $$1)).setValue(TYPE, $$5);
        return CopperChestBlock.getLeastOxidizedChestOfConnectedBlocks($$6, $$2, $$3);
    }

    public boolean isWaxed() {
        return true;
    }

    @Override
    public boolean shouldChangedStateKeepBlockEntity(BlockState $$0) {
        return $$0.is(BlockTags.COPPER_CHESTS);
    }
}

