/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.parser;

import java.util.Locale;
import net.minecraftforge.accesstransformer.AccessTransformer;

public final class ModifierProcessor {
    private ModifierProcessor() {
    }

    public static AccessTransformer.Modifier modifier(String modifierString) {
        String modifier = modifierString.toUpperCase(Locale.ROOT);
        char f = modifier.charAt(modifier.length() - 1);
        char op = modifier.charAt(modifier.length() - 2);
        if (f == 'F' && (op == '-' || op == '+')) {
            modifier = modifier.substring(0, modifier.length() - 2);
        }
        switch (modifier) {
            case "PUBLIC": {
                return AccessTransformer.Modifier.PUBLIC;
            }
            case "PROTECTED": {
                return AccessTransformer.Modifier.PROTECTED;
            }
            case "DEFAULT": {
                return AccessTransformer.Modifier.DEFAULT;
            }
            case "PRIVATE": {
                return AccessTransformer.Modifier.PRIVATE;
            }
        }
        return null;
    }

    public static AccessTransformer.FinalState finalState(String modifierString) {
        String modifier = modifierString.toUpperCase(Locale.ROOT);
        char f = modifier.charAt(modifier.length() - 1);
        if (f != 'F') {
            return AccessTransformer.FinalState.LEAVE;
        }
        char op = modifier.charAt(modifier.length() - 2);
        if (op == '-') {
            return AccessTransformer.FinalState.REMOVEFINAL;
        }
        if (op == '+') {
            return AccessTransformer.FinalState.MAKEFINAL;
        }
        return AccessTransformer.FinalState.LEAVE;
    }
}

