/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class UDFUtil {
    public static int getUInt8(byte[] block, int pos) {
        return LittleEndian.getUInt8((byte[])block, (int)pos);
    }

    public static int getUInt16(byte[] block, int pos) {
        return LittleEndian.getUInt16((byte[])block, (int)pos);
    }

    public static long getUInt32(byte[] block, int pos) {
        return LittleEndian.getUInt32((byte[])block, (int)pos);
    }

    public static BigInteger getUInt64(byte[] block, int pos) {
        byte[] fragment = UDFUtil.getBytes(block, pos, 8);
        ArrayUtils.reverse((byte[])fragment);
        return new BigInteger(fragment);
    }

    public static byte[] getBytes(byte[] bytes, int pos, int length) {
        return Arrays.copyOfRange(bytes, pos, pos + length);
    }

    public static byte[] getRemainingBytes(byte[] bytes, int pos) {
        return Arrays.copyOfRange(bytes, pos, bytes.length);
    }
}

