/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringBinaryAdapter;
import org.tinymediamanager.library.bluray.clipinf.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.clipinf.HexStringShortAdapter;

@XmlType(propOrder={"const0x00010001", "const0x10110004", "unknownvalue1", "unknownvalue2", "const0x0000000e", "bytes"})
public class AddrMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddrMap.class);
    private Integer const0x00010001;
    private Integer const0x10110004;
    private Short unknownvalue1;
    private Short unknownvalue2;
    private Integer const0x0000000e;
    private byte[] bytes;

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x00010001() {
        return this.const0x00010001;
    }

    public void setConst0x00010001(Integer n) {
        this.const0x00010001 = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x10110004() {
        return this.const0x10110004;
    }

    public void setConst0x10110004(Integer n) {
        this.const0x10110004 = n;
    }

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getUnknownvalue1() {
        return this.unknownvalue1;
    }

    public void setUnknownvalue1(Short s) {
        this.unknownvalue1 = s;
    }

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getUnknownvalue2() {
        return this.unknownvalue2;
    }

    public void setUnknownvalue2(Short s) {
        this.unknownvalue2 = s;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x0000000e() {
        return this.const0x0000000e;
    }

    public void setConst0x0000000e(Integer n) {
        this.const0x0000000e = n;
    }

    @XmlJavaTypeAdapter(value=HexStringBinaryAdapter.class)
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("AddrMap length={}", (Object)n);
        this.const0x00010001 = dataInputStream.readInt();
        LOGGER.trace("AddrMap const0x00010001={}", (Object)this.const0x00010001);
        this.const0x10110004 = dataInputStream.readInt();
        LOGGER.trace("AddrMap const0x10110004={}", (Object)this.const0x10110004);
        this.unknownvalue1 = dataInputStream.readShort();
        LOGGER.trace("AddrMap unknownvalue1={}", (Object)this.unknownvalue1);
        this.unknownvalue2 = dataInputStream.readShort();
        LOGGER.trace("AddrMap unknownvalue2={}", (Object)this.unknownvalue2);
        this.const0x0000000e = dataInputStream.readInt();
        LOGGER.trace("AddrMap const0x0000000e={}", (Object)this.const0x0000000e);
        this.bytes = new byte[n - 16];
        dataInputStream.read(this.bytes);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.bytes.length + 16);
        dataOutputStream.writeInt(this.getConst0x00010001());
        dataOutputStream.writeInt(this.getConst0x10110004());
        dataOutputStream.writeShort(this.getUnknownvalue1().shortValue());
        dataOutputStream.writeShort(this.getUnknownvalue2().shortValue());
        dataOutputStream.writeInt(this.getConst0x0000000e());
        dataOutputStream.write(this.bytes);
    }
}

