/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.AbstractTmmUIFilter;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.moviesets.filters.IMovieSetUIFilter;

abstract class AbstractMovieSetUIFilter
extends AbstractTmmUIFilter<TmmTreeNode>
implements IMovieSetUIFilter<TmmTreeNode> {
    AbstractMovieSetUIFilter() {
    }

    @Override
    public boolean isActive() {
        switch (this.getFilterState()) {
            case ACTIVE: 
            case ACTIVE_NEGATIVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(TmmTreeNode node) {
        if (this.getFilterState() == ITmmUIFilter.FilterState.INACTIVE) {
            return true;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)userObject;
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE) {
                return this.accept(movieSet, new ArrayList<Movie>(movieSet.getMoviesForDisplay()));
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE_NEGATIVE) {
                return !this.accept(movieSet, new ArrayList<Movie>(movieSet.getMoviesForDisplay()));
            }
        } else if (userObject instanceof Movie) {
            Movie movie = (Movie)userObject;
            if (movie.getMovieSet() == null) {
                return false;
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE) {
                return this.accept(movie.getMovieSet(), Collections.singletonList(movie));
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE_NEGATIVE) {
                return !this.accept(movie.getMovieSet(), Collections.singletonList(movie));
            }
        }
        return true;
    }

    protected abstract boolean accept(MovieSet var1, List<Movie> var2);

    @Override
    protected void filterChanged() {
        SwingUtilities.invokeLater(() -> this.firePropertyChange("treeFilterChanged", this.checkBox.isSelected(), !this.checkBox.isSelected()));
    }
}

