/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class FilterSavePanel
extends AbstractModalInputPanel {
    private final JTextField tfPresetName;
    private final JRadioButton rdbtnNewPreset;
    private final JRadioButton rdbtnOverwritePreset;
    private final JComboBox<String> cbPresets;
    private final Set<AbstractSettings.UIFilters> filter;
    private final Map<String, List<AbstractSettings.UIFilters>> existingFilters;
    private String savedPreset = "";

    public FilterSavePanel(Set<AbstractSettings.UIFilters> filter, Map<String, List<AbstractSettings.UIFilters>> existingFilters) {
        this.filter = filter;
        this.existingFilters = existingFilters;
        this.setLayout((LayoutManager)new MigLayout("", "[][100lp:n,grow]", "[][]"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdbtnNewPreset = new JRadioButton(TmmResourceBundle.getString("filter.savenew"));
        buttonGroup.add(this.rdbtnNewPreset);
        this.rdbtnNewPreset.setSelected(true);
        this.add((Component)this.rdbtnNewPreset, "cell 0 0");
        this.tfPresetName = new JTextField();
        this.add((Component)this.tfPresetName, "cell 1 0,growx");
        this.tfPresetName.setColumns(10);
        this.rdbtnOverwritePreset = new JRadioButton(TmmResourceBundle.getString("filter.overwrite"));
        buttonGroup.add(this.rdbtnOverwritePreset);
        this.add((Component)this.rdbtnOverwritePreset, "cell 0 1");
        this.cbPresets = new JComboBox<String>(existingFilters.keySet().toArray(new String[0]));
        if (!existingFilters.isEmpty()) {
            this.cbPresets.setSelectedIndex(0);
        } else {
            this.rdbtnOverwritePreset.setEnabled(false);
            this.cbPresets.setEnabled(false);
        }
        this.add(this.cbPresets, "cell 1 1,growx");
        SwingUtilities.invokeLater(this.tfPresetName::requestFocus);
    }

    @Override
    protected void onClose() {
        String name = this.rdbtnOverwritePreset.isSelected() ? (String)this.cbPresets.getSelectedItem() : this.tfPresetName.getText();
        if (StringUtils.isBlank((CharSequence)name)) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("filter.emptyname"));
            return;
        }
        this.existingFilters.put(name, new ArrayList<AbstractSettings.UIFilters>(this.filter));
        this.savedPreset = name;
        this.setVisible(false);
    }

    public String getSavedPreset() {
        return this.savedPreset;
    }
}

