/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.gena.GENASubscription;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.RegistryImpl;
import org.fourthline.cling.registry.RegistryItem;

abstract class RegistryItems<D extends Device, S extends GENASubscription> {
    protected final RegistryImpl registry;
    protected final Set<RegistryItem<UDN, D>> deviceItems = new HashSet<RegistryItem<UDN, D>>();
    protected final Set<RegistryItem<String, S>> subscriptionItems = new HashSet<RegistryItem<String, S>>();

    RegistryItems(RegistryImpl registry) {
        this.registry = registry;
    }

    Set<RegistryItem<UDN, D>> getDeviceItems() {
        return this.deviceItems;
    }

    Set<RegistryItem<String, S>> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    abstract void add(D var1);

    abstract boolean remove(D var1);

    abstract void removeAll();

    abstract void maintain();

    abstract void shutdown();

    D get(UDN udn, boolean rootOnly) {
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Object foundDevice;
            Device device = (Device)item.getItem();
            if (((DeviceIdentity)device.getIdentity()).getUdn().equals(udn)) {
                return (D)device;
            }
            if (rootOnly || (foundDevice = ((Device)item.getItem()).findDevice(udn)) == null) continue;
            return foundDevice;
        }
        return null;
    }

    Collection<D> get(DeviceType deviceType) {
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Device[] d = ((Device)item.getItem()).findDevices(deviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(d));
        }
        return devices;
    }

    Collection<D> get(ServiceType serviceType) {
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            Device[] d = ((Device)item.getItem()).findDevices(serviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(d));
        }
        return devices;
    }

    Collection<D> get() {
        HashSet<D> devices = new HashSet<D>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            devices.add(item.getItem());
        }
        return devices;
    }

    boolean contains(D device) {
        return this.contains(((DeviceIdentity)((Device)device).getIdentity()).getUdn());
    }

    boolean contains(UDN udn) {
        return this.deviceItems.contains(new RegistryItem(udn));
    }

    void addSubscription(S subscription) {
        RegistryItem<String, S> subscriptionItem = new RegistryItem<String, S>(((GENASubscription)subscription).getSubscriptionId(), subscription, ((GENASubscription)subscription).getActualDurationSeconds());
        this.subscriptionItems.add(subscriptionItem);
    }

    boolean updateSubscription(S subscription) {
        if (this.removeSubscription(subscription)) {
            this.addSubscription(subscription);
            return true;
        }
        return false;
    }

    boolean removeSubscription(S subscription) {
        return this.subscriptionItems.remove(new RegistryItem(((GENASubscription)subscription).getSubscriptionId()));
    }

    S getSubscription(String subscriptionId) {
        for (RegistryItem<String, S> registryItem : this.subscriptionItems) {
            if (!registryItem.getKey().equals(subscriptionId)) continue;
            return (S)((GENASubscription)registryItem.getItem());
        }
        return null;
    }

    Resource[] getResources(Device device) throws RegistrationException {
        try {
            return this.registry.getConfiguration().getNamespace().getResources(device);
        }
        catch (ValidationException ex) {
            throw new RegistrationException("Resource discover error: " + ex.toString(), ex);
        }
    }
}

